/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.QueryEngine;

class SessionFactoryObserverForNamedQueryValidation
implements SessionFactoryObserver {
    private final Metadata metadata;

    SessionFactoryObserverForNamedQueryValidation(MetadataImplementor metadata) {
        this.metadata = metadata;
    }

    @Override
    public void sessionFactoryCreated(SessionFactory factory) {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)factory;
        QueryEngine queryEngine = sessionFactory.getQueryEngine();
        queryEngine.getNamedObjectRepository().prepare(sessionFactory, this.metadata);
        if (sessionFactory.getSessionFactoryOptions().isNamedQueryStartupCheckingEnabled()) {
            queryEngine.validateNamedQueries();
        }
    }
}

