/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.Properties;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.usertype.ParameterizedType;

public class DelayedParameterizedTypeBean<T>
implements ManagedBean<T> {
    private final ManagedBean<T> underlyingBean;
    private final Properties properties;
    private T instance;

    public DelayedParameterizedTypeBean(ManagedBean<T> underlyingBean, Properties properties) {
        assert (ParameterizedType.class.isAssignableFrom(underlyingBean.getBeanClass()));
        this.underlyingBean = underlyingBean;
        this.properties = properties;
    }

    @Override
    public Class<T> getBeanClass() {
        return this.underlyingBean.getBeanClass();
    }

    @Override
    public T getBeanInstance() {
        if (this.instance == null) {
            this.instance = this.underlyingBean.getBeanInstance();
            ((ParameterizedType)this.instance).setParameterValues(this.properties);
        }
        return this.instance;
    }
}

