/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.ForeignKey;
import jakarta.persistence.MapKeyJoinColumn;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMapKeyJoinColumnImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.internal.db.ForeignKeyProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.ModelsContext;

public class MapKeyJoinColumnJpaAnnotation
implements MapKeyJoinColumn {
    private String name;
    private String referencedColumnName;
    private boolean unique;
    private boolean nullable;
    private boolean insertable;
    private boolean updatable;
    private String columnDefinition;
    private String options;
    private String table;
    private ForeignKey foreignKey;

    public MapKeyJoinColumnJpaAnnotation(ModelsContext modelContext) {
        this.name = "";
        this.referencedColumnName = "";
        this.unique = false;
        this.nullable = false;
        this.insertable = true;
        this.updatable = true;
        this.columnDefinition = "";
        this.options = "";
        this.table = "";
        this.foreignKey = (ForeignKey)JpaAnnotations.FOREIGN_KEY.createUsage(modelContext);
    }

    public MapKeyJoinColumnJpaAnnotation(MapKeyJoinColumn annotation, ModelsContext modelContext) {
        this.name = annotation.name();
        this.referencedColumnName = annotation.referencedColumnName();
        this.unique = annotation.unique();
        this.nullable = annotation.nullable();
        this.insertable = annotation.insertable();
        this.updatable = annotation.updatable();
        this.columnDefinition = annotation.columnDefinition();
        this.options = annotation.options();
        this.table = annotation.table();
        this.foreignKey = (ForeignKey)OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.MAP_KEY_JOIN_COLUMN, "foreignKey", modelContext);
    }

    public MapKeyJoinColumnJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.referencedColumnName = (String)attributeValues.get("referencedColumnName");
        this.unique = (Boolean)attributeValues.get("unique");
        this.nullable = (Boolean)attributeValues.get("nullable");
        this.insertable = (Boolean)attributeValues.get("insertable");
        this.updatable = (Boolean)attributeValues.get("updatable");
        this.columnDefinition = (String)attributeValues.get("columnDefinition");
        this.options = (String)attributeValues.get("options");
        this.table = (String)attributeValues.get("table");
        this.foreignKey = (ForeignKey)attributeValues.get("foreignKey");
    }

    public Class<? extends Annotation> annotationType() {
        return MapKeyJoinColumn.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public String referencedColumnName() {
        return this.referencedColumnName;
    }

    public void referencedColumnName(String value) {
        this.referencedColumnName = value;
    }

    public boolean unique() {
        return this.unique;
    }

    public void unique(boolean value) {
        this.unique = value;
    }

    public boolean nullable() {
        return this.nullable;
    }

    public void nullable(boolean value) {
        this.nullable = value;
    }

    public boolean insertable() {
        return this.insertable;
    }

    public void insertable(boolean value) {
        this.insertable = value;
    }

    public boolean updatable() {
        return this.updatable;
    }

    public void updatable(boolean value) {
        this.updatable = value;
    }

    public String columnDefinition() {
        return this.columnDefinition;
    }

    public void columnDefinition(String value) {
        this.columnDefinition = value;
    }

    public String options() {
        return this.options;
    }

    public void options(String value) {
        this.options = value;
    }

    public String table() {
        return this.table;
    }

    public void table(String value) {
        this.table = value;
    }

    public ForeignKey foreignKey() {
        return this.foreignKey;
    }

    public void foreignKey(ForeignKey value) {
        this.foreignKey = value;
    }

    public void apply(JaxbMapKeyJoinColumnImpl jaxbColumn, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isNotEmpty(jaxbColumn.getName())) {
            this.name(jaxbColumn.getName());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getTable())) {
            this.table(jaxbColumn.getTable());
        }
        if (jaxbColumn.isNullable() != null) {
            this.nullable(jaxbColumn.isNullable());
        }
        if (jaxbColumn.isInsertable() != null) {
            this.insertable(jaxbColumn.isInsertable());
        }
        if (jaxbColumn.isInsertable() != null) {
            this.updatable(jaxbColumn.isUpdatable());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getColumnDefinition())) {
            this.columnDefinition(jaxbColumn.getColumnDefinition());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getOptions())) {
            this.options(jaxbColumn.getOptions());
        }
        if (jaxbColumn.isUnique() != null) {
            this.unique(jaxbColumn.isUnique());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getReferencedColumnName())) {
            this.referencedColumnName(jaxbColumn.getReferencedColumnName());
        }
        if (jaxbColumn.getForeignKey() != null) {
            this.foreignKey(ForeignKeyProcessing.createNestedForeignKeyAnnotation(jaxbColumn.getForeignKey(), xmlDocumentContext));
        }
    }
}

