/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.type;

import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class PostgreSQLArrayJdbcType
extends ArrayJdbcType {
    public PostgreSQLArrayJdbcType(JdbcType elementJdbcType) {
        super(elementJdbcType);
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        BasicPluralJavaType pluralJavaType = (BasicPluralJavaType)((Object)javaTypeDescriptor);
        final ValueBinder elementBinder = this.getElementJdbcType().getBinder(pluralJavaType.getElementJavaType());
        return new BasicBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setArray(index, this.getArray(value, options));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Array arr = this.getArray(value, options);
                try {
                    st.setObject(name, (Object)arr, 2003);
                }
                catch (SQLException ex) {
                    throw new HibernateException("JDBC driver does not support named parameters for setArray. Use positional.", ex);
                }
            }

            @Override
            public Object getBindValue(X value, WrapperOptions options) throws SQLException {
                return ((PostgreSQLArrayJdbcType)this.getJdbcType()).getArray(this, elementBinder, value, options);
            }

            private Array getArray(X value, WrapperOptions options) throws SQLException {
                Object[] objects;
                PostgreSQLArrayJdbcType arrayJdbcType = (PostgreSQLArrayJdbcType)this.getJdbcType();
                JdbcType elementJdbcType = arrayJdbcType.getElementJdbcType();
                if (elementJdbcType instanceof AggregateJdbcType) {
                    AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)elementJdbcType;
                    Object[] domainObjects = this.getJavaType().unwrap(value, Object[].class, options);
                    objects = new Object[domainObjects.length];
                    for (int i = 0; i < domainObjects.length; ++i) {
                        if (domainObjects[i] == null) continue;
                        objects[i] = aggregateJdbcType.createJdbcValue(domainObjects[i], options);
                    }
                } else {
                    objects = arrayJdbcType.getArray(this, elementBinder, value, options);
                }
                SharedSessionContractImplementor session = options.getSession();
                String typeName = arrayJdbcType.getElementTypeName(this.getJavaType(), session);
                return session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection().createArrayOf(typeName, objects);
            }
        };
    }

    @Override
    public String toString() {
        return "PostgreSQLArrayTypeDescriptor(" + this.getElementJdbcType().toString() + ")";
    }
}

