/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class LazySet<T> {
    private final Supplier<Set<T>> setBuilder;
    private Set<T> set;

    public LazySet() {
        this(HashSet::new);
    }

    public LazySet(Supplier<Set<T>> setBuilder) {
        this.setBuilder = setBuilder;
    }

    public void add(T element) {
        if (this.set == null) {
            this.set = this.setBuilder.get();
        }
        this.set.add(element);
    }

    public void forEach(Consumer<T> action) {
        if (this.set == null) {
            return;
        }
        this.set.forEach(action);
    }

    public Set<T> getUnderlyingSet() {
        return this.set == null ? Collections.emptySet() : this.set;
    }
}

