/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.spi;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Internal;
import org.hibernate.property.access.internal.AbstractFieldSerialForm;
import org.hibernate.property.access.internal.AccessStrategyHelper;
import org.hibernate.property.access.spi.SetterFieldImpl;

@Internal
public class EnhancedSetterImpl
extends SetterFieldImpl {
    private final String propertyName;
    private final int enhancementState;

    public EnhancedSetterImpl(Class<?> containerClass, String propertyName, Field field) {
        super(containerClass, propertyName, field);
        this.propertyName = propertyName;
        this.enhancementState = AccessStrategyHelper.determineEnhancementState(containerClass, field.getType());
    }

    @Override
    public void set(Object target, @Nullable Object value) {
        super.set(target, value);
        AccessStrategyHelper.handleEnhancedInjection(target, value, this.enhancementState, this.propertyName);
    }

    private Object writeReplace() {
        return new SerialForm(this.getContainerClass(), this.propertyName, this.getField());
    }

    private static class SerialForm
    extends AbstractFieldSerialForm
    implements Serializable {
        private final Class<?> containerClass;
        private final String propertyName;

        private SerialForm(Class<?> containerClass, String propertyName, Field field) {
            super(field);
            this.containerClass = containerClass;
            this.propertyName = propertyName;
        }

        private Object readResolve() {
            return new EnhancedSetterImpl(this.containerClass, this.propertyName, this.resolveField());
        }
    }
}

