/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.select;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.sqm.tree.expression.SqmAliasedNodeRef;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SortSpecification;

public abstract class QueryPart
implements SqlAstNode {
    private final boolean isRoot;
    private boolean hasPositionalSortItem;
    private List<SortSpecification> sortSpecifications;
    private Expression offsetClauseExpression;
    private Expression fetchClauseExpression;
    private FetchClauseType fetchClauseType = FetchClauseType.ROWS_ONLY;

    public QueryPart(boolean isRoot) {
        this.isRoot = isRoot;
    }

    protected QueryPart(boolean isRoot, QueryPart original) {
        this.isRoot = isRoot;
        this.hasPositionalSortItem = original.hasPositionalSortItem;
        this.sortSpecifications = original.sortSpecifications;
        this.offsetClauseExpression = original.offsetClauseExpression;
        this.fetchClauseExpression = original.fetchClauseExpression;
        this.fetchClauseType = original.fetchClauseType;
    }

    public abstract QuerySpec getFirstQuerySpec();

    public abstract QuerySpec getLastQuerySpec();

    public abstract void visitQuerySpecs(Consumer<QuerySpec> var1);

    public abstract <T> T queryQuerySpecs(Function<QuerySpec, T> var1);

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean hasSortSpecifications() {
        return this.sortSpecifications != null && !this.sortSpecifications.isEmpty();
    }

    public boolean hasPositionalSortItem() {
        return this.hasPositionalSortItem;
    }

    public List<SortSpecification> getSortSpecifications() {
        return this.sortSpecifications;
    }

    public void visitSortSpecifications(Consumer<SortSpecification> consumer) {
        if (this.sortSpecifications != null) {
            this.sortSpecifications.forEach(consumer);
        }
    }

    public void addSortSpecification(SortSpecification specification) {
        if (this.sortSpecifications == null) {
            this.sortSpecifications = new ArrayList<SortSpecification>();
        }
        this.sortSpecifications.add(specification);
        if (this.isRoot && specification.getSortExpression() instanceof SqmAliasedNodeRef) {
            this.hasPositionalSortItem = true;
        }
    }

    public boolean hasOffsetOrFetchClause() {
        return this.offsetClauseExpression != null || this.fetchClauseExpression != null;
    }

    public Expression getOffsetClauseExpression() {
        return this.offsetClauseExpression;
    }

    public void setOffsetClauseExpression(Expression offsetClauseExpression) {
        this.offsetClauseExpression = offsetClauseExpression;
    }

    public Expression getFetchClauseExpression() {
        return this.fetchClauseExpression;
    }

    public void setFetchClauseExpression(Expression fetchClauseExpression, FetchClauseType fetchClauseType) {
        if (fetchClauseExpression == null) {
            this.fetchClauseExpression = null;
            this.fetchClauseType = FetchClauseType.ROWS_ONLY;
        } else {
            if (fetchClauseType == null) {
                throw new IllegalArgumentException("Fetch clause may not be null");
            }
            this.fetchClauseExpression = fetchClauseExpression;
            this.fetchClauseType = fetchClauseType;
        }
    }

    public FetchClauseType getFetchClauseType() {
        return this.fetchClauseType;
    }
}

