/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import io.quarkus.deployment.annotations.BuildProducer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class ReflectUtil {
    private static final Class<?>[] NO_CLASSES = new Class[0];

    private ReflectUtil() {
    }

    public static boolean rawTypeIs(Type type, Class<?> clazz) {
        return type instanceof Class && clazz == type || type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() == clazz || type instanceof GenericArrayType && clazz.isArray() && ReflectUtil.rawTypeIs(((GenericArrayType)type).getGenericComponentType(), clazz.getComponentType());
    }

    public static boolean rawTypeExtends(Type type, Class<?> clazz) {
        return type instanceof Class && clazz.isAssignableFrom((Class)type) || type instanceof ParameterizedType && ReflectUtil.rawTypeExtends(((ParameterizedType)type).getRawType(), clazz) || type instanceof GenericArrayType && ReflectUtil.rawTypeExtends(((GenericArrayType)type).getGenericComponentType(), clazz.getComponentType());
    }

    public static boolean isListOf(Type type, Class<?> nestedType) {
        return ReflectUtil.isThingOf(type, List.class, nestedType);
    }

    public static boolean isConsumerOf(Type type, Class<?> nestedType) {
        return ReflectUtil.isThingOf(type, Consumer.class, nestedType);
    }

    public static boolean isBuildProducerOf(Type type, Class<?> nestedType) {
        return ReflectUtil.isThingOf(type, BuildProducer.class, nestedType);
    }

    public static boolean isSupplierOf(Type type, Class<?> nestedType) {
        return ReflectUtil.isThingOf(type, Supplier.class, nestedType);
    }

    public static boolean isSupplierOfOptionalOf(Type type, Class<?> nestedType) {
        return type instanceof ParameterizedType && ReflectUtil.rawTypeIs(type, Supplier.class) && ReflectUtil.isOptionalOf(ReflectUtil.typeOfParameter(type, 0), nestedType);
    }

    public static boolean isOptionalOf(Type type, Class<?> nestedType) {
        return ReflectUtil.isThingOf(type, Optional.class, nestedType);
    }

    public static boolean isThingOf(Type type, Class<?> thing, Class<?> nestedType) {
        return type instanceof ParameterizedType && ReflectUtil.rawTypeIs(type, thing) && ReflectUtil.rawTypeExtends(ReflectUtil.typeOfParameter(type, 0), nestedType);
    }

    public static Class<?> rawTypeOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectUtil.rawTypeOf(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ReflectUtil.rawTypeOf(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        throw new IllegalArgumentException("Type has no raw type class: " + String.valueOf(type));
    }

    public static Class<?>[] rawTypesOfDestructive(Type[] types) {
        if (types.length == 0) {
            return NO_CLASSES;
        }
        for (int i = 0; i < types.length; ++i) {
            Type t = types[i];
            Class<?> r = ReflectUtil.rawTypeOf(t);
            if (r == t) continue;
            types[i] = r;
        }
        return (Class[])Arrays.copyOf(types, types.length, Class[].class);
    }

    public static Type typeOfParameter(Type type, int paramIdx) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[paramIdx];
        }
        throw new IllegalArgumentException("Type is not parameterized: " + String.valueOf(type));
    }

    public static Class<?> rawTypeOfParameter(Type type, int paramIdx) {
        return ReflectUtil.rawTypeOf(ReflectUtil.typeOfParameter(type, paramIdx));
    }

    public static void setFieldVal(Field field, Object obj, Object value) {
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw ReflectUtil.toError(e);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw ReflectUtil.toError(e);
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        catch (NoSuchMethodException e) {
            throw ReflectUtil.toError(e);
        }
        catch (IllegalAccessException e) {
            throw ReflectUtil.toError(e);
        }
    }

    public static InstantiationError toError(InstantiationException e) {
        InstantiationError error = new InstantiationError(e.getMessage());
        error.setStackTrace(e.getStackTrace());
        return error;
    }

    public static IllegalAccessError toError(IllegalAccessException e) {
        IllegalAccessError error = new IllegalAccessError(e.getMessage());
        error.setStackTrace(e.getStackTrace());
        return error;
    }

    public static NoSuchMethodError toError(NoSuchMethodException e) {
        NoSuchMethodError error = new NoSuchMethodError(e.getMessage());
        error.setStackTrace(e.getStackTrace());
        return error;
    }

    public static NoSuchFieldError toError(NoSuchFieldException e) {
        NoSuchFieldError error = new NoSuchFieldError(e.getMessage());
        error.setStackTrace(e.getStackTrace());
        return error;
    }

    public static UndeclaredThrowableException unwrapInvocationTargetException(InvocationTargetException original) {
        try {
            throw original.getCause();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            return new UndeclaredThrowableException(t);
        }
    }

    public static IllegalArgumentException reportError(AnnotatedElement e, String fmt, Object ... args) {
        if (e instanceof Member) {
            return new IllegalArgumentException(String.format(fmt, args) + " at " + String.valueOf(e) + " of " + String.valueOf(((Member)((Object)e)).getDeclaringClass()));
        }
        if (e instanceof Parameter) {
            return new IllegalArgumentException(String.format(fmt, args) + " at " + String.valueOf(e) + " of " + String.valueOf(((Parameter)e).getDeclaringExecutable()) + " of " + String.valueOf(((Parameter)e).getDeclaringExecutable().getDeclaringClass()));
        }
        return new IllegalArgumentException(String.format(fmt, args) + " at " + String.valueOf(e));
    }
}

