/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.internal.models.tags;

import io.smallrye.openapi.model.BaseExtensibleModel;
import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public abstract class AbstractTag
extends BaseExtensibleModel<Tag>
implements Tag {
    public static final PropertyMetadata PROPERTIES = new Properties();

    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }

    protected Tag filter(OASFilter filter) {
        return filter.filterTag((Tag)this);
    }

    public static class Properties
    implements PropertyMetadata {
        private final Map<String, DataType> types = new HashMap<String, DataType>(3);
        private final Map<String, OpenApiVersion> minVersions = new HashMap<String, OpenApiVersion>(3);

        public Properties() {
            this.types.put("name", DataType.type(String.class));
            this.minVersions.put("name", OpenApiVersion.V3_0);
            this.types.put("description", DataType.type(String.class));
            this.minVersions.put("description", OpenApiVersion.V3_0);
            this.types.put("externalDocs", DataType.type(ExternalDocumentation.class));
            this.minVersions.put("externalDocs", OpenApiVersion.V3_0);
        }

        public DataType getPropertyType(String name) {
            if (this.types.containsKey(name)) {
                return this.types.get(name);
            }
            return DataType.type(Object.class);
        }

        public OpenApiVersion getMinVersion(String name) {
            return this.minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}

