/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.webauthn4j.data.attestation.statement.AttestationCertificate;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CertificateUtil;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AttestationCertificatePath
extends AbstractList<X509Certificate> {
    private final int size;
    private final X509Certificate[] certificates;

    @JsonCreator
    public AttestationCertificatePath(@NotNull List<X509Certificate> certificates) {
        AssertUtil.notNull(certificates, "certificates must not be null");
        this.size = certificates.size();
        this.certificates = certificates.toArray(new X509Certificate[this.size]);
    }

    public AttestationCertificatePath(@NotNull X509Certificate attestationCertificate, @NotNull List<X509Certificate> caCertificates) {
        AssertUtil.notNull(attestationCertificate, "attestationCertificate must not be null");
        AssertUtil.notNull(caCertificates, "caCertificates must not be null");
        ArrayList<X509Certificate> buffer = new ArrayList<X509Certificate>();
        buffer.add(attestationCertificate);
        buffer.addAll(caCertificates);
        this.size = buffer.size();
        this.certificates = buffer.toArray(new X509Certificate[this.size]);
    }

    public AttestationCertificatePath() {
        this(Collections.emptyList());
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @NotNull
    public X509Certificate get(int index) {
        return this.certificates[index];
    }

    @NotNull
    public CertPath createCertPath() {
        return CertificateUtil.generateCertPath(this);
    }

    @NotNull
    public AttestationCertificate getEndEntityAttestationCertificate() {
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
        return new AttestationCertificate(this.get(0));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AttestationCertificatePath that = (AttestationCertificatePath)o;
        return this.size == that.size && Arrays.equals(this.certificates, that.certificates);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.size);
        result = 31 * result + Arrays.hashCode(this.certificates);
        return result;
    }

    @Override
    public String toString() {
        return "AttestationCertificatePath(, certificates=" + Arrays.deepToString(Arrays.stream(this.certificates).map(cert -> "[" + cert.getSubjectX500Principal().toString() + "]").toArray()) + ")";
    }
}

