/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.server;

import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerProperty
extends CoreServerProperty {
    private final Set<Origin> origins;
    private final byte[] tokenBindingId;

    @Deprecated(forRemoval=false)
    public ServerProperty(@NotNull Origin origin, @NotNull String rpId, @Nullable Challenge challenge, @Nullable byte[] tokenBindingId) {
        super(rpId, challenge);
        AssertUtil.notNull(origin, "origin must not be null");
        this.origins = Collections.singleton(origin);
        this.tokenBindingId = tokenBindingId;
    }

    @Deprecated(forRemoval=false)
    public ServerProperty(@NotNull Set<Origin> origins, @NotNull String rpId, @Nullable Challenge challenge, @Nullable byte[] tokenBindingId) {
        super(rpId, challenge);
        AssertUtil.notNull(origins, "origins must not be null");
        this.origins = Collections.unmodifiableSet(origins);
        this.tokenBindingId = tokenBindingId;
    }

    public ServerProperty(@NotNull Origin origin, @NotNull String rpId, @Nullable Challenge challenge) {
        this(origin, rpId, challenge, null);
    }

    public ServerProperty(@NotNull Set<Origin> origins, @NotNull String rpId, @Nullable Challenge challenge) {
        this(origins, rpId, challenge, null);
    }

    @NotNull
    public Set<Origin> getOrigins() {
        return this.origins;
    }

    @Deprecated(forRemoval=false)
    @Nullable
    public byte[] getTokenBindingId() {
        return this.tokenBindingId;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerProperty that = (ServerProperty)o;
        return Objects.equals(this.origins, that.origins) && Arrays.equals(this.tokenBindingId, that.tokenBindingId);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.origins);
        result = 31 * result + Arrays.hashCode(this.tokenBindingId);
        return result;
    }

    @Override
    public String toString() {
        return "ServerProperty{rpId=" + this.getRpId() + ", challenge=" + String.valueOf(this.getChallenge()) + ", origins=" + String.valueOf(this.origins) + ", tokenBindingId=" + ArrayUtil.toHexString(this.tokenBindingId) + "}";
    }
}

