/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.runtime;

import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logmanager.MDCProvider;

public enum VertxMDC implements MDCProvider
{
    INSTANCE;

    final InheritableThreadLocal<Map<String, Object>> inheritableThreadLocalMap = new InheritableThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> childValue(Map<String, Object> parentValue) {
            if (parentValue == null) {
                return null;
            }
            return new HashMap<String, Object>(parentValue);
        }

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    public String get(String key) {
        return this.get(key, this.getContext());
    }

    public Object getObject(String key) {
        return this.getObject(key, this.getContext());
    }

    public String get(String key, Context vertxContext) {
        Object value = this.getObject(key, vertxContext);
        return value != null ? value.toString() : null;
    }

    public Object getObject(String key, Context vertxContext) {
        Objects.requireNonNull(key);
        return this.contextualDataMap(vertxContext).get(key);
    }

    public String put(String key, String value) {
        return this.put(key, value, this.getContext());
    }

    public Object putObject(String key, Object value) {
        return this.putObject(key, value, this.getContext());
    }

    public String put(String key, String value, Context vertxContext) {
        Object oldValue = this.putObject(key, value, vertxContext);
        return oldValue != null ? oldValue.toString() : null;
    }

    public Object putObject(String key, Object value, Context vertxContext) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        return this.contextualDataMap(vertxContext).put(key, value);
    }

    public String remove(String key) {
        return this.remove(key, this.getContext());
    }

    public Object removeObject(String key) {
        return this.removeObject(key, this.getContext());
    }

    public String remove(String key, Context vertxContext) {
        Object oldValue = this.removeObject(key, vertxContext);
        return oldValue != null ? oldValue.toString() : null;
    }

    public Object removeObject(String key, Context vertxContext) {
        Objects.requireNonNull(key);
        return this.contextualDataMap(vertxContext).remove(key);
    }

    public Map<String, String> copy() {
        return this.copy(this.getContext());
    }

    public Map<String, Object> copyObject() {
        return this.copyObject(this.getContext());
    }

    public boolean isEmpty() {
        return this.contextualDataMap(this.getContext()).isEmpty();
    }

    public Map<String, String> copy(Context vertxContext) {
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, Object> contextualDataMap = this.contextualDataMap(vertxContext);
        for (Map.Entry<String, Object> entry : contextualDataMap.entrySet()) {
            result.put(entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    public Map<String, Object> copyObject(Context vertxContext) {
        return new HashMap<String, Object>(this.contextualDataMap(vertxContext));
    }

    public void clear() {
        this.clear(this.getContext());
    }

    public void clear(Context vertxContext) {
        this.contextualDataMap(vertxContext).clear();
    }

    private Context getContext() {
        Context context = Vertx.currentContext();
        if (context != null) {
            Context dc = VertxContext.getOrCreateDuplicatedContext((Context)context);
            VertxContextSafetyToggle.setContextSafe(dc, true);
            return dc;
        }
        return null;
    }

    private Map<String, Object> contextualDataMap(Context ctx) {
        if (ctx == null) {
            return (Map)this.inheritableThreadLocalMap.get();
        }
        ConcurrentMap lcd = Objects.requireNonNull((ContextInternal)ctx).localContextData();
        return (ConcurrentMap)lcd.computeIfAbsent(VertxMDC.class.getName(), k -> new ConcurrentHashMap());
    }
}

