/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import org.keycloak.common.VerificationException;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.ServerMacSignatureSignerContext;
import org.keycloak.crypto.ServerMacSignatureVerifierContext;
import org.keycloak.crypto.SignatureException;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.models.KeycloakSession;

public class MacSecretSignatureProvider
implements SignatureProvider {
    private final KeycloakSession session;
    private final String algorithm;

    public MacSecretSignatureProvider(KeycloakSession session, String algorithm) {
        this.session = session;
        this.algorithm = algorithm;
    }

    public SignatureSignerContext signer() throws SignatureException {
        return new ServerMacSignatureSignerContext(this.session, this.algorithm);
    }

    public SignatureSignerContext signer(KeyWrapper key) throws SignatureException {
        SignatureProvider.checkKeyForSignature((KeyWrapper)key, (String)this.algorithm, (String)"OCT");
        return new ServerMacSignatureSignerContext(key);
    }

    public SignatureVerifierContext verifier(String kid) throws VerificationException {
        return new ServerMacSignatureVerifierContext(this.session, kid, this.algorithm);
    }

    public SignatureVerifierContext verifier(KeyWrapper key) throws VerificationException {
        SignatureProvider.checkKeyForVerification((KeyWrapper)key, (String)this.algorithm, (String)"OCT");
        return new ServerMacSignatureVerifierContext(key);
    }

    public boolean isAsymmetricAlgorithm() {
        return false;
    }
}

