/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba.resolvers;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.grants.ciba.resolvers.CIBALoginUserResolver;

public class DefaultCIBALoginUserResolver
implements CIBALoginUserResolver {
    private KeycloakSession session;

    public DefaultCIBALoginUserResolver(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public UserModel getUserFromLoginHint(String loginHint) {
        return KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)this.session, (RealmModel)this.session.getContext().getRealm(), (String)loginHint);
    }

    @Override
    public String getInfoUsedByAuthentication(UserModel user) {
        return user.getUsername();
    }

    @Override
    public UserModel getUserFromInfoUsedByAuthentication(String info) {
        return KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)this.session, (RealmModel)this.session.getContext().getRealm(), (String)info);
    }

    public void close() {
    }
}

