/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy;

import java.io.IOException;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ClientPoliciesRepresentation;
import org.keycloak.representations.idm.ClientProfilesRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.clientpolicy.ClientPoliciesUtil;
import org.keycloak.services.clientpolicy.ClientPolicy;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyManager;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.ClientProfile;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.util.JsonSerialization;

public class DefaultClientPolicyManager
implements ClientPolicyManager {
    private static final Logger logger = Logger.getLogger(DefaultClientPolicyManager.class);
    private final KeycloakSession session;

    public DefaultClientPolicyManager(KeycloakSession session) {
        this.session = session;
    }

    public void triggerOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLIENT_POLICIES)) {
            return;
        }
        RealmModel realm = this.session.getContext().getRealm();
        logger.tracev("POLICY OPERATION :: context realm = {0}, event = {1}", (Object)realm.getName(), (Object)context.getEvent());
        this.doPolicyOperation(condition -> condition.applyPolicy(context), executor -> executor.executeOnEvent(context), realm);
    }

    private void doPolicyOperation(ClientConditionOperation condition, ClientExecutorOperation executor, RealmModel realm) throws ClientPolicyException {
        List<ClientPolicy> list = ClientPoliciesUtil.getEnabledClientPolicies(this.session, realm);
        if (list == null || list.isEmpty()) {
            logger.trace((Object)"POLICY OPERATION :: No enabled policy.");
            return;
        }
        for (ClientPolicy policy : list) {
            logger.tracev("POLICY OPERATION :: policy name = {0}", (Object)policy.getName());
            if (!this.isSatisfied(policy, condition)) {
                logger.tracev("POLICY UNSATISFIED :: policy name = {0}", (Object)policy.getName());
                continue;
            }
            logger.tracev("POLICY APPLIED :: policy name = {0}", (Object)policy.getName());
            this.execute(policy, executor, realm);
        }
    }

    private boolean isSatisfied(ClientPolicy policy, ClientConditionOperation op) throws ClientPolicyException {
        if (policy.getConditions() == null || policy.getConditions().isEmpty()) {
            logger.tracev("NO CONDITION :: policy name = {0}", (Object)policy.getName());
            return false;
        }
        boolean ret = false;
        for (ClientPolicyConditionProvider condition : policy.getConditions()) {
            logger.tracev("CONDITION OPERATION :: policy name = {0}, condition name = {1}, provider id = {2}", (Object)policy.getName(), (Object)condition.getName(), (Object)condition.getProviderId());
            try {
                ClientPolicyVote vote = op.run(condition);
                if (condition.isNegativeLogic()) {
                    if (vote == ClientPolicyVote.YES) {
                        vote = ClientPolicyVote.NO;
                    } else if (vote == ClientPolicyVote.NO) {
                        vote = ClientPolicyVote.YES;
                    }
                }
                if (vote == ClientPolicyVote.ABSTAIN) {
                    logger.tracev("CONDITION SKIP :: policy name = {0}, condition name = {1}, provider id = {2}", (Object)policy.getName(), (Object)condition.getName(), (Object)condition.getProviderId());
                    continue;
                }
                if (vote == ClientPolicyVote.NO) {
                    logger.tracev("CONDITION NEGATIVE :: policy name = {0}, condition name = {1}, provider id = {2}", (Object)policy.getName(), (Object)condition.getName(), (Object)condition.getProviderId());
                    return false;
                }
                ret = true;
            }
            catch (ClientPolicyException e) {
                logger.tracev("CONDITION EXCEPTION :: policy name = {0}, provider id = {1}, error = {2}, error detail = {3}", new Object[]{condition.getName(), condition.getProviderId(), e.getError(), e.getErrorDetail()});
                throw e;
            }
        }
        if (ret) {
            logger.tracev("CONDITIONS SATISFIED :: policy name = {0}", (Object)policy.getName());
        } else {
            logger.tracev("CONDITIONS UNSATISFIED :: policy name = {0}", (Object)policy.getName());
        }
        return ret;
    }

    private void execute(ClientPolicy policy, ClientExecutorOperation op, RealmModel realm) throws ClientPolicyException {
        if (policy.getProfiles() == null || policy.getProfiles().isEmpty()) {
            logger.tracev("NO PROFILE :: policy name = {0}", (Object)policy.getName());
            return;
        }
        ClientProfilesRepresentation clientProfiles = ClientPoliciesUtil.getClientProfilesRepresentation(this.session, realm);
        for (String profileName : policy.getProfiles()) {
            ClientProfile profile = ClientPoliciesUtil.getClientProfileModel(this.session, realm, clientProfiles, ClientPoliciesUtil.getGlobalClientProfiles(this.session), profileName);
            if (profile == null) {
                logger.tracev("PROFILE NOT FOUND :: policy name = {0}, profile name = {1}", (Object)policy.getName(), (Object)profileName);
                continue;
            }
            if (profile.getExecutors() == null || profile.getExecutors().isEmpty()) {
                logger.tracev("PROFILE NO EXECUTOR :: policy name = {0}, profile name = {1}", (Object)policy.getName(), (Object)profileName);
                continue;
            }
            for (ClientPolicyExecutorProvider executor : profile.getExecutors()) {
                logger.tracev("EXECUTION :: policy name = {0}, profile name = {1}, executor name = {2}, provider id = {3}", new Object[]{policy.getName(), profileName, executor.getName(), executor.getProviderId()});
                try {
                    op.run(executor);
                }
                catch (ClientPolicyException e) {
                    logger.tracev("EXECUTOR EXCEPTION :: executor name = {0}, provider id = {1}, error = {2}, error detail = {3}", new Object[]{executor.getName(), executor.getProviderId(), e.getError(), e.getErrorDetail()});
                    throw e;
                }
            }
        }
    }

    public void setupClientPoliciesOnCreatedRealm(RealmModel realm) {
    }

    public void updateRealmModelFromRepresentation(RealmModel realm, RealmRepresentation rep) {
        ClientPoliciesRepresentation clientPolicies;
        logger.tracev("LOAD PROFILE POLICIES ON IMPORTED REALM :: realm = {0}", (Object)realm.getName());
        if (rep.getParsedClientProfiles() != null) {
            try {
                this.updateClientProfiles(realm, rep.getParsedClientProfiles());
            }
            catch (ClientPolicyException e) {
                logger.warnv("VALIDATE SERIALIZE IMPORTED REALM PROFILES FAILED :: error = {0}, error detail = {1}", (Object)e.getError(), (Object)e.getErrorDetail());
                throw new RuntimeException("Failed to update client profiles", e);
            }
        }
        if ((clientPolicies = rep.getParsedClientPolicies()) != null) {
            try {
                this.updateClientPolicies(realm, clientPolicies);
            }
            catch (ClientPolicyException e) {
                logger.warnv("VALIDATE SERIALIZE IMPORTED REALM POLICIES FAILED :: error = {0}, error detail = {1}", (Object)e.getError(), (Object)e.getErrorDetail());
                throw new RuntimeException("Failed to update client policies", e);
            }
        } else {
            this.setupClientPoliciesOnCreatedRealm(realm);
        }
    }

    public void updateClientProfiles(RealmModel realm, ClientProfilesRepresentation clientProfiles) throws ClientPolicyException {
        try {
            if (clientProfiles == null) {
                throw new ClientPolicyException("Passing null clientProfiles not allowed");
            }
            ClientProfilesRepresentation validatedProfilesRep = ClientPoliciesUtil.getValidatedClientProfilesForUpdate(this.session, realm, clientProfiles, ClientPoliciesUtil.getGlobalClientProfiles(this.session));
            String validatedJsonString = ClientPoliciesUtil.convertClientProfilesRepresentationToJson(validatedProfilesRep);
            ClientPoliciesUtil.setClientProfilesJsonString(realm, validatedJsonString);
            logger.tracev("UPDATE PROFILES :: realm = {0}, validated and modified PUT = {1}", (Object)realm.getName(), (Object)validatedJsonString);
        }
        catch (ClientPolicyException e) {
            logger.warnv("VALIDATE SERIALIZE PROFILES FAILED :: error = {0}, error detail = {1}", (Object)e.getError(), (Object)e.getErrorDetail());
            throw e;
        }
    }

    public ClientProfilesRepresentation getClientProfiles(RealmModel realm, boolean includeGlobalProfiles) throws ClientPolicyException {
        try {
            ClientProfilesRepresentation clientProfiles = ClientPoliciesUtil.getClientProfilesRepresentation(this.session, realm);
            if (includeGlobalProfiles) {
                clientProfiles.setGlobalProfiles(ClientPoliciesUtil.getGlobalClientProfiles(this.session));
            }
            if (logger.isTraceEnabled()) {
                logger.tracev("GET PROFILES :: realm = {0}, GET = {1}", (Object)realm.getName(), (Object)JsonSerialization.writeValueAsString((Object)clientProfiles));
            }
            return clientProfiles;
        }
        catch (ClientPolicyException e) {
            logger.warnv("GET CLIENT PROFILES FAILED :: error = {0}, error detail = {1}", (Object)e.getError(), (Object)e.getErrorDetail());
            throw e;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unexpected exception when converting JSON to String", ioe);
        }
    }

    public void updateClientPolicies(RealmModel realm, ClientPoliciesRepresentation clientPolicies) throws ClientPolicyException {
        String validatedJsonString = null;
        try {
            if (clientPolicies == null) {
                throw new ClientPolicyException("Passing null clientPolicies not allowed");
            }
            ClientPoliciesRepresentation clientPoliciesRep = ClientPoliciesUtil.getValidatedClientPoliciesForUpdate(this.session, realm, clientPolicies, ClientPoliciesUtil.getGlobalClientProfiles(this.session), ClientPoliciesUtil.getGlobalClientPolicies(this.session));
            validatedJsonString = ClientPoliciesUtil.convertClientPoliciesRepresentationToJson(clientPoliciesRep);
        }
        catch (ClientPolicyException e) {
            logger.warnv("VALIDATE SERIALIZE POLICIES FAILED :: error = {0}, error detail = {1}", (Object)e.getError(), (Object)e.getErrorDetail());
            throw e;
        }
        ClientPoliciesUtil.setClientPoliciesJsonString(realm, validatedJsonString);
        logger.tracev("UPDATE POLICIES :: realm = {0}, validated and modified PUT = {1}", (Object)realm.getName(), (Object)validatedJsonString);
    }

    public ClientPoliciesRepresentation getClientPolicies(RealmModel realm, boolean includeGlobalPolicies) throws ClientPolicyException {
        try {
            ClientPoliciesRepresentation clientPolicies = ClientPoliciesUtil.getClientPoliciesRepresentation(this.session, realm);
            if (includeGlobalPolicies) {
                clientPolicies.setGlobalPolicies(ClientPoliciesUtil.getGlobalClientPolicies(this.session));
            }
            if (logger.isTraceEnabled()) {
                logger.tracev("GET POLICIES :: realm = {0}, GET = {1}", (Object)realm.getName(), (Object)JsonSerialization.writeValueAsString((Object)clientPolicies));
            }
            return clientPolicies;
        }
        catch (ClientPolicyException e) {
            logger.warnv("GET CLIENT POLICIES FAILED :: error = {0}, error detail = {1}", (Object)e.getError(), (Object)e.getErrorDetail());
            throw e;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unexpected exception when converting JSON to String", ioe);
        }
    }

    public void updateRealmRepresentationFromModel(RealmModel realm, RealmRepresentation rep) {
        try {
            ClientProfilesRepresentation filteredOutProfiles = this.getClientProfiles(realm, false);
            rep.setParsedClientProfiles(filteredOutProfiles);
            ClientPoliciesRepresentation filteredOutPolicies = this.getClientPolicies(realm, false);
            rep.setParsedClientPolicies(filteredOutPolicies);
        }
        catch (ClientPolicyException cpe) {
            throw new IllegalStateException("Exception during export client profiles or client policies", cpe);
        }
    }

    public void close() {
    }

    private static interface ClientConditionOperation {
        public ClientPolicyVote run(ClientPolicyConditionProvider var1) throws ClientPolicyException;
    }

    private static interface ClientExecutorOperation {
        public void run(ClientPolicyExecutorProvider var1) throws ClientPolicyException;
    }
}

