/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.math.BigInteger;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeStatus;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.DropSequenceChange;
import liquibase.database.Database;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateSequenceStatement;
import liquibase.structure.core.Sequence;
import lombok.Generated;

@DatabaseChange(name="createSequence", description="Creates a new database sequence", priority=1)
public class CreateSequenceChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String sequenceName;
    private BigInteger startValue;
    private BigInteger incrementBy;
    private BigInteger maxValue;
    private BigInteger minValue;
    private Boolean ordered;
    private Boolean cycle;
    private BigInteger cacheSize;
    private String dataType;

    @DatabaseChangeProperty(since="3.0", description="Name of the database catalog")
    public String getCatalogName() {
        return this.catalogName;
    }

    @DatabaseChangeProperty(description="Name of the database schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    @DatabaseChangeProperty(description="Name of the sequence to create")
    public String getSequenceName() {
        return this.sequenceName;
    }

    @DatabaseChangeProperty(description="First sequence number to be generated.", exampleValue="5")
    public BigInteger getStartValue() {
        return this.startValue;
    }

    @DatabaseChangeProperty(description="Interval between sequence numbers", exampleValue="2")
    public BigInteger getIncrementBy() {
        return this.incrementBy;
    }

    @DatabaseChangeProperty(description="Maximum value of the sequence", exampleValue="1000")
    public BigInteger getMaxValue() {
        return this.maxValue;
    }

    @DatabaseChangeProperty(description="Minimum value of the sequence", exampleValue="10")
    public BigInteger getMinValue() {
        return this.minValue;
    }

    @DatabaseChangeProperty(description="Whether the sequence is generated in the requested order")
    public Boolean isOrdered() {
        return this.ordered;
    }

    @DatabaseChangeProperty(description="Whether the sequence cycles when it hits its max value")
    public Boolean getCycle() {
        return this.cycle;
    }

    @DatabaseChangeProperty(description="Number of values to fetch per query")
    public BigInteger getCacheSize() {
        return this.cacheSize;
    }

    @DatabaseChangeProperty(description="Data type of the sequence")
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new CreateSequenceStatement(this.getCatalogName(), this.getSchemaName(), this.getSequenceName()).setIncrementBy(this.getIncrementBy()).setMaxValue(this.getMaxValue()).setMinValue(this.getMinValue()).setOrdered(this.isOrdered()).setStartValue(this.getStartValue()).setCycle(this.getCycle()).setCacheSize(this.getCacheSize()).setDataType(this.getDataType())};
    }

    @Override
    public ChangeStatus checkStatus(Database database) {
        ChangeStatus result = new ChangeStatus();
        try {
            Sequence sequence = SnapshotGeneratorFactory.getInstance().createSnapshot(new Sequence(this.getCatalogName(), this.getSchemaName(), this.getSequenceName()), database);
            result.assertComplete(sequence != null, "Sequence " + this.getSequenceName() + " does not exist");
            if (sequence != null) {
                if (this.getIncrementBy() != null) {
                    result.assertCorrect(this.getIncrementBy().equals(sequence.getIncrementBy()), "Increment by has a different value");
                }
                if (this.getMinValue() != null) {
                    result.assertCorrect(this.getMinValue().equals(sequence.getMinValue()), "Min Value is different");
                }
                if (this.getMaxValue() != null) {
                    result.assertCorrect(this.getMaxValue().equals(sequence.getMaxValue()), "Max Value is different");
                }
                if (this.isOrdered() != null) {
                    result.assertCorrect(this.isOrdered().equals(sequence.getOrdered()), "Max Value is different");
                }
                if (this.getCycle() != null) {
                    result.assertCorrect(this.getCycle().equals(sequence.getWillCycle()), "Will Cycle is different");
                }
                if (this.getCacheSize() != null) {
                    result.assertCorrect(this.getCacheSize().equals(sequence.getCacheSize()), "Cache size is different");
                }
                if (this.getDataType() != null) {
                    result.assertCorrect(this.getDataType().equals(sequence.getDataType()), "Data type is different");
                }
            }
        }
        catch (Exception e) {
            return result.unknown(e);
        }
        return result;
    }

    @Override
    protected Change[] createInverses() {
        DropSequenceChange inverse = new DropSequenceChange();
        inverse.setSequenceName(this.getSequenceName());
        inverse.setSchemaName(this.getSchemaName());
        return new Change[]{inverse};
    }

    @Override
    public String getConfirmationMessage() {
        return "Sequence " + this.getSequenceName() + " created";
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    @Generated
    public void setStartValue(BigInteger startValue) {
        this.startValue = startValue;
    }

    @Generated
    public void setIncrementBy(BigInteger incrementBy) {
        this.incrementBy = incrementBy;
    }

    @Generated
    public void setMaxValue(BigInteger maxValue) {
        this.maxValue = maxValue;
    }

    @Generated
    public void setMinValue(BigInteger minValue) {
        this.minValue = minValue;
    }

    @Generated
    public void setOrdered(Boolean ordered) {
        this.ordered = ordered;
    }

    @Generated
    public void setCycle(Boolean cycle) {
        this.cycle = cycle;
    }

    @Generated
    public void setCacheSize(BigInteger cacheSize) {
        this.cacheSize = cacheSize;
    }

    @Generated
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }
}

