/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.ExceptionConsumer;
import io.smallrye.common.function.ExceptionFunction;
import io.smallrye.common.os.OS;
import io.smallrye.common.process.AbnormalExitException;
import io.smallrye.common.process.ArgumentRule;
import io.smallrye.common.process.IOUtil;
import io.smallrye.common.process.LineReader;
import io.smallrye.common.process.PipelineBuilder;
import io.smallrye.common.process.PipelineRunner;
import io.smallrye.common.process.ProcessBuilder;
import io.smallrye.common.process.ProcessRunner;
import io.smallrye.common.process.ProcessUtil;
import io.smallrye.common.process.WaitableProcessHandle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.IntPredicate;

final class ProcessBuilderImpl<O>
implements ProcessBuilder<O> {
    static final int IN_EMPTY = 0;
    static final int IN_INHERIT = 1;
    static final int IN_FILE = 2;
    static final int IN_HANDLER = 3;
    static final int IN_PIPELINE = 4;
    static final int IN_PIPELINE_SPLIT = 5;
    static final int OUT_DISCARD = 0;
    static final int OUT_INHERIT = 1;
    static final int OUT_FILE_WRITE = 2;
    static final int OUT_FILE_APPEND = 3;
    static final int OUT_HANDLER = 4;
    static final int OUT_PIPELINE = 5;
    static final int OUT_PIPELINE_SPLIT = 6;
    static final int ERR_DISCARD = 0;
    static final int ERR_INHERIT = 1;
    static final int ERR_FILE_WRITE = 2;
    static final int ERR_FILE_APPEND = 3;
    static final int ERR_HANDLER = 4;
    static final int ERR_REDIRECT = 5;
    final ProcessBuilderImpl<O> prev;
    final int depth;
    final Path command;
    final ArgumentRule argumentRule;
    File directory;
    boolean specialQuoting;
    private volatile boolean locked;
    List<String> arguments = List.of();
    IntPredicate exitCodeChecker = e -> e == 0;
    Duration softExitTimeout = DEFAULT_SOFT_TIMEOUT;
    Duration hardExitTimeout = DEFAULT_HARD_TIMEOUT;
    private ProcessBuilder.Input<O> input;
    int inputStrategy = 0;
    ExceptionConsumer<OutputStream, IOException> inputHandler;
    Charset inputCharset = ProcessUtil.nativeCharset();
    File inputFile;
    private PipelineBuilder.Output<O> output;
    int outputStrategy = 0;
    ExceptionFunction<InputStream, O, IOException> outputHandler;
    List<ExceptionConsumer<InputStream, IOException>> extraOutputHandlers = List.of();
    Charset outputCharset = ProcessUtil.nativeCharset();
    int outputLineLimit = 256;
    boolean outputGatherOnFail = false;
    int outputHeadLines = 5;
    int outputTailLines = 5;
    File outputFile;
    private PipelineBuilder.Error<O> error;
    int errorStrategy = 0;
    ExceptionConsumer<InputStream, IOException> errorHandler;
    List<ExceptionConsumer<InputStream, IOException>> extraErrorHandlers = List.of();
    Charset errorCharset = ProcessUtil.nativeCharset();
    int errorLineLimit = 256;
    boolean errorLogOnSuccess = true;
    boolean errorGatherOnFail = true;
    int errorHeadLines = 5;
    int errorTailLines = 5;
    File errorFile;
    Consumer<WaitableProcessHandle> whileRunning;
    final java.lang.ProcessBuilder pb = new java.lang.ProcessBuilder(new String[0]);

    private ProcessBuilderImpl(ProcessBuilderImpl<O> prev, Path command) {
        this.command = command;
        this.argumentRule = ProcessBuilderImpl.computeRule(command);
        this.prev = prev;
        this.depth = prev.depth + 1;
        this.softExitTimeout = prev.softExitTimeout;
        this.hardExitTimeout = prev.hardExitTimeout;
        this.pb.environment().clear();
        this.pb.environment().putAll(prev.pb.environment());
        this.directory = prev.directory;
        this.inputStrategy = prev.outputStrategy == 6 ? 5 : 4;
    }

    ProcessBuilderImpl(Path command) {
        this.command = command;
        this.argumentRule = ProcessBuilderImpl.computeRule(command);
        this.prev = null;
        this.depth = 1;
    }

    @Override
    public ProcessBuilder<O> arguments(List<String> arguments) {
        this.check();
        this.argumentRule.checkArguments(arguments);
        this.arguments = List.copyOf(arguments);
        return this;
    }

    @Override
    public ProcessBuilder<O> specialQuoting(boolean specialQuoting) {
        this.specialQuoting = specialQuoting;
        return this;
    }

    @Override
    public ProcessBuilder<O> directory(Path directory) {
        this.check();
        this.directory = ((Path)Assert.checkNotNullParam((String)"directory", (Object)directory)).toFile();
        return this;
    }

    @Override
    public ProcessBuilder<O> modifyEnvironment(Consumer<Map<String, String>> action) {
        this.check();
        action.accept(this.pb.environment());
        return this;
    }

    @Override
    public ProcessBuilder.Input<O> input() {
        this.check();
        if (this.prev != null) {
            throw new UnsupportedOperationException("Input may not be reconfigured on this process builder because it is a stage in a pipeline");
        }
        InputImpl input = this.input;
        if (input == null) {
            input = this.input = new InputImpl();
        }
        return input;
    }

    @Override
    public PipelineBuilder.Output<O> output() {
        this.check();
        OutputImpl output = this.output;
        if (output == null) {
            output = this.output = new OutputImpl();
        }
        return output;
    }

    @Override
    public PipelineBuilder.Error<O> error() {
        this.check();
        ErrorImpl error = this.error;
        if (error == null) {
            error = this.error = new ErrorImpl();
        }
        return error;
    }

    @Override
    public ProcessBuilder<O> exitCodeChecker(IntPredicate checker) {
        this.check();
        this.exitCodeChecker = (IntPredicate)Assert.checkNotNullParam((String)"checker", (Object)checker);
        return this;
    }

    @Override
    public ProcessBuilder<O> softExitTimeout(Duration duration) {
        this.check();
        this.softExitTimeout = duration;
        return this;
    }

    @Override
    public ProcessBuilder<O> hardExitTimeout(Duration duration) {
        this.check();
        this.hardExitTimeout = duration;
        return this;
    }

    @Override
    public ProcessBuilder<O> whileRunning(Consumer<WaitableProcessHandle> action) {
        this.check();
        this.whileRunning = (Consumer)Assert.checkNotNullParam((String)"action", action);
        return this;
    }

    @Override
    public O run() {
        this.check();
        this.locked = true;
        return this.makeRunner().run();
    }

    @Override
    public CompletableFuture<O> runAsync() {
        this.check();
        this.locked = true;
        return this.makeRunner().runAsync();
    }

    private ProcessRunner<O> makeRunner() {
        return new ProcessRunner(this, this.prev == null ? null : this.prev.makePipelineRunner());
    }

    private PipelineRunner<O> makePipelineRunner() {
        return new PipelineRunner(this, this.prev == null ? null : this.prev.makePipelineRunner());
    }

    private void check() {
        if (this.locked) {
            throw new IllegalStateException("This builder can no longer be configured");
        }
    }

    private static ArgumentRule computeRule(Path command) {
        return switch (OS.current()) {
            case OS.WINDOWS -> {
                String cmdFileName = command.getFileName().toString().toLowerCase(Locale.ROOT);
                if (cmdFileName.endsWith(".bat") || cmdFileName.endsWith(".cmd")) {
                    yield ArgumentRule.BATCH;
                }
                if (cmdFileName.endsWith(".ps1")) {
                    yield ArgumentRule.POWERSHELL;
                }
                yield ArgumentRule.DEFAULT;
            }
            default -> ArgumentRule.DEFAULT;
        };
    }

    public final class InputImpl
    extends ViewImpl
    implements ProcessBuilder.Input<O> {
        @Override
        public ProcessBuilder.Input<O> empty() {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.inputStrategy = 0;
            ProcessBuilderImpl.this.inputHandler = null;
            return this;
        }

        @Override
        public ProcessBuilder.Input<O> inherited() {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.inputStrategy = 1;
            ProcessBuilderImpl.this.inputHandler = null;
            return this;
        }

        @Override
        public ProcessBuilder.Input<O> charset(Charset charset) {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.inputCharset = (Charset)Assert.checkNotNullParam((String)"charset", (Object)charset);
            return this;
        }

        @Override
        public ProcessBuilder.Input<O> transferFrom(Path path) {
            ProcessBuilderImpl.this.check();
            Assert.checkNotNullParam((String)"path", (Object)path);
            if (path.getFileSystem() == FileSystems.getDefault()) {
                ProcessBuilderImpl.this.inputStrategy = 2;
                ProcessBuilderImpl.this.inputFile = path.toFile();
                ProcessBuilderImpl.this.inputHandler = null;
            } else {
                this.produceBytesWith((ExceptionConsumer<OutputStream, IOException>)((ExceptionConsumer)os -> {
                    try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                        is.transferTo((OutputStream)os);
                    }
                }));
            }
            return this;
        }

        @Override
        public ProcessBuilder.Input<O> produceBytesWith(ExceptionConsumer<OutputStream, IOException> consumer) {
            ProcessBuilderImpl.this.check();
            Assert.checkNotNullParam((String)"consumer", consumer);
            ProcessBuilderImpl.this.inputStrategy = 3;
            ProcessBuilderImpl.this.inputHandler = consumer;
            return this;
        }

        @Override
        public ProcessBuilder.Input<O> produceWith(ExceptionConsumer<Writer, IOException> consumer) {
            ProcessBuilderImpl.this.check();
            Assert.checkNotNullParam((String)"consumer", consumer);
            this.produceBytesWith((ExceptionConsumer<OutputStream, IOException>)((ExceptionConsumer)os -> {
                try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, ProcessBuilderImpl.this.inputCharset);
                     BufferedWriter bw = new BufferedWriter(osw);){
                    consumer.accept((Object)bw);
                }
            }));
            return this;
        }
    }

    public final class OutputImpl
    extends ViewImpl
    implements PipelineBuilder.Output<O> {
        @Override
        public PipelineBuilder.Output<Void> discard() {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.outputHandler = null;
            ProcessBuilderImpl.this.outputStrategy = 0;
            return this;
        }

        @Override
        public PipelineBuilder.Output<Void> inherited() {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.outputHandler = null;
            ProcessBuilderImpl.this.outputStrategy = 1;
            return this;
        }

        @Override
        public PipelineBuilder.Output<O> charset(Charset charset) {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.outputCharset = (Charset)Assert.checkNotNullParam((String)"charset", (Object)charset);
            return this;
        }

        @Override
        public PipelineBuilder.Output<String> toSingleString(int maxChars) {
            ProcessBuilderImpl.this.check();
            return this.processWith(br -> {
                StringBuilder sb = new StringBuilder(Math.min(192, maxChars));
                for (int n = 0; n < maxChars; ++n) {
                    int ch = br.read();
                    if (ch == -1) {
                        return sb.toString();
                    }
                    sb.append((char)ch);
                }
                IOUtil.drain(br);
                return sb.toString();
            });
        }

        @Override
        public PipelineBuilder.Output<List<String>> toStringList(int maxLines, int maxLineLength) {
            Assert.checkMinimumParameter((String)"maxLines", (int)1, (int)maxLines);
            Assert.checkMinimumParameter((String)"maxLineLength", (int)1, (int)maxLineLength);
            ProcessBuilderImpl.this.check();
            return this.processWith(br -> {
                String line;
                LineReader lr = new LineReader((Reader)br, maxLineLength);
                ArrayList<String> list = new ArrayList<String>(Math.min(16, maxLines));
                while ((line = lr.readLine()) != null) {
                    list.add(line);
                    if (list.size() != maxLines) continue;
                    IOUtil.drain(br);
                    break;
                }
                return List.copyOf(list);
            });
        }

        @Override
        public PipelineBuilder.Output<O> gatherOnFail(boolean gather) {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.outputGatherOnFail = gather;
            return this;
        }

        @Override
        public PipelineBuilder.Output<O> maxCaptureLineLength(int characters) {
            Assert.checkMinimumParameter((String)"characters", (int)1, (int)characters);
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.outputLineLimit = characters;
            return this;
        }

        @Override
        public PipelineBuilder.Output<O> captureHeadLines(int headLines) {
            Assert.checkMinimumParameter((String)"headLines", (int)0, (int)headLines);
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.outputHeadLines = headLines;
            return this;
        }

        @Override
        public PipelineBuilder.Output<O> captureTailLines(int tailLines) {
            Assert.checkMinimumParameter((String)"tailLines", (int)0, (int)tailLines);
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.outputTailLines = tailLines;
            return this;
        }

        @Override
        public <O2> PipelineBuilder.Output<O2> processBytesWith(ExceptionFunction<InputStream, O2, IOException> processor) {
            ProcessBuilderImpl.this.check();
            Assert.checkNotNullParam((String)"processor", processor);
            ProcessBuilderImpl.this.outputStrategy = 4;
            ProcessBuilderImpl.this.outputHandler = processor;
            return this;
        }

        @Override
        public <O2> PipelineBuilder.Output<O2> processWith(ExceptionFunction<BufferedReader, O2, IOException> processor) {
            ProcessBuilderImpl.this.check();
            Assert.checkNotNullParam((String)"processor", processor);
            this.processBytesWith(is -> {
                try (InputStreamReader isr = new InputStreamReader((InputStream)is, ProcessBuilderImpl.this.outputCharset);){
                    Object object;
                    try (BufferedReader br = new BufferedReader(isr);){
                        object = processor.apply((Object)br);
                    }
                    return object;
                }
            });
            return this;
        }

        @Override
        public PipelineBuilder.Output<Void> transferTo(Path path) {
            this.transferTo(path, 2);
            return this;
        }

        @Override
        public PipelineBuilder.Output<Void> appendTo(Path path) {
            this.transferTo(path, 3);
            return this;
        }

        @Override
        public PipelineBuilder.Output<O> copyAndConsumeBytesWith(ExceptionConsumer<InputStream, IOException> consumer) {
            Assert.checkNotNullParam((String)"consumer", consumer);
            List<ExceptionConsumer<InputStream, IOException>> handlers = ProcessBuilderImpl.this.extraOutputHandlers;
            switch (handlers.size()) {
                case 0: {
                    ProcessBuilderImpl.this.extraOutputHandlers = List.of(consumer);
                    break;
                }
                case 1: {
                    ProcessBuilderImpl.this.extraOutputHandlers = List.of(ProcessBuilderImpl.this.extraOutputHandlers.get(0), consumer);
                    break;
                }
                case 2: {
                    ProcessBuilderImpl.this.extraOutputHandlers = new ArrayList<ExceptionConsumer<InputStream, IOException>>();
                    ProcessBuilderImpl.this.extraOutputHandlers.addAll(handlers);
                    ProcessBuilderImpl.this.extraOutputHandlers.add(consumer);
                    break;
                }
                default: {
                    ProcessBuilderImpl.this.extraOutputHandlers.add(consumer);
                }
            }
            return this;
        }

        @Override
        public PipelineBuilder.Output<O> copyAndConsumeWith(ExceptionConsumer<BufferedReader, IOException> consumer) {
            Assert.checkNotNullParam((String)"consumer", consumer);
            return this.copyAndConsumeBytesWith((ExceptionConsumer<InputStream, IOException>)((ExceptionConsumer)is -> IOUtil.consumeToReader(is, consumer, ProcessBuilderImpl.this.outputCharset)));
        }

        private void transferTo(Path path, int strategy) {
            ProcessBuilderImpl.this.check();
            Assert.checkNotNullParam((String)"path", (Object)path);
            ExceptionFunction handler = switch (strategy) {
                case 2 -> is -> {
                    try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                        is.transferTo(os);
                    }
                    return null;
                };
                case 3 -> is -> {
                    try (OutputStream os = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
                        is.transferTo(os);
                    }
                    return null;
                };
                default -> throw Assert.impossibleSwitchCase((int)strategy);
            };
            if (path.getFileSystem() == FileSystems.getDefault()) {
                ProcessBuilderImpl.this.outputStrategy = strategy;
                ProcessBuilderImpl.this.outputFile = path.toFile();
                ProcessBuilderImpl.this.outputHandler = handler;
            } else {
                this.processBytesWith(handler);
            }
        }

        @Override
        public PipelineBuilder<Void> pipeTo(Path command) {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.locked = true;
            ProcessBuilderImpl.this.outputHandler = null;
            ProcessBuilderImpl.this.outputStrategy = ProcessBuilderImpl.this.extraOutputHandlers.isEmpty() && !ProcessBuilderImpl.this.outputGatherOnFail ? 5 : 6;
            return new ProcessBuilderImpl<Void>(ProcessBuilderImpl.this, command);
        }
    }

    public final class ErrorImpl
    extends ViewImpl
    implements PipelineBuilder.Error<O> {
        @Override
        public PipelineBuilder.Error<O> discard() {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.errorStrategy = 0;
            ProcessBuilderImpl.this.errorHandler = null;
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> inherited() {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.errorStrategy = 1;
            ProcessBuilderImpl.this.errorHandler = is -> is.transferTo(System.err);
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> charset(Charset charset) {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.errorCharset = (Charset)Assert.checkNotNullParam((String)"charset", (Object)charset);
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> logOnSuccess(boolean log) {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.errorLogOnSuccess = log;
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> gatherOnFail(boolean gather) {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.errorGatherOnFail = gather;
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> maxCaptureLineLength(int characters) {
            ProcessBuilderImpl.this.check();
            Assert.checkMinimumParameter((String)"characters", (int)1, (int)characters);
            ProcessBuilderImpl.this.errorLineLimit = characters;
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> captureHeadLines(int headLines) {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.errorHeadLines = headLines;
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> captureTailLines(int tailLines) {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.errorTailLines = tailLines;
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> transferTo(Path path) {
            Assert.checkNotNullParam((String)"path", (Object)path);
            this.consumeBytesWith((ExceptionConsumer<InputStream, IOException>)((ExceptionConsumer)is -> {
                try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                    is.transferTo(os);
                }
            }));
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> appendTo(Path path) {
            Assert.checkNotNullParam((String)"path", (Object)path);
            this.consumeBytesWith((ExceptionConsumer<InputStream, IOException>)((ExceptionConsumer)is -> {
                try (OutputStream os = Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE);){
                    is.transferTo(os);
                }
            }));
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> consumeBytesWith(ExceptionConsumer<InputStream, IOException> consumer) {
            ProcessBuilderImpl.this.check();
            Assert.checkNotNullParam((String)"consumer", consumer);
            ProcessBuilderImpl.this.errorStrategy = 4;
            ProcessBuilderImpl.this.errorHandler = consumer;
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> copyAndConsumeBytesWith(ExceptionConsumer<InputStream, IOException> consumer) {
            ProcessBuilderImpl.this.check();
            Assert.checkNotNullParam((String)"consumer", consumer);
            List<ExceptionConsumer<InputStream, IOException>> handlers = ProcessBuilderImpl.this.extraErrorHandlers;
            switch (handlers.size()) {
                case 0: {
                    ProcessBuilderImpl.this.extraErrorHandlers = List.of(consumer);
                    break;
                }
                case 1: {
                    ProcessBuilderImpl.this.extraErrorHandlers = List.of(ProcessBuilderImpl.this.extraErrorHandlers.get(0), consumer);
                    break;
                }
                case 2: {
                    ProcessBuilderImpl.this.extraErrorHandlers = new ArrayList<ExceptionConsumer<InputStream, IOException>>();
                    ProcessBuilderImpl.this.extraErrorHandlers.addAll(handlers);
                    ProcessBuilderImpl.this.extraErrorHandlers.add(consumer);
                    break;
                }
                default: {
                    ProcessBuilderImpl.this.extraErrorHandlers.add(consumer);
                }
            }
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> consumeWith(ExceptionConsumer<BufferedReader, IOException> consumer) {
            Assert.checkNotNullParam((String)"consumer", consumer);
            this.consumeBytesWith((ExceptionConsumer<InputStream, IOException>)((ExceptionConsumer)is -> IOUtil.consumeToReader(is, consumer, ProcessBuilderImpl.this.errorCharset)));
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> copyAndConsumeWith(ExceptionConsumer<BufferedReader, IOException> consumer) {
            Assert.checkNotNullParam((String)"consumer", consumer);
            this.copyAndConsumeBytesWith((ExceptionConsumer<InputStream, IOException>)((ExceptionConsumer)is -> IOUtil.consumeToReader(is, consumer, ProcessBuilderImpl.this.errorCharset)));
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> redirect() {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.errorStrategy = 5;
            ProcessBuilderImpl.this.errorHandler = null;
            return this;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public abstract class ViewImpl
    implements ProcessBuilder<O> {
        @Override
        public ProcessBuilder<O> arguments(List<String> command) {
            return ProcessBuilderImpl.this.arguments((List)command);
        }

        @Override
        public ProcessBuilder<O> specialQuoting(boolean specialQuoting) {
            return ProcessBuilderImpl.this.specialQuoting(specialQuoting);
        }

        @Override
        public ProcessBuilder<O> directory(Path directory) {
            return ProcessBuilderImpl.this.directory(directory);
        }

        @Override
        public ProcessBuilder<O> modifyEnvironment(Consumer<Map<String, String>> action) {
            return ProcessBuilderImpl.this.modifyEnvironment((Consumer)action);
        }

        @Override
        public ProcessBuilder.Input<O> input() {
            return ProcessBuilderImpl.this.input();
        }

        @Override
        public PipelineBuilder.Output<O> output() {
            return ProcessBuilderImpl.this.output();
        }

        @Override
        public PipelineBuilder.Error<O> error() {
            return ProcessBuilderImpl.this.error();
        }

        @Override
        public O run() throws AbnormalExitException {
            return ProcessBuilderImpl.this.run();
        }

        @Override
        public CompletableFuture<O> runAsync() {
            return ProcessBuilderImpl.this.runAsync();
        }

        @Override
        public ProcessBuilder<O> exitCodeChecker(IntPredicate checker) {
            return ProcessBuilderImpl.this.exitCodeChecker(checker);
        }

        @Override
        public ProcessBuilder<O> softExitTimeout(Duration duration) {
            return ProcessBuilderImpl.this.softExitTimeout(duration);
        }

        @Override
        public ProcessBuilder<O> hardExitTimeout(Duration duration) {
            return ProcessBuilderImpl.this.hardExitTimeout(duration);
        }

        @Override
        public ProcessBuilder<O> whileRunning(Consumer<WaitableProcessHandle> action) {
            return ProcessBuilderImpl.this.whileRunning((Consumer)action);
        }
    }
}

