/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;

public enum CompletableFutures {
    INSTANCE;

    private static final CompletableFuture<?> NULL;
    private static final CompletableFuture<Boolean> TRUE_CF;
    private static final CompletableFuture<Boolean> FALSE_CF;
    private static final Consumer<?> VOID_CONSUMER;
    private static final Function<?, ?> NULL_FUNCTION;

    public static <T> T join(CompletionStage<T> cs) {
        return CompletableFutures.join(cs.toCompletableFuture());
    }

    public static <T> T join(CompletableFuture<T> cf) {
        try {
            return cf.join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public static <T> CompletableFuture<T> completedNull() {
        return NULL;
    }

    public static <T> Consumer<T> voidConsumer() {
        return VOID_CONSUMER;
    }

    public static CompletionException wrapAsCompletionException(Throwable throwable) {
        return throwable instanceof CompletionException ? (CompletionException)throwable : new CompletionException(throwable);
    }

    public static <T> Function<T, Void> toVoidFunction() {
        return NULL_FUNCTION;
    }

    public static CompletableFuture<Boolean> completedTrue() {
        return TRUE_CF;
    }

    public static CompletableFuture<Boolean> completedFalse() {
        return FALSE_CF;
    }

    static {
        NULL = CompletableFuture.completedFuture(null);
        TRUE_CF = CompletableFuture.completedFuture(Boolean.TRUE);
        FALSE_CF = CompletableFuture.completedFuture(Boolean.FALSE);
        VOID_CONSUMER = o -> {};
        NULL_FUNCTION = o -> null;
    }
}

