/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import java.util.Objects;
import java.util.function.Supplier;

public class StateHolder<S> {
    private final Supplier<S> supplier;
    private boolean once = false;
    private volatile S state;

    public StateHolder(Supplier<S> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S get() {
        StateHolder stateHolder = this;
        synchronized (stateHolder) {
            if (!this.once) {
                this.once = true;
                this.state = this.supplier.get();
                Objects.requireNonNull(this.state, "The supplier returned `null`");
            }
        }
        if (this.state == null) {
            throw new IllegalStateException("Invalid shared state");
        }
        return this.state;
    }
}

