/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.sequence;

import org.hibernate.dialect.sequence.SequenceSupport;

public final class InterbaseSequenceSupport
implements SequenceSupport {
    public static final SequenceSupport INSTANCE = new InterbaseSequenceSupport();

    public String getSequenceNextValString(String sequenceName, int increment) {
        return "select " + this.getSelectSequenceNextValString(sequenceName, increment) + this.getFromDual();
    }

    public String getFromDual() {
        return " from rdb$database";
    }

    public String getSelectSequenceNextValString(String sequenceName) {
        return this.getSelectSequenceNextValString(sequenceName, 1);
    }

    public String getSelectSequenceNextValString(String sequenceName, int increment) {
        return "gen_id(" + sequenceName + "," + increment + ")";
    }

    public String getSelectSequencePreviousValString(String sequenceName) {
        return this.getSelectSequenceNextValString(sequenceName, 0);
    }

    public String[] getCreateSequenceStrings(String sequenceName, int initialValue, int incrementSize) {
        String[] stringArray;
        if (initialValue == 1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.getCreateSequenceString(sequenceName);
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = this.getCreateSequenceString(sequenceName);
            stringArray = stringArray3;
            stringArray3[1] = "set generator " + sequenceName + " to " + (initialValue - incrementSize);
        }
        return stringArray;
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create generator " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop generator " + sequenceName;
    }
}

