/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.profile;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.common.Profile;
import org.keycloak.common.profile.ProfileConfigResolver;
import org.keycloak.common.profile.ProfileException;

public class CommaSeparatedListProfileConfigResolver
implements ProfileConfigResolver {
    private Set<String> enabledFeatures;
    private Set<String> disabledFeatures;

    public CommaSeparatedListProfileConfigResolver(String enabledFeatures, String disabledFeatures) {
        if (enabledFeatures != null) {
            this.enabledFeatures = new HashSet<String>(Arrays.asList(enabledFeatures.split(",")));
        }
        if (disabledFeatures != null) {
            this.disabledFeatures = new HashSet<String>(Arrays.asList(disabledFeatures.split(",")));
        }
    }

    @Override
    public Profile.ProfileName getProfileName() {
        if (this.enabledFeatures != null && this.enabledFeatures.contains(Profile.ProfileName.PREVIEW.name().toLowerCase())) {
            return Profile.ProfileName.PREVIEW;
        }
        return null;
    }

    @Override
    public ProfileConfigResolver.FeatureConfig getFeatureConfig(String feature) {
        if (this.enabledFeatures != null && this.enabledFeatures.contains(feature)) {
            if (this.disabledFeatures != null && this.disabledFeatures.contains(feature)) {
                throw new ProfileException(feature + " is in both the enabled and disabled feature lists.");
            }
            return ProfileConfigResolver.FeatureConfig.ENABLED;
        }
        if (this.disabledFeatures != null && this.disabledFeatures.contains(feature)) {
            return ProfileConfigResolver.FeatureConfig.DISABLED;
        }
        return ProfileConfigResolver.FeatureConfig.UNCONFIGURED;
    }
}

