/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;

public class SystemEnvProperties
extends Properties {
    public static final SystemEnvProperties UNFILTERED = new SystemEnvProperties(Collections.emptySet()){

        @Override
        protected boolean isAllowed(String key) {
            return true;
        }
    };
    private final Set<String> allowedSystemVariables;

    public SystemEnvProperties(Set<String> allowedSystemVariables) {
        this.allowedSystemVariables = Optional.ofNullable(allowedSystemVariables).orElse(Collections.emptySet());
    }

    @Override
    public String getProperty(String key) {
        if (key.startsWith("env.")) {
            String envKey = key.substring(4);
            return this.isAllowed(envKey) ? System.getenv().get(envKey) : null;
        }
        return this.isAllowed(key) ? System.getProperty(key) : null;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value != null ? value : defaultValue;
    }

    protected boolean isAllowed(String key) {
        return this.allowedSystemVariables.contains(key);
    }
}

