/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.netty.deployment;

import io.netty.channel.EventLoopGroup;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.GeneratedRuntimeSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.UnsafeAccessedFieldBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.netty.BossEventLoopGroup;
import io.quarkus.netty.MainEventLoopGroup;
import io.quarkus.netty.deployment.EventLoopGroupBuildItem;
import io.quarkus.netty.deployment.EventLoopSupplierBuildItem;
import io.quarkus.netty.deployment.JBossNettyLoggerFactory;
import io.quarkus.netty.deployment.MinNettyAllocatorMaxOrderBuildItem;
import io.quarkus.netty.deployment.NettyBuildTimeConfig;
import io.quarkus.netty.runtime.EmptyByteBufStub;
import io.quarkus.netty.runtime.MachineIdGenerator;
import io.quarkus.netty.runtime.NettyRecorder;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.jboss.logging.Logger;

class NettyProcessor {
    private static final Logger log = Logger.getLogger(NettyProcessor.class);
    private static final int DEFAULT_NETTY_ALLOCATOR_MAX_ORDER = 3;

    NettyProcessor() {
    }

    @BuildStep
    public NativeImageSystemPropertyBuildItem limitMem() {
        return new NativeImageSystemPropertyBuildItem("sun.nio.ch.maxUpdateArraySize", "100");
    }

    @BuildStep
    public SystemPropertyBuildItem limitArenaSize(NettyBuildTimeConfig config, List<MinNettyAllocatorMaxOrderBuildItem> minMaxOrderBuildItems) {
        String maxOrder = this.calculateMaxOrder(config.allocatorMaxOrder(), minMaxOrderBuildItems, true);
        return new SystemPropertyBuildItem("io.netty.allocator.maxOrder", maxOrder);
    }

    @BuildStep
    public GeneratedRuntimeSystemPropertyBuildItem setNettyMachineId() {
        return new GeneratedRuntimeSystemPropertyBuildItem("io.netty.machineId", MachineIdGenerator.class);
    }

    @BuildStep
    public SystemPropertyBuildItem disableFinalizers() {
        return new SystemPropertyBuildItem("io.netty.allocator.disableCacheFinalizersForFastThreadLocalThreads", "true");
    }

    @BuildStep
    NativeImageConfigBuildItem build(NettyBuildTimeConfig config, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, List<MinNettyAllocatorMaxOrderBuildItem> minMaxOrderBuildItems) {
        reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem("Reflectively accessed through PlatformDependent0's static initializer", "jdk.internal.misc.Unsafe", "getUnsafe", new String[0]));
        reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem("Reflectively accessed through PlatformDependent0's static initializer", "java.nio.DirectByteBuffer", "<init>", new String[]{Long.TYPE.getName(), Long.TYPE.getName()}));
        reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem("Reflectively accessed through PlatformDependent0's static initializer", "java.nio.DirectByteBuffer", "<init>", new String[]{Long.TYPE.getName(), Integer.TYPE.getName()}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.netty.channel.socket.nio.NioSocketChannel"}).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.netty.channel.socket.nio.NioServerSocketChannel"}).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.netty.channel.socket.nio.NioDatagramChannel"}).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"java.util.LinkedHashMap"}).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"sun.nio.ch.SelectorImpl"}).methods().fields().build());
        String maxOrder = this.calculateMaxOrder(config.allocatorMaxOrder(), minMaxOrderBuildItems, false);
        NativeImageConfigBuildItem.Builder builder = NativeImageConfigBuildItem.builder().addNativeImageSystemProperty("io.netty.allocator.maxOrder", maxOrder).addRuntimeInitializedClass("io.netty.handler.ssl.ConscryptAlpnSslEngine").addRuntimeInitializedClass("io.netty.handler.ssl.ReferenceCountedOpenSslEngine").addRuntimeInitializedClass("io.netty.handler.ssl.ReferenceCountedOpenSslContext").addRuntimeInitializedClass("io.netty.handler.ssl.JdkSslServerContext").addRuntimeInitializedClass("io.netty.handler.ssl.util.ThreadLocalInsecureRandom").addRuntimeInitializedClass("io.netty.channel.DefaultChannelId").addNativeImageSystemProperty("io.netty.leakDetection.level", "DISABLED");
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.handler.codec.http.HttpObjectEncoder")) {
            builder.addRuntimeInitializedClass("io.netty.handler.codec.http.HttpObjectEncoder").addRuntimeInitializedClass("io.netty.handler.codec.http.websocketx.extensions.compression.DeflateDecoder").addRuntimeInitializedClass("io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder");
            if (!QuarkusClassLoader.isClassPresentAtRuntime((String)"com.github.luben.zstd.Zstd")) {
                builder.addRuntimeInitializedClass("io.netty.handler.codec.compression.ZstdOptions").addRuntimeInitializedClass("io.netty.handler.codec.compression.ZstdConstants");
            }
            if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.handler.codec.compression.BrotliOptions")) {
                builder.addRuntimeInitializedClass("io.netty.handler.codec.compression.BrotliOptions");
            }
        } else {
            log.debug((Object)"Not registering Netty HTTP classes as they were not found");
        }
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.handler.codec.http2.Http2CodecUtil")) {
            builder.addRuntimeInitializedClass("io.netty.handler.codec.http2.Http2CodecUtil").addRuntimeInitializedClass("io.netty.handler.codec.http2.DefaultHttp2FrameWriter").addRuntimeInitializedClass("io.netty.handler.codec.http2.Http2ConnectionHandler").addRuntimeInitializedClass("io.netty.handler.codec.http2.Http2ClientUpgradeCodec");
        } else {
            log.debug((Object)"Not registering Netty HTTP2 classes as they were not found");
        }
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.channel.unix.UnixChannel")) {
            builder.addRuntimeInitializedClass("io.netty.channel.unix.Errors").addRuntimeInitializedClass("io.netty.channel.unix.FileDescriptor").addRuntimeInitializedClass("io.netty.channel.unix.IovArray").addRuntimeInitializedClass("io.netty.channel.unix.Limits");
        } else {
            log.debug((Object)"Not registering Netty native unix classes as they were not found");
        }
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.channel.epoll.EpollMode")) {
            builder.addRuntimeInitializedClass("io.netty.channel.epoll.Epoll").addRuntimeInitializedClass("io.netty.channel.epoll.EpollEventArray").addRuntimeInitializedClass("io.netty.channel.epoll.EpollEventLoop").addRuntimeInitializedClass("io.netty.channel.epoll.Native");
        } else {
            log.debug((Object)"Not registering Netty native epoll classes as they were not found");
        }
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.channel.kqueue.AcceptFilter")) {
            builder.addRuntimeInitializedClass("io.netty.channel.kqueue.KQueue").addRuntimeInitializedClass("io.netty.channel.kqueue.KQueueEventArray").addRuntimeInitializedClass("io.netty.channel.kqueue.Native").addRuntimeInitializedClass("io.netty.channel.kqueue.KQueueEventLoop");
        } else {
            log.debug((Object)"Not registering Netty native kqueue classes as they were not found");
        }
        builder.addRuntimeReinitializedClass("io.netty.util.internal.PlatformDependent").addRuntimeReinitializedClass("io.netty.util.internal.PlatformDependent0").addRuntimeReinitializedClass("io.netty.util.AbstractReferenceCounted").addRuntimeReinitializedClass("io.netty.buffer.AbstractReferenceCountedByteBuf");
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.buffer.UnpooledByteBufAllocator")) {
            builder.addRuntimeReinitializedClass("io.netty.buffer.UnpooledByteBufAllocator").addRuntimeReinitializedClass("io.netty.buffer.Unpooled").addRuntimeReinitializedClass("io.netty.handler.codec.http.HttpObjectAggregator").addRuntimeReinitializedClass("io.netty.handler.codec.ReplayingDecoderByteBuf").addRuntimeInitializedClass("io.netty.buffer.ByteBufUtil$HexUtil").addRuntimeInitializedClass("io.netty.buffer.PooledByteBufAllocator").addRuntimeInitializedClass("io.netty.buffer.ByteBufAllocator").addRuntimeInitializedClass("io.netty.buffer.ByteBufUtil");
            if (QuarkusClassLoader.isClassPresentAtRuntime((String)"org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartFormUpload")) {
                builder.addRuntimeReinitializedClass("org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartFormUpload");
            }
        }
        return builder.build();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void eagerlyInitClass(NettyRecorder recorder) {
        recorder.eagerlyInitChannelId();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerEventLoopBeans(BuildProducer<SyntheticBeanBuildItem> syntheticBeans, Optional<EventLoopSupplierBuildItem> loopSupplierBuildItem, NettyRecorder recorder, BuildProducer<EventLoopGroupBuildItem> eventLoopGroups) {
        Supplier<EventLoopGroup> main;
        Supplier<EventLoopGroup> boss;
        if (loopSupplierBuildItem.isPresent()) {
            boss = loopSupplierBuildItem.get().getBossSupplier();
            main = loopSupplierBuildItem.get().getMainSupplier();
        } else {
            boss = recorder.createEventLoop(1);
            main = recorder.createEventLoop(0);
        }
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(EventLoopGroup.class).supplier(boss).scope(Singleton.class)).addQualifier(BossEventLoopGroup.class)).unremovable()).setRuntimeInit().done());
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(EventLoopGroup.class).supplier(main).scope(Singleton.class)).addQualifier(MainEventLoopGroup.class)).unremovable()).setRuntimeInit().done());
        eventLoopGroups.produce((BuildItem)new EventLoopGroupBuildItem(boss, main));
    }

    @BuildStep
    AdditionalBeanBuildItem registerQualifiers() {
        return AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{BossEventLoopGroup.class, MainEventLoopGroup.class}).build();
    }

    @BuildStep
    public RuntimeInitializedClassBuildItem reinitScheduledFutureTask() {
        return new RuntimeInitializedClassBuildItem("io.quarkus.netty.runtime.graal.Holder_io_netty_util_concurrent_ScheduledFutureTask");
    }

    @BuildStep
    public List<UnsafeAccessedFieldBuildItem> unsafeAccessedFields() {
        return Arrays.asList(new UnsafeAccessedFieldBuildItem("sun.nio.ch.SelectorImpl", "selectedKeys"), new UnsafeAccessedFieldBuildItem("sun.nio.ch.SelectorImpl", "publicSelectedKeys"), new UnsafeAccessedFieldBuildItem("io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess", "REF_ELEMENT_SHIFT"));
    }

    @BuildStep
    RuntimeInitializedClassBuildItem runtimeInitBcryptUtil() {
        return new RuntimeInitializedClassBuildItem(EmptyByteBufStub.class.getName());
    }

    @BuildStep
    LogCleanupFilterBuildItem cleanupUnsafeLog() {
        return new LogCleanupFilterBuildItem(PlatformDependent.class.getName() + "0", (Level)org.jboss.logmanager.Level.TRACE, new String[]{"direct buffer constructor", "jdk.internal.misc.Unsafe", "sun.misc.Unsafe"});
    }

    @BuildStep
    LogCleanupFilterBuildItem cleanupMacDNSInLog() {
        return new LogCleanupFilterBuildItem(DnsServerAddressStreamProviders.class.getName(), (Level)org.jboss.logmanager.Level.WARN, new String[]{"Can not find io.netty.resolver.dns.macos.MacOSDnsServerAddressStreamProvider in the classpath"});
    }

    @BuildStep
    NativeImageResourceBuildItem nettyVersions() {
        return new NativeImageResourceBuildItem(new String[]{"META-INF/io.netty.versions.properties"});
    }

    private String calculateMaxOrder(OptionalInt userConfig, List<MinNettyAllocatorMaxOrderBuildItem> minMaxOrderBuildItems, boolean shouldWarn) {
        int result = 3;
        for (MinNettyAllocatorMaxOrderBuildItem minMaxOrderBuildItem : minMaxOrderBuildItems) {
            if (minMaxOrderBuildItem.getMaxOrder() <= result) continue;
            result = minMaxOrderBuildItem.getMaxOrder();
        }
        if (userConfig.isPresent()) {
            int v = userConfig.getAsInt();
            if (result > v && shouldWarn) {
                log.warnf("The configuration set `quarkus.netty.allocator-max-order` to %d. This value is lower than the value requested by the extensions (%d). %d will be used anyway.", (Object)v, (Object)result, (Object)v);
            }
            return Integer.toString(v);
        }
        return Integer.toString(result);
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new JBossNettyLoggerFactory());
    }
}

