/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev.console;

import io.quarkus.dev.console.DevConsoleRequest;
import io.quarkus.dev.console.DevConsoleResponse;
import io.quarkus.dev.spi.HotReplacementContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class DevConsoleManager {
    public static volatile String DEV_MANAGER_GLOBALS_ASSISTANT = "_assistant";
    private static volatile Consumer<DevConsoleRequest> handler;
    private static volatile Map<String, Map<String, Object>> templateInfo;
    private static volatile HotReplacementContext hotReplacementContext;
    private static volatile Object quarkusBootstrap;
    private static volatile boolean doingHttpInitiatedReload;
    private static final Map<String, Object> globals;
    private static final Map<String, Function<Map<String, String>, ?>> actions;
    private static final Map<String, BiFunction<Object, Map<String, String>, ?>> assistantActions;

    public static void registerHandler(Consumer<DevConsoleRequest> requestHandler) {
        handler = requestHandler;
    }

    public static void sentRequest(DevConsoleRequest request) {
        Consumer<DevConsoleRequest> h = handler;
        if (h == null) {
            request.getResponse().complete(new DevConsoleResponse(503, Collections.emptyMap(), new byte[0]));
        } else {
            h.accept(request);
        }
    }

    public static Map<String, Map<String, Object>> getTemplateInfo() {
        return templateInfo;
    }

    public static void setTemplateInfo(Map<String, Map<String, Object>> templateInfo) {
        DevConsoleManager.templateInfo = templateInfo;
    }

    public static HotReplacementContext getHotReplacementContext() {
        return hotReplacementContext;
    }

    public static void setHotReplacementContext(HotReplacementContext hotReplacementContext) {
        DevConsoleManager.hotReplacementContext = hotReplacementContext;
    }

    public static void setQuarkusBootstrap(Object qb) {
        quarkusBootstrap = qb;
    }

    public static Object getQuarkusBootstrap() {
        return quarkusBootstrap;
    }

    public static void setGlobal(String name, Object value) {
        globals.put(name, value);
    }

    public static <T> T getGlobal(String name) {
        return (T)globals.get(name);
    }

    public static boolean isDoingHttpInitiatedReload() {
        return doingHttpInitiatedReload;
    }

    public static void setDoingHttpInitiatedReload(boolean doingHttpInitiatedReload) {
        DevConsoleManager.doingHttpInitiatedReload = doingHttpInitiatedReload;
    }

    public static void close() {
        handler = null;
        templateInfo = null;
        hotReplacementContext = null;
        quarkusBootstrap = null;
        actions.clear();
        assistantActions.clear();
        globals.clear();
    }

    public static <T> void register(String name, Function<Map<String, String>, T> action) {
        actions.put(name, action);
    }

    public static <T> void register(String name, BiFunction<Object, Map<String, String>, T> action) {
        assistantActions.put(name, action);
    }

    public static <T> T invoke(String name) {
        return DevConsoleManager.invoke(name, Map.of());
    }

    public static <T> T invoke(String name, Map<String, String> params) {
        Function<Map<String, String>, ?> function = actions.get(name);
        if (function == null) {
            BiFunction<Object, Map<String, String>, ?> bifunction = assistantActions.get(name);
            if (bifunction != null) {
                T assistant = DevConsoleManager.getGlobal(DEV_MANAGER_GLOBALS_ASSISTANT);
                if (assistant != null) {
                    return (T)bifunction.apply(assistant, params);
                }
                throw new RuntimeException("Assistant not available");
            }
            throw new NoSuchElementException(name);
        }
        return (T)function.apply(params);
    }

    static {
        globals = new ConcurrentHashMap<String, Object>();
        actions = new HashMap();
        assistantActions = new HashMap();
    }
}

