/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.sdjwt.SdJwtUtils;
import org.keycloak.util.JWKSUtils;
import org.keycloak.util.KeyWrapperUtil;

public class JwkParsingUtils {
    public static SignatureVerifierContext convertJwkNodeToVerifierContext(JsonNode jwkNode) {
        JWK jwk;
        try {
            jwk = (JWK)SdJwtUtils.mapper.convertValue((Object)jwkNode, JWK.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed JWK");
        }
        return JwkParsingUtils.convertJwkToVerifierContext(jwk);
    }

    public static SignatureVerifierContext convertJwkToVerifierContext(JWK jwk) {
        KeyWrapper keyWrapper;
        try {
            keyWrapper = JWKSUtils.getKeyWrapper(jwk);
            Objects.requireNonNull(keyWrapper);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported or invalid JWK");
        }
        return KeyWrapperUtil.createSignatureVerifierContext(keyWrapper);
    }
}

