/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ic;

import java.util.Map;
import java.util.WeakHashMap;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.wasm.ic.FileSignatureRemoverKt;
import org.jetbrains.kotlin.ir.declarations.IdSignatureRetriever;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.StageController;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\t*\u0002H\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\tH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ic/IrFactoryImplForWasmIC;", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "Lorg/jetbrains/kotlin/ir/declarations/IdSignatureRetriever;", "stageController", "Lorg/jetbrains/kotlin/ir/declarations/StageController;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/StageController;)V", "declarationToSignature", "Ljava/util/WeakHashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "declarationCreated", "T", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "eraseSignature", "signature", "declaration", "declarationSignature", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nIrFactoryImplForWasmIC.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrFactoryImplForWasmIC.kt\norg/jetbrains/kotlin/backend/wasm/ic/IrFactoryImplForWasmIC\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public final class IrFactoryImplForWasmIC
extends IrFactory
implements IdSignatureRetriever {
    @NotNull
    private final WeakHashMap<IrDeclaration, IdSignature> declarationToSignature;

    public IrFactoryImplForWasmIC(@NotNull StageController stageController) {
        Intrinsics.checkNotNullParameter(stageController, "stageController");
        super(stageController);
        this.declarationToSignature = new WeakHashMap();
    }

    @Override
    @NotNull
    public <T extends IrDeclaration> T declarationCreated(@NotNull T $this$declarationCreated) {
        block4: {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter($this$declarationCreated, "<this>");
                    object = this.getStageController().getCurrentDeclaration();
                    if (object == null) break block2;
                    IrDeclaration it = object;
                    boolean bl = false;
                    IdSignature idSignature = this.declarationSignature(it);
                    object = idSignature;
                    if (idSignature != null) break block3;
                }
                return $this$declarationCreated;
            }
            Object parentSig = object;
            IdSignature idSignature = this.getStageController().createSignature((IdSignature)parentSig);
            if (idSignature == null) break block4;
            IdSignature it = idSignature;
            boolean bl = false;
            ((Map)this.declarationToSignature).put($this$declarationCreated, it);
        }
        return $this$declarationCreated;
    }

    private final IdSignature eraseSignature(IdSignature signature, IrDeclaration declaration) {
        IrFile irFile = IrUtilsKt.getFileOrNull(declaration);
        if (irFile == null) {
            return signature;
        }
        IrFile file = irFile;
        String string = file.getModule().getName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        return FileSignatureRemoverKt.fileSignatureErasure(signature, string);
    }

    @Override
    @NotNull
    public IdSignature declarationSignature(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IdSignature idSignature = this.declarationToSignature.get(declaration);
        if (idSignature == null) {
            IdSignature idSignature2;
            IdSignature idSignature3 = declaration.getSymbol().getSignature();
            if (idSignature3 != null) {
                IdSignature it = idSignature3;
                boolean bl = false;
                idSignature2 = this.eraseSignature(it, declaration);
            } else {
                idSignature2 = idSignature = null;
            }
            if (idSignature2 == null) {
                IdSignature idSignature4;
                IdSignature idSignature5 = declaration.getSymbol().getPrivateSignature();
                if (idSignature5 != null) {
                    IdSignature it = idSignature5;
                    boolean bl = false;
                    idSignature4 = this.eraseSignature(it, declaration);
                } else {
                    idSignature4 = idSignature = null;
                }
                if (idSignature4 == null) {
                    CompilationExceptionKt.compilationException("Can't retrieve a signature", declaration);
                    throw new KotlinNothingValueException();
                }
            }
        }
        return idSignature;
    }
}

