/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"CHAR_RANGE_FQN", "", "INT_RANGE_FQN", "LONG_RANGE_FQN", "CHAR_PROGRESSION_FQN", "INT_PROGRESSION_FQN", "LONG_PROGRESSION_FQN", "CLOSED_FLOAT_RANGE_FQN", "CLOSED_DOUBLE_RANGE_FQN", "CLOSED_RANGE_FQN", "CLOSED_FLOATING_POINT_RANGE_FQN", "COMPARABLE_RANGE_FQN", "UINT_RANGE_FQN", "ULONG_RANGE_FQN", "UINT_PROGRESSION_FQN", "ULONG_PROGRESSION_FQN", "ALL_PROGRESSION_AND_RANGES", "", "getRangeOrProgressionElementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "rangeType", "progressionsAndRanges", "findTypeInModuleByTopLevelClassFqName", "Lorg/jetbrains/kotlin/types/SimpleType;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "frontend"})
public final class RangeUtilKt {
    @NotNull
    public static final String CHAR_RANGE_FQN = "kotlin.ranges.CharRange";
    @NotNull
    public static final String INT_RANGE_FQN = "kotlin.ranges.IntRange";
    @NotNull
    public static final String LONG_RANGE_FQN = "kotlin.ranges.LongRange";
    @NotNull
    public static final String CHAR_PROGRESSION_FQN = "kotlin.ranges.CharProgression";
    @NotNull
    public static final String INT_PROGRESSION_FQN = "kotlin.ranges.IntProgression";
    @NotNull
    public static final String LONG_PROGRESSION_FQN = "kotlin.ranges.LongProgression";
    @NotNull
    public static final String UINT_RANGE_FQN = "kotlin.ranges.UIntRange";
    @NotNull
    public static final String ULONG_RANGE_FQN = "kotlin.ranges.ULongRange";
    @NotNull
    public static final String UINT_PROGRESSION_FQN = "kotlin.ranges.UIntProgression";
    @NotNull
    public static final String ULONG_PROGRESSION_FQN = "kotlin.ranges.ULongProgression";
    @NotNull
    private static final List<String> ALL_PROGRESSION_AND_RANGES;

    @Nullable
    public static final KotlinType getRangeOrProgressionElementType(@NotNull KotlinType rangeType, @NotNull List<String> progressionsAndRanges) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(rangeType, "rangeType");
        Intrinsics.checkNotNullParameter(progressionsAndRanges, "progressionsAndRanges");
        ClassifierDescriptor classifierDescriptor = rangeType.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor rangeClassDescriptor = classDescriptor;
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(rangeClassDescriptor);
        String fqName = DescriptorUtilsKt.getFqNameSafe(rangeClassDescriptor).asString();
        if (!progressionsAndRanges.contains(fqName)) {
            return null;
        }
        switch (fqName) {
            case "kotlin.ranges.CharRange": 
            case "kotlin.ranges.CharProgression": {
                kotlinType = builtIns.getCharType();
                break;
            }
            case "kotlin.ranges.IntProgression": 
            case "kotlin.ranges.IntRange": {
                kotlinType = builtIns.getIntType();
                break;
            }
            case "kotlin.ranges.LongProgression": 
            case "kotlin.ranges.LongRange": {
                kotlinType = builtIns.getLongType();
                break;
            }
            case "kotlin.ranges.ClosedFloatRange": {
                kotlinType = builtIns.getFloatType();
                break;
            }
            case "kotlin.ranges.ClosedDoubleRange": {
                kotlinType = builtIns.getDoubleType();
                break;
            }
            case "kotlin.ranges.ClosedRange": {
                TypeProjection typeProjection = CollectionsKt.singleOrNull(rangeType.getArguments());
                if (typeProjection != null) {
                    kotlinType = typeProjection.getType();
                    break;
                }
                kotlinType = null;
                break;
            }
            case "kotlin.ranges.ClosedFloatingPointRange": {
                TypeProjection typeProjection = CollectionsKt.singleOrNull(rangeType.getArguments());
                if (typeProjection != null) {
                    kotlinType = typeProjection.getType();
                    break;
                }
                kotlinType = null;
                break;
            }
            case "kotlin.ranges.ComparableRange": {
                TypeProjection typeProjection = CollectionsKt.singleOrNull(rangeType.getArguments());
                if (typeProjection != null) {
                    kotlinType = typeProjection.getType();
                    break;
                }
                kotlinType = null;
                break;
            }
            case "kotlin.ranges.UIntProgression": 
            case "kotlin.ranges.UIntRange": {
                kotlinType = RangeUtilKt.findTypeInModuleByTopLevelClassFqName(rangeClassDescriptor, StandardNames.FqNames.uIntFqName);
                break;
            }
            case "kotlin.ranges.ULongRange": 
            case "kotlin.ranges.ULongProgression": {
                kotlinType = RangeUtilKt.findTypeInModuleByTopLevelClassFqName(rangeClassDescriptor, StandardNames.FqNames.uLongFqName);
                break;
            }
            default: {
                kotlinType = null;
            }
        }
        return kotlinType;
    }

    public static /* synthetic */ KotlinType getRangeOrProgressionElementType$default(KotlinType kotlinType, List list, int n2, Object object) {
        if ((n2 & 2) != 0) {
            list = ALL_PROGRESSION_AND_RANGES;
        }
        return RangeUtilKt.getRangeOrProgressionElementType(kotlinType, list);
    }

    private static final SimpleType findTypeInModuleByTopLevelClassFqName(DeclarationDescriptor $this$findTypeInModuleByTopLevelClassFqName, FqName fqName) {
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(DescriptorUtilsKt.getModule($this$findTypeInModuleByTopLevelClassFqName), ClassId.Companion.topLevel(fqName));
        return classDescriptor != null ? classDescriptor.getDefaultType() : null;
    }

    static {
        String[] stringArray = new String[]{CHAR_RANGE_FQN, CHAR_PROGRESSION_FQN, INT_RANGE_FQN, INT_PROGRESSION_FQN, LONG_RANGE_FQN, LONG_PROGRESSION_FQN, "kotlin.ranges.ClosedFloatRange", "kotlin.ranges.ClosedDoubleRange", "kotlin.ranges.ClosedRange", "kotlin.ranges.ClosedFloatingPointRange", "kotlin.ranges.ComparableRange", UINT_RANGE_FQN, UINT_PROGRESSION_FQN, ULONG_RANGE_FQN, ULONG_PROGRESSION_FQN};
        ALL_PROGRESSION_AND_RANGES = CollectionsKt.listOf(stringArray);
    }
}

