/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class UnsignedMeshNode extends ImplicitNode {

	public UnsignedMeshNode(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the input for the model resource id of the mesh
	 *
	 * @return the input port for the model resource id of the mesh
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputMesh() throws Lib3MFException {
		Pointer bufferMesh = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_unsignedmeshnode_getinputmesh.invokeInt(new java.lang.Object[]{mHandle, bufferMesh}));
		Pointer valueMesh = bufferMesh.getPointer(0);
		ImplicitPort mesh = null;
		if (valueMesh == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Mesh was a null pointer");
		}
		mesh = mWrapper.PolymorphicFactory(valueMesh, ImplicitPort.class);
		return mesh;
	}

	/**
	 * Retrieves the input for the position
	 *
	 * @return the input port for the position
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputPos() throws Lib3MFException {
		Pointer bufferPos = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_unsignedmeshnode_getinputpos.invokeInt(new java.lang.Object[]{mHandle, bufferPos}));
		Pointer valuePos = bufferPos.getPointer(0);
		ImplicitPort pos = null;
		if (valuePos == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Pos was a null pointer");
		}
		pos = mWrapper.PolymorphicFactory(valuePos, ImplicitPort.class);
		return pos;
	}

	/**
	 * Retrieves the output
	 *
	 * @return the output port for the unsigned distance to the mesh
	 * @throws Lib3MFException
	 */
	public ImplicitPort getOutputDistance() throws Lib3MFException {
		Pointer bufferDistance = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_unsignedmeshnode_getoutputdistance.invokeInt(new java.lang.Object[]{mHandle, bufferDistance}));
		Pointer valueDistance = bufferDistance.getPointer(0);
		ImplicitPort distance = null;
		if (valueDistance == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Distance was a null pointer");
		}
		distance = mWrapper.PolymorphicFactory(valueDistance, ImplicitPort.class);
		return distance;
	}


}

