/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.filechooser;

import com.install4j.runtime.filechooser.AbstractFileSystemChooser;
import com.install4j.runtime.filechooser.FileChooserQuestion;
import com.install4j.runtime.installer.platform.macos.MacosUiHelper;
import java.io.File;
import java.util.Collection;

public class MacosFileChooserHelper {
    static String getCurrentDirectoryWithSelection(AbstractFileSystemChooser fileSystemChooser) {
        File selectedFile = fileSystemChooser.getDefaultSelectedFile();
        if (selectedFile != null) {
            return selectedFile.getParent();
        }
        File currentDirectory = fileSystemChooser.getCurrentDirectory();
        if (currentDirectory != null) {
            return currentDirectory.getAbsolutePath();
        }
        return null;
    }

    static String getDefaultSelectedFileName(AbstractFileSystemChooser fileSystemChooser) {
        File selectedFile = fileSystemChooser.getDefaultSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        return selectedFile.getName();
    }

    static String[] getQuestions(AbstractFileSystemChooser<?> fileSystemChooser) {
        Collection<FileChooserQuestion> fileChooserQuestions = fileSystemChooser.getFileChooserQuestions();
        String[] questions = new String[fileChooserQuestions.size()];
        int index = 0;
        for (FileChooserQuestion fileChooserQuestion : fileChooserQuestions) {
            questions[index++] = fileChooserQuestion.getDescription();
        }
        return questions;
    }

    static boolean[] getQuestionPresets(AbstractFileSystemChooser<?> fileSystemChooser) {
        Collection<FileChooserQuestion> fileChooserQuestions = fileSystemChooser.getFileChooserQuestions();
        boolean[] questionPresets = new boolean[fileChooserQuestions.size()];
        int index = 0;
        for (FileChooserQuestion fileChooserQuestion : fileChooserQuestions) {
            questionPresets[index++] = fileChooserQuestion.isSelected();
        }
        return questionPresets;
    }

    static void saveQuestions(MacosUiHelper.Result result, AbstractFileSystemChooser<?> files) {
        Collection<FileChooserQuestion> fileChooserQuestions = files.getFileChooserQuestions();
        boolean[] answers = result.getAnswers();
        int index = 0;
        for (FileChooserQuestion fileChooserQuestion : fileChooserQuestions) {
            fileChooserQuestion.setSelected(answers[index++]);
        }
    }
}

