/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.comparator;

import com.jidesoft.comparator.ComparatorContext;
import java.io.Serializable;
import java.util.Comparator;

public class CharSequenceComparator
implements Comparator<Object>,
Serializable {
    private static final long serialVersionUID = -4749963150099170895L;
    private boolean _caseSensitive;
    public static final ComparatorContext CONTEXT = new ComparatorContext("IgnoreLocale");
    public static final ComparatorContext CONTEXT_IGNORE_CASE = new ComparatorContext("IgnoreLocale_Ignorecase");

    public CharSequenceComparator() {
        this(true);
    }

    public CharSequenceComparator(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof CharSequence) {
            if (o2 instanceof CharSequence) {
                CharSequence s1 = (CharSequence)o1;
                CharSequence s2 = (CharSequence)o2;
                return this.isCaseSensitive() ? this.compareCase(s1, s2) : this.compareIgnoreCase(s1, s2);
            }
            throw new ClassCastException("The second argument of this method was not a CharSequence: " + o2.getClass().getName());
        }
        if (o2 instanceof Comparable) {
            throw new ClassCastException("The first argument of this method was not a CharSequence: " + o1.getClass().getName());
        }
        throw new ClassCastException("Both arguments of this method were not CharSequences: " + o1.getClass().getName() + " and " + o2.getClass().getName());
    }

    private int compareCase(CharSequence s1, CharSequence s2) {
        int len1 = s1.length();
        int len2 = s2.length();
        int n = Math.min(len1, len2);
        for (int k = 0; k < n; ++k) {
            char c2;
            char c1 = s1.charAt(k);
            if (c1 == (c2 = s2.charAt(k))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    private int compareIgnoreCase(CharSequence s1, CharSequence s2) {
        int n1 = s1.length();
        int n2 = s2.length();
        int i1 = 0;
        for (int i2 = 0; i1 < n1 && i2 < n2; ++i1, ++i2) {
            char c2;
            char c1 = s1.charAt(i1);
            if (c1 == (c2 = s2.charAt(i2)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
            return c1 - c2;
        }
        return n1 - n2;
    }
}

