/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import com.formdev.flatlaf.util.ScaledImageIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URI;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import mediathek.daten.DatenFilm;
import mediathek.gui.dialog.DialogFilmBeschreibung;
import mediathek.gui.tabs.AGuiTabPanel;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.sender_icon_cache.MVSenderIconCache;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXHyperlink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilmDescriptionPanel
extends JPanel {
    private final AGuiTabPanel currentTab;
    private final JScrollPane scrollPane1 = new JScrollPane();
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final SenderIconLabel lblIcon = new SenderIconLabel();
    private final JLabel lblThema = new JLabel();
    private final JLabel lblTitel = new JLabel();
    private final JTextArea textArea = new JTextArea();
    private final JXHyperlink hyperlink = new JXHyperlink();
    private DatenFilm currentFilm;

    public FilmDescriptionPanel(@NotNull AGuiTabPanel currentTab) {
        this.currentTab = currentTab;
        this.initComponents();
        this.createPopupMenu();
        this.setAllFieldsEmpty();
    }

    private void createPopupMenu() {
        JMenuItem item = new JMenuItem("Beschreibung \u00e4ndern...");
        item.addActionListener(l -> {
            DialogFilmBeschreibung dialog = new DialogFilmBeschreibung(MediathekGui.ui(), this.currentFilm);
            dialog.setVisible(true);
        });
        this.popupMenu.add(item);
        this.popupMenu.addSeparator();
        item = new JMenuItem("Beschreibung in Zwischenablage kopieren");
        item.addActionListener(l -> GuiFunktionen.copyToClipboard(this.currentFilm.getDescription()));
        this.popupMenu.add(item);
        item = new JMenuItem("Filmbasisinformationen in Zwischenablage kopieren");
        item.addActionListener(l -> {
            String sb = this.currentFilm.getSender() + " - " + this.currentFilm.getThema() + " - " + this.currentFilm.getTitle();
            GuiFunktionen.copyToClipboard(sb);
        });
        this.popupMenu.add(item);
        this.setComponentPopupMenu(this.popupMenu);
        this.textArea.setComponentPopupMenu(this.popupMenu);
    }

    private void initComponents() {
        this.setLayout(new MigLayout(new LC().hideMode(3), new AC().fill().gap().grow().fill(), new AC().gap().gap().gap()));
        this.lblIcon.setPreferredSize(new Dimension(96, 96));
        this.lblIcon.setVerticalAlignment(1);
        this.add((Component)this.lblIcon, new CC().cell(0, 0, 1, 3).alignX("center").alignY("top").grow(0.0f, 0.0f));
        this.lblThema.setFont(this.lblThema.getFont().deriveFont(this.lblThema.getFont().getStyle() | 1));
        this.add((Component)this.lblThema, new CC().cell(1, 0));
        this.lblTitel.setFont(this.lblTitel.getFont().deriveFont(this.lblTitel.getFont().getStyle() | 1));
        this.add((Component)this.lblTitel, new CC().cell(1, 1));
        this.scrollPane1.setPreferredSize(new Dimension(299, 75));
        this.scrollPane1.setMaximumSize(new Dimension(Integer.MAX_VALUE, 75));
        this.scrollPane1.setMinimumSize(new Dimension(23, 75));
        this.scrollPane1.setHorizontalScrollBarPolicy(31);
        this.textArea.setEditable(false);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.scrollPane1.setViewportView(this.textArea);
        this.add((Component)this.scrollPane1, new CC().cell(1, 2).grow());
        this.add((Component)this.hyperlink, new CC().cell(1, 3));
    }

    public void install(@NotNull JTabbedPane tabbedPane, @NotNull JTable tabelle) {
        tabbedPane.add("Beschreibung", this);
        tabelle.getSelectionModel().addListSelectionListener(e -> this.currentTab.getCurrentlySelectedFilm().ifPresentOrElse(film -> {
            this.showFilmDescription((DatenFilm)film);
            this.currentFilm = film;
        }, () -> {
            this.setAllFieldsEmpty();
            this.currentFilm = null;
        }));
    }

    private void setAllFieldsEmpty() {
        this.hyperlink.setVisible(false);
        this.hyperlink.setText("");
        this.hyperlink.setToolTipText("");
        this.textArea.setText("");
        this.lblIcon.setIcon(null);
        this.lblThema.setText("");
        this.lblTitel.setText("");
    }

    private void showFilmDescription(@NotNull DatenFilm film) {
        this.lblThema.setText(film.getThema());
        this.lblTitel.setText(film.getTitle());
        this.hyperlink.setVisible(true);
        try {
            this.hyperlink.setURI(new URI(film.getWebsiteUrl()));
            this.hyperlink.setText("Link zur Webseite");
            this.hyperlink.setClicked(false);
        }
        catch (Exception e) {
            this.hyperlink.setText("Link nicht verf\u00fcgbar");
        }
        this.hyperlink.setToolTipText(film.getWebsiteUrl());
        this.textArea.setText(film.getDescription());
        SwingUtilities.invokeLater(() -> this.scrollPane1.getVerticalScrollBar().setValue(0));
        this.lblIcon.setSender(film.getSender());
    }

    static class SenderIconLabel
    extends JLabel {
        private static final Dimension ICON_DIMENSION = new Dimension(96, 96);

        public SenderIconLabel() {
            this.setText("");
            this.setIcon(null);
        }

        private void sizeToIcon(@NotNull Icon icon) {
            int height = icon.getIconHeight();
            int width = icon.getIconWidth();
            Dimension d = new Dimension(width, height);
            this.setPreferredSize(d);
        }

        public void setSender(@Nullable String sender) {
            if (sender == null) {
                this.setIcon(null);
            } else {
                MVSenderIconCache.get(sender).ifPresentOrElse(icon -> {
                    Dimension imageDim = new Dimension(icon.getIconWidth(), icon.getIconHeight());
                    Dimension destDim = GuiFunktionen.calculateFittedDimension(imageDim, ICON_DIMENSION);
                    ScaledImageIcon origIcon = new ScaledImageIcon((ImageIcon)icon, destDim.width, destDim.height);
                    this.setIcon(origIcon);
                    this.sizeToIcon(origIcon);
                }, () -> this.setIcon(null));
            }
        }
    }
}

