/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.Version;

final class SegmentMerger {
    private final Directory directory;
    private final Codec codec;
    private final IOContext context;
    final MergeState mergeState;
    private final FieldInfos.Builder fieldInfosBuilder;

    SegmentMerger(List<CodecReader> readers, SegmentInfo segmentInfo, InfoStream infoStream, Directory dir, FieldInfos.FieldNumbers fieldNumbers, IOContext context) throws IOException {
        if (context.context != IOContext.Context.MERGE) {
            throw new IllegalArgumentException("IOContext.context should be MERGE; got: " + context.context);
        }
        this.mergeState = new MergeState(readers, segmentInfo, infoStream);
        this.directory = dir;
        this.codec = segmentInfo.getCodec();
        this.context = context;
        this.fieldInfosBuilder = new FieldInfos.Builder(fieldNumbers);
        Version minVersion = Version.LATEST;
        for (CodecReader reader : readers) {
            Version leafMinVersion = reader.getMetaData().getMinVersion();
            if (leafMinVersion == null) {
                minVersion = null;
                break;
            }
            if (!minVersion.onOrAfter(leafMinVersion)) continue;
            minVersion = leafMinVersion;
        }
        assert (segmentInfo.minVersion == null) : "The min version should be set by SegmentMerger for merged segments";
        segmentInfo.minVersion = minVersion;
        if (this.mergeState.infoStream.isEnabled("SM") && segmentInfo.getIndexSort() != null) {
            this.mergeState.infoStream.message("SM", "index sort during merge: " + segmentInfo.getIndexSort());
        }
    }

    boolean shouldMerge() {
        return this.mergeState.segmentInfo.maxDoc() > 0;
    }

    MergeState merge() throws IOException {
        if (!this.shouldMerge()) {
            throw new IllegalStateException("Merge would result in 0 document segment");
        }
        this.mergeFieldInfos();
        int numMerged = this.mergeWithLogging(this::mergeFields, "stored fields");
        assert (numMerged == this.mergeState.segmentInfo.maxDoc()) : "numMerged=" + numMerged + " vs mergeState.segmentInfo.maxDoc()=" + this.mergeState.segmentInfo.maxDoc();
        SegmentWriteState segmentWriteState = new SegmentWriteState(this.mergeState.infoStream, this.directory, this.mergeState.segmentInfo, this.mergeState.mergeFieldInfos, null, this.context);
        SegmentReadState segmentReadState = new SegmentReadState(this.directory, this.mergeState.segmentInfo, this.mergeState.mergeFieldInfos, IOContext.READ, segmentWriteState.segmentSuffix);
        if (this.mergeState.mergeFieldInfos.hasNorms()) {
            this.mergeWithLogging(this::mergeNorms, segmentWriteState, segmentReadState, "norms", numMerged);
        }
        this.mergeWithLogging(this::mergeTerms, segmentWriteState, segmentReadState, "postings", numMerged);
        if (this.mergeState.mergeFieldInfos.hasDocValues()) {
            this.mergeWithLogging(this::mergeDocValues, segmentWriteState, segmentReadState, "doc values", numMerged);
        }
        if (this.mergeState.mergeFieldInfos.hasPointValues()) {
            this.mergeWithLogging(this::mergePoints, segmentWriteState, segmentReadState, "points", numMerged);
        }
        if (this.mergeState.mergeFieldInfos.hasVectorValues()) {
            this.mergeWithLogging(this::mergeVectorValues, segmentWriteState, segmentReadState, "numeric vectors", numMerged);
        }
        if (this.mergeState.mergeFieldInfos.hasVectors()) {
            this.mergeWithLogging(this::mergeTermVectors, "term vectors");
        }
        this.mergeWithLogging(this::mergeFieldInfos, segmentWriteState, segmentReadState, "field infos", numMerged);
        return this.mergeState;
    }

    private void mergeFieldInfos(SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) throws IOException {
        this.codec.fieldInfosFormat().write(this.directory, this.mergeState.segmentInfo, "", this.mergeState.mergeFieldInfos, this.context);
    }

    private void mergeDocValues(SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) throws IOException {
        try (DocValuesConsumer consumer = this.codec.docValuesFormat().fieldsConsumer(segmentWriteState);){
            consumer.merge(this.mergeState);
        }
    }

    private void mergePoints(SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) throws IOException {
        try (PointsWriter writer = this.codec.pointsFormat().fieldsWriter(segmentWriteState);){
            writer.merge(this.mergeState);
        }
    }

    private void mergeNorms(SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) throws IOException {
        try (NormsConsumer consumer = this.codec.normsFormat().normsConsumer(segmentWriteState);){
            consumer.merge(this.mergeState);
        }
    }

    private void mergeTerms(SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) throws IOException {
        block13: {
            try (NormsProducer norms = this.mergeState.mergeFieldInfos.hasNorms() ? this.codec.normsFormat().normsProducer(segmentReadState) : null;){
                NormsProducer normsMergeInstance = null;
                if (norms != null) {
                    normsMergeInstance = norms.getMergeInstance();
                }
                if (!this.mergeState.mergeFieldInfos.hasPostings()) break block13;
                try (FieldsConsumer consumer = this.codec.postingsFormat().fieldsConsumer(segmentWriteState);){
                    consumer.merge(this.mergeState, normsMergeInstance);
                }
            }
        }
    }

    public void mergeFieldInfos() {
        for (FieldInfos readerFieldInfos : this.mergeState.fieldInfos) {
            for (FieldInfo fi : readerFieldInfos) {
                this.fieldInfosBuilder.add(fi);
            }
        }
        this.mergeState.mergeFieldInfos = this.fieldInfosBuilder.finish();
    }

    private int mergeFields() throws IOException {
        try (StoredFieldsWriter fieldsWriter = this.codec.storedFieldsFormat().fieldsWriter(this.directory, this.mergeState.segmentInfo, this.context);){
            int n = fieldsWriter.merge(this.mergeState);
            return n;
        }
    }

    private int mergeTermVectors() throws IOException {
        try (TermVectorsWriter termVectorsWriter = this.codec.termVectorsFormat().vectorsWriter(this.directory, this.mergeState.segmentInfo, this.context);){
            int numMerged = termVectorsWriter.merge(this.mergeState);
            assert (numMerged == this.mergeState.segmentInfo.maxDoc());
            int n = numMerged;
            return n;
        }
    }

    private void mergeVectorValues(SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) throws IOException {
        try (KnnVectorsWriter writer = this.codec.knnVectorsFormat().fieldsWriter(segmentWriteState);){
            writer.merge(this.mergeState);
        }
    }

    private int mergeWithLogging(Merger merger, String formatName) throws IOException {
        long t0 = 0L;
        if (this.mergeState.infoStream.isEnabled("SM")) {
            t0 = System.nanoTime();
        }
        int numMerged = merger.merge();
        if (this.mergeState.infoStream.isEnabled("SM")) {
            this.mergeState.infoStream.message("SM", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0) + " ms to merge " + formatName + " [" + numMerged + " docs]");
        }
        return numMerged;
    }

    private void mergeWithLogging(VoidMerger merger, SegmentWriteState segmentWriteState, SegmentReadState segmentReadState, String formatName, int numMerged) throws IOException {
        long t0 = 0L;
        if (this.mergeState.infoStream.isEnabled("SM")) {
            t0 = System.nanoTime();
        }
        merger.merge(segmentWriteState, segmentReadState);
        long t1 = System.nanoTime();
        if (this.mergeState.infoStream.isEnabled("SM")) {
            this.mergeState.infoStream.message("SM", TimeUnit.NANOSECONDS.toMillis(t1 - t0) + " ms to merge " + formatName + " [" + numMerged + " docs]");
        }
    }

    private static interface VoidMerger {
        public void merge(SegmentWriteState var1, SegmentReadState var2) throws IOException;
    }

    private static interface Merger {
        public int merge() throws IOException;
    }
}

