#HTML header and navigation bar
def render(dp, fields, vld, html_title, org, sectionset):
	out = []
	out.append("""<!DOCTYPE html>""")
	out.append("""<html lang="en">""")
	out.append("""<head>""")
	out.append("""<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />""")
	out.append("""<meta name="viewport" content="width=device-width, user-scalable=yes">""")
	out.append("""<title>%s</title>""" % html_title)
	# leave this script a the begining to prevent screen blinking when using dark mode
	out.append("""<script type="text/javascript"><!--//--><![CDATA[//><!--
		if (localStorage.getItem('theme')===null || localStorage.getItem('theme')==='dark') { document.documentElement.setAttribute('data-theme', 'dark');}	
		//--><!]]></script>""")
	out.append("""<link rel="stylesheet" href="assets/mfs.css" type="text/css" />""")
	out.append("""</head>""")
	out.append("""<body>""")
	out.append("""<svg xmlns="http://www.w3.org/2000/svg" display="none">
	<symbol id="icon-dark"><path d="M 9.148 0.416 C 9.101 0.2 8.92 0.044 8.701 0.025 C 8.504 0.009 8.307 0 8.107 0 C 4.251 0 1.126 3.134 1.126 7 C 1.126 10.866 4.251 14 8.11 14 C 10.004 14 11.72 13.244 12.979 12.019 C 13.135 11.866 13.176 11.628 13.076 11.434 C 12.976 11.241 12.76 11.131 12.545 11.169 C 12.239 11.222 11.926 11.25 11.604 11.25 C 8.576 11.25 6.12 8.787 6.12 5.75 C 6.12 3.694 7.245 1.903 8.91 0.959 C 9.101 0.85 9.198 0.631 9.151 0.419 L 9.148 0.416 Z"></path></symbol>
	<symbol id="icon-light"><path d="M 7 0 C 7.241 0 7.438 0.197 7.438 0.438 L 7.438 2.625 C 7.438 2.866 7.241 3.063 7 3.063 C 6.759 3.063 6.563 2.866 6.563 2.625 L 6.563 0.438 C 6.563 0.197 6.759 0 7 0 Z M 0 7 C 0 6.759 0.197 6.563 0.438 6.563 L 2.625 6.563 C 2.866 6.563 3.063 6.759 3.063 7 C 3.063 7.241 2.866 7.438 2.625 7.438 L 0.438 7.438 C 0.197 7.438 0 7.241 0 7 Z M 10.938 7 C 10.938 6.759 11.134 6.563 11.375 6.563 L 13.563 6.563 C 13.803 6.563 14 6.759 14 7 C 14 7.241 13.803 7.438 13.563 7.438 L 11.375 7.438 C 11.134 7.438 10.938 7.241 10.938 7 Z M 7 10.938 C 7.241 10.938 7.438 11.134 7.438 11.375 L 7.438 13.563 C 7.438 13.803 7.241 14 7 14 C 6.759 14 6.563 13.803 6.563 13.563 L 6.563 11.375 C 6.563 11.134 6.759 10.938 7 10.938 Z M 2.051 2.051 C 2.22 1.881 2.499 1.881 2.669 2.051 L 4.216 3.598 C 4.386 3.768 4.386 4.047 4.216 4.216 C 4.047 4.386 3.768 4.386 3.598 4.216 L 2.051 2.669 C 1.881 2.499 1.881 2.22 2.051 2.051 Z M 2.051 11.949 C 1.881 11.78 1.881 11.501 2.051 11.331 L 3.598 9.784 C 3.768 9.614 4.047 9.614 4.216 9.784 C 4.386 9.953 4.386 10.232 4.216 10.402 L 2.669 11.949 C 2.499 12.119 2.22 12.119 2.051 11.949 Z M 9.784 4.216 C 9.614 4.047 9.614 3.768 9.784 3.598 L 11.331 2.051 C 11.501 1.881 11.78 1.881 11.949 2.051 C 12.119 2.22 12.119 2.499 11.949 2.669 L 10.402 4.216 C 10.232 4.386 9.953 4.386 9.784 4.216 Z M 9.784 9.784 C 9.953 9.614 10.232 9.614 10.402 9.784 L 11.949 11.331 C 12.119 11.501 12.119 11.78 11.949 11.949 C 11.78 12.119 11.501 12.119 11.331 11.949 L 9.784 10.402 C 9.614 10.232 9.614 9.953 9.784 9.784 Z M 3.938 7 C 3.938 4.642 6.49 3.169 8.531 4.348 C 9.479 4.895 10.063 5.906 10.063 7 C 10.063 9.358 7.51 10.831 5.469 9.652 C 4.521 9.105 3.938 8.094 3.938 7 Z"></path></symbol>
	<symbol id="icon-thumbtack"><path d="M 5.501 8.249 L 2.126 8.249 C 1.894 8.249 1.676 8.145 1.534 7.961 C 1.392 7.778 1.341 7.541 1.397 7.318 L 1.544 6.734 C 1.785 5.765 2.373 4.957 3.154 4.427 L 3.438 0.749 L 2.875 0.749 C 2.807 0.749 2.744 0.732 2.69 0.701 C 2.577 0.636 2.501 0.514 2.501 0.374 C 2.501 0.168 2.669 0 2.875 0 L 8.875 0 C 9.081 0 9.25 0.168 9.25 0.374 C 9.25 0.514 9.175 0.636 9.06 0.701 C 9.006 0.732 8.944 0.749 8.875 0.749 L 8.313 0.749 L 8.597 4.427 C 9.377 4.957 9.965 5.765 10.206 6.734 L 10.352 7.318 C 10.409 7.541 10.359 7.778 10.216 7.961 C 10.075 8.145 9.857 8.249 9.626 8.249 L 6.25 8.249 L 6.25 11.626 C 6.25 11.831 6.081 12 5.854 12 C 5.669 12 5.479 11.831 5.479 11.626 L 5.501 8.249 Z M 3.876 4.847 L 3.576 5.049 C 2.943 5.477 2.467 6.131 2.272 6.914 L 2.126 7.5 L 5.501 7.5 L 5.501 5.249 C 5.501 5.043 5.669 4.874 5.875 4.874 C 6.081 4.874 6.25 5.043 6.25 5.249 L 6.25 7.5 L 9.626 7.5 L 9.48 6.914 C 9.283 6.131 8.807 5.477 8.175 5.049 L 7.877 4.847 L 7.56 0.749 L 4.19 0.749 L 3.876 4.847 Z"></path></symbol>
	<symbol id="icon-thumbtack-rot"><path d="M 3.573 7.857 L 1.187 5.47 C 1.023 5.306 0.942 5.079 0.972 4.848 C 1.001 4.618 1.132 4.415 1.33 4.297 L 1.846 3.988 C 2.702 3.473 3.689 3.317 4.616 3.495 L 7.418 1.095 L 7.02 0.697 C 6.972 0.649 6.939 0.592 6.923 0.532 C 6.889 0.406 6.921 0.266 7.02 0.167 C 7.166 0.021 7.404 0.021 7.549 0.167 L 11.792 4.41 C 11.938 4.555 11.938 4.794 11.793 4.939 C 11.694 5.038 11.554 5.072 11.427 5.036 C 11.367 5.02 11.311 4.988 11.262 4.939 L 10.865 4.542 L 8.465 7.344 C 8.642 8.27 8.486 9.257 7.971 10.113 L 7.662 10.629 C 7.544 10.827 7.341 10.959 7.111 10.987 C 6.881 11.018 6.653 10.937 6.49 10.774 L 4.103 8.387 L 1.715 10.774 C 1.57 10.919 1.331 10.919 1.17 10.759 C 1.04 10.628 1.025 10.374 1.17 10.229 L 3.573 7.857 Z M 4.83 4.302 L 4.475 4.233 C 3.725 4.088 2.926 4.214 2.234 4.63 L 1.716 4.941 L 4.103 7.327 L 5.695 5.736 C 5.84 5.59 6.079 5.589 6.224 5.735 C 6.37 5.881 6.37 6.12 6.224 6.265 L 4.632 7.857 L 7.02 10.244 L 7.331 9.726 C 7.745 9.034 7.871 8.235 7.727 7.485 L 7.659 7.131 L 10.332 4.01 L 7.95 1.627 L 4.83 4.302 Z"></path></symbol>
	<symbol id="icon-sort-up"><path d="M 1.101 6.601 L 9.899 6.601 C 10.874 6.601 11.368 5.415 10.677 4.723 L 6.307 0.322 C 5.877 -0.107 5.177 -0.107 4.748 0.322 L 0.319 4.724 C -0.368 5.415 0.126 6.601 1.101 6.601 Z M 5.5 1.099 L 9.87 5.501 L 1.072 5.501 L 5.5 1.099 Z"></path></symbol>
	<symbol id="icon-sort-down"><path d="M 9.896 0 L 1.1 0 C 0.125 0 -0.369 1.186 0.322 1.878 L 4.691 6.278 C 5.121 6.707 5.821 6.707 6.25 6.278 L 10.619 1.878 C 11.395 1.186 10.9 0 9.896 0 Z M 5.496 5.5 L 1.129 1.1 L 9.925 1.1 L 5.496 5.5 Z"></path></symbol>
	<symbol id="icon-progress-dot"><path d="M 5 0.832 C 5.118 0.832 5.214 0.942 5.214 1.075 L 5.214 2.288 C 5.214 2.423 5.118 2.532 5 2.532 C 4.881 2.532 4.785 2.423 4.785 2.288 L 4.785 1.075 C 4.785 0.942 4.881 0.832 5 0.832 Z"></path></symbol>
	<symbol id="icon-info"><path d="M 1.714 1.286 C 1.479 1.286 1.286 1.479 1.286 1.714 L 1.286 10.286 C 1.286 10.521 1.479 10.714 1.714 10.714 L 10.286 10.714 C 10.521 10.714 10.714 10.521 10.714 10.286 L 10.714 1.714 C 10.714 1.479 10.521 1.286 10.286 1.286 L 1.714 1.286 Z M 0 1.714 C 0 0.769 0.769 0 1.714 0 L 10.286 0 C 11.231 0 12 0.769 12 1.714 L 12 10.286 C 12 11.231 11.231 12 10.286 12 L 1.714 12 C 0.769 12 0 11.231 0 10.286 L 0 1.714 Z M 4.929 8.143 L 5.571 8.143 L 5.571 6.429 L 4.929 6.429 C 4.572 6.429 4.286 6.142 4.286 5.786 C 4.286 5.429 4.572 5.143 4.929 5.143 L 6.214 5.143 C 6.571 5.143 6.857 5.429 6.857 5.786 L 6.857 8.143 L 7.071 8.143 C 7.428 8.143 7.714 8.429 7.714 8.786 C 7.714 9.142 7.428 9.429 7.071 9.429 L 4.929 9.429 C 4.572 9.429 4.286 9.142 4.286 8.786 C 4.286 8.429 4.572 8.143 4.929 8.143 Z M 6 2.571 C 6.66 2.571 7.072 3.286 6.742 3.857 C 6.589 4.122 6.306 4.286 6 4.286 C 5.34 4.286 4.928 3.571 5.258 3 C 5.411 2.735 5.694 2.571 6 2.571 Z"></path></symbol>
	<symbol id="icon-ok"><path d="M 5.697 11.982 C 10.309 11.982 13.191 6.99 10.885 2.996 C 9.815 1.142 7.837 0 5.697 0 C 1.085 0 -1.798 4.993 0.508 8.987 C 1.578 10.84 3.556 11.982 5.697 11.982 Z M 8.341 4.891 L 5.346 7.887 C 5.126 8.107 4.77 8.107 4.552 7.887 L 3.055 6.389 C 2.835 6.169 2.835 5.813 3.055 5.596 C 3.275 5.378 3.63 5.376 3.848 5.596 L 4.948 6.695 L 7.545 4.095 C 7.765 3.875 8.121 3.875 8.339 4.095 C 8.556 4.315 8.559 4.671 8.339 4.889 L 8.341 4.891 Z"></path></symbol>
	<symbol id="icon-ok-circle"><path d="M 5.714 7.964 C 5.459 8.22 5.041 8.22 4.786 7.964 L 3.286 6.464 C 3.03 6.209 3.03 5.791 3.286 5.536 C 3.541 5.28 3.959 5.28 4.214 5.536 L 5.25 6.572 L 7.786 4.036 C 8.041 3.78 8.459 3.78 8.714 4.036 C 8.97 4.291 8.97 4.709 8.714 4.964 L 5.714 7.964 Z M 12 6 C 12 9.314 9.314 12 6 12 C 2.686 12 0 9.314 0 6 C 0 2.686 2.686 0 6 0 C 9.314 0 12 2.686 12 6 Z M 6 1.125 C 3.307 1.125 1.125 3.307 1.125 6 C 1.125 8.693 3.307 10.875 6 10.875 C 8.693 10.875 10.875 8.693 10.875 6 C 10.875 3.307 8.693 1.125 6 1.125 Z"></path></symbol>
	<symbol id="icon-warning-2color-a"><polygon points="5.91 2.082 11.496 11.32 0.378 11.213" style="fill: rgb(222, 212, 68);"></polygon><path  d="M 11.867 10.525 L 6.871 2 C 6.679 1.672 6.342 1.508 6.005 1.508 C 5.667 1.508 5.33 1.672 5.117 2 L 0.124 10.525 C -0.239 11.178 0.24 12 1.01 12 L 11.001 12 C 11.768 12 12.248 11.18 11.867 10.525 Z M 1.241 10.876 L 5.983 2.745 L 10.768 10.876 L 1.241 10.876 Z M 6.005 8.653 C 5.598 8.653 5.268 8.983 5.268 9.39 C 5.268 9.796 5.599 10.126 6.006 10.126 C 6.412 10.126 6.741 9.796 6.741 9.39 C 6.74 8.984 6.412 8.653 6.005 8.653 Z M 5.443 5.068 L 5.443 7.316 C 5.443 7.628 5.695 7.878 6.005 7.878 C 6.314 7.878 6.567 7.626 6.567 7.316 L 6.567 5.068 C 6.567 4.759 6.316 4.506 6.005 4.506 C 5.693 4.506 5.443 4.759 5.443 5.068 Z"></path></symbol>
	<symbol id="icon-warning-2color-b"><rect style="fill: black;" x="4.955" y="3.748" width="2.154" height="7.214"/><path d="M 5.999 1.499 C 6.332 1.499 6.639 1.675 6.808 1.963 L 11.871 10.589 C 12.042 10.879 12.042 11.238 11.876 11.529 C 11.709 11.819 11.398 12 11.062 12 L 0.937 12 C 0.601 12 0.29 11.819 0.123 11.529 C -0.043 11.238 -0.041 10.877 0.128 10.589 L 5.191 1.963 C 5.36 1.675 5.667 1.499 5.999 1.499 Z M 5.999 4.499 C 5.688 4.499 5.437 4.75 5.437 5.062 L 5.437 7.687 C 5.437 7.999 5.688 8.249 5.999 8.249 C 6.311 8.249 6.562 7.999 6.562 7.687 L 6.562 5.062 C 6.562 4.75 6.311 4.499 5.999 4.499 Z M 6.75 9.75 C 6.75 9.172 6.124 8.811 5.624 9.1 C 5.392 9.234 5.249 9.482 5.249 9.75 C 5.249 10.327 5.874 10.688 6.375 10.399 C 6.607 10.265 6.75 10.018 6.75 9.75 Z"/></symbol>
	<symbol id="icon-warning"><path d="M 5.999 0 C 6.332 0 6.639 0.176 6.808 0.464 L 11.871 9.09 C 12.042 9.38 12.042 9.739 11.876 10.03 C 11.709 10.32 11.398 10.501 11.062 10.501 L 0.937 10.501 C 0.601 10.501 0.29 10.32 0.123 10.03 C -0.043 9.739 -0.041 9.378 0.128 9.09 L 5.191 0.464 C 5.36 0.176 5.667 0 5.999 0 Z M 5.999 2.795 C 5.466 2.79 5.1 3.251 5.1 3.563 L 5.1 6.188 C 5.1 6.5 5.5 6.869 5.999 6.872 C 6.498 6.875 6.9 6.5 6.9 6.188 L 6.9 3.563 C 6.9 3.251 6.532 2.8 5.999 2.795 Z M 6.9 8.401 C 6.9 7.864 6.5 7.501 6 7.501 C 5.504 7.501 5.1 7.896 5.1 8.401 C 5.1 8.935 5.525 9.301 6 9.301 C 6.469 9.301 6.9 8.845 6.9 8.401 Z"></path></symbol>
	<symbol id="icon-error"><path d="M 3.408 0.473 C 3.711 0.171 4.122 0 4.551 0 L 7.45 0 C 7.878 0 8.289 0.171 8.594 0.473 L 11.276 3.158 C 11.579 3.461 11.75 3.872 11.75 4.301 L 11.75 7.2 C 11.75 7.628 11.579 8.04 11.276 8.344 L 8.594 11.026 C 8.289 11.329 7.878 11.5 7.45 11.5 L 4.551 11.5 C 4.122 11.5 3.711 11.329 3.408 11.026 L 0.723 8.344 C 0.421 8.04 0.25 7.628 0.25 7.2 L 0.25 4.301 C 0.25 3.872 0.421 3.461 0.723 3.158 L 3.408 0.473 Z M 5.137 3.354 L 5.137 5.942 C 5.137 6.517 5.712 6.708 6 6.708 C 6.287 6.708 6.897 6.496 6.862 5.942 L 6.862 3.354 C 6.862 2.779 6.287 2.587 6 2.587 C 5.712 2.587 5.153 2.762 5.137 3.354 Z M 6 7.168 C 5.438 7.15 5.042 7.475 5.046 8.02 C 5.042 8.625 5.42 9.005 6 9.008 C 6.58 9.011 6.958 8.625 6.916 8.046 C 6.911 7.498 6.562 7.187 6 7.168 Z"></path></symbol>
	<symbol id="icon-go-up"><path d="M 0.562 10.825 C 0.251 10.825 0 11.076 0 11.388 C 0 11.699 0.251 11.95 0.562 11.95 L 3 11.95 C 4.139 11.95 5.062 11.027 5.062 9.888 L 5.062 1.871 L 7.101 3.909 C 7.321 4.13 7.677 4.13 7.895 3.909 C 8.113 3.689 8.116 3.333 7.895 3.115 L 4.898 0.115 C 4.678 -0.105 4.321 -0.105 4.104 0.115 L 1.101 3.115 C 0.881 3.335 0.881 3.691 1.101 3.909 C 1.322 4.127 1.678 4.13 1.896 3.909 L 3.935 1.871 L 3.937 9.888 C 3.937 10.406 3.518 10.825 3 10.825 L 0.562 10.825 Z"></path></symbol>
	<symbol id="icon-close"><path d="M 10.78 2.282 C 11.073 1.989 11.073 1.514 10.78 1.223 C 10.486 0.933 10.011 0.93 9.721 1.223 L 6.003 4.941 L 2.282 1.22 C 1.989 0.927 1.514 0.927 1.223 1.22 C 0.933 1.514 0.93 1.989 1.223 2.279 L 4.941 5.997 L 1.22 9.718 C 0.927 10.011 0.927 10.486 1.22 10.777 C 1.514 11.067 1.989 11.07 2.279 10.777 L 5.997 7.059 L 9.718 10.78 C 10.011 11.073 10.486 11.073 10.777 10.78 C 11.067 10.486 11.07 10.011 10.777 9.721 L 7.059 6.003 L 10.78 2.282 Z"></path></symbol>
	<symbol id="icon-wrench"><path d="M 7.554 6.281 C 7.774 6.342 8.006 6.375 8.25 6.375 C 9.668 6.375 10.823 5.25 10.873 3.844 L 10.28 4.437 C 9.998 4.718 9.616 4.875 9.218 4.875 L 8.625 4.875 C 7.798 4.875 7.125 4.202 7.125 3.375 L 7.125 2.78 C 7.125 2.381 7.282 1.999 7.563 1.718 L 8.156 1.127 C 6.75 1.174 5.625 2.332 5.625 3.75 C 5.625 3.991 5.658 4.226 5.719 4.446 C 5.827 4.835 5.714 5.252 5.428 5.538 L 1.338 9.626 C 1.2 9.762 1.125 9.949 1.125 10.144 C 1.125 10.547 1.453 10.875 1.856 10.875 C 2.051 10.875 2.236 10.798 2.374 10.662 L 6.462 6.572 C 6.748 6.286 7.165 6.176 7.554 6.281 Z M 9.952 0.923 L 8.36 2.515 C 8.29 2.585 8.25 2.681 8.25 2.78 L 8.25 3.375 C 8.25 3.581 8.419 3.75 8.625 3.75 L 9.22 3.75 C 9.319 3.75 9.415 3.71 9.485 3.64 L 11.077 2.048 C 11.245 1.88 11.529 1.91 11.632 2.126 C 11.869 2.618 12 3.169 12 3.75 C 12 5.822 10.322 7.5 8.25 7.5 C 7.905 7.5 7.573 7.453 7.259 7.366 L 3.169 11.456 C 2.82 11.805 2.348 12 1.856 12 C 0.832 12 0 11.168 0 10.144 C 0 9.652 0.195 9.18 0.544 8.831 L 4.634 4.741 C 4.547 4.427 4.5 4.095 4.5 3.75 C 4.5 1.678 6.178 0 8.25 0 C 8.831 0 9.382 0.134 9.874 0.368 C 10.09 0.471 10.12 0.755 9.952 0.923 Z M 2.063 9.563 C 2.351 9.563 2.532 9.875 2.387 10.125 C 2.32 10.241 2.196 10.313 2.063 10.313 C 1.774 10.313 1.593 10 1.738 9.75 C 1.805 9.634 1.929 9.563 2.063 9.563 Z"></path></symbol>
	<symbol id="icon-stopwatch"><path d="M 3.001 0.563 C 3.001 0.251 3.251 0 3.563 0 L 6.189 0 C 6.5 0 6.751 0.251 6.751 0.563 C 6.751 0.874 6.5 1.125 6.189 1.125 L 5.439 1.125 L 5.439 2.283 C 6.456 2.4 7.38 2.829 8.106 3.476 L 8.791 2.79 C 9.011 2.569 9.367 2.569 9.585 2.79 C 9.803 3.01 9.806 3.366 9.585 3.584 L 8.859 4.311 C 9.421 5.106 9.752 6.076 9.752 7.124 C 9.752 9.818 7.569 12 4.876 12 C 2.182 12 0 9.82 0 7.126 C 0 4.623 1.885 2.562 4.313 2.283 L 4.313 1.125 L 3.563 1.125 C 3.251 1.125 3.001 0.874 3.001 0.563 Z M 4.876 10.877 C 7.763 10.877 9.568 7.752 8.124 5.251 C 7.454 4.091 6.216 3.376 4.876 3.376 C 1.989 3.376 0.184 6.501 1.628 9.002 C 2.298 10.162 3.536 10.877 4.876 10.877 Z M 5.439 5.063 L 5.439 7.501 C 5.439 7.813 5.188 8.064 4.876 8.064 C 4.564 8.064 4.313 7.813 4.313 7.501 L 4.313 5.063 C 4.313 4.752 4.564 4.501 4.876 4.501 C 5.188 4.501 5.439 4.752 5.439 5.063 Z"></path></symbol>
	<symbol id="icon-solid-question"><path d="M 0 1.5 C 0 0.673 0.673 0 1.5 0 L 10.5 0 C 11.327 0 12 0.673 12 1.5 L 12 8.25 C 12 9.077 11.327 9.75 10.5 9.75 L 7.249 9.75 L 4.35 11.925 C 4.238 12.009 4.085 12.023 3.956 11.96 C 3.827 11.897 3.75 11.768 3.75 11.625 L 3.75 9.75 L 1.5 9.75 C 0.673 9.75 0 9.077 0 8.25 L 0 1.5 Z M 3.98 2.749 L 3.97 2.777 C 3.867 3.07 4.02 3.391 4.313 3.495 C 4.605 3.598 4.927 3.445 5.03 3.152 L 5.039 3.124 C 5.065 3.049 5.137 3 5.215 3 L 6.581 3 C 6.778 3 6.935 3.159 6.935 3.354 C 6.935 3.48 6.867 3.598 6.757 3.661 L 5.719 4.256 C 5.543 4.357 5.435 4.542 5.435 4.744 L 5.435 5.063 C 5.435 5.374 5.686 5.625 5.998 5.625 C 6.305 5.625 6.555 5.379 6.56 5.072 L 7.317 4.638 C 7.777 4.373 8.06 3.884 8.06 3.354 C 8.06 2.536 7.397 1.875 6.581 1.875 L 5.217 1.875 C 4.662 1.875 4.167 2.224 3.98 2.749 L 3.98 2.749 Z M 6.75 7.125 C 6.75 6.548 6.125 6.187 5.625 6.475 C 5.393 6.609 5.25 6.857 5.25 7.125 C 5.25 7.702 5.875 8.063 6.375 7.775 C 6.607 7.641 6.75 7.393 6.75 7.125 Z"></path></symbol>
	<symbol id="icon-chevron"><path d="M 5.526 2.861 C 5.787 2.6 6.21 2.6 6.468 2.861 L 11.805 8.195 C 12.066 8.456 12.066 8.878 11.805 9.136 C 11.543 9.395 11.121 9.398 10.863 9.136 L 6.001 4.275 L 1.137 9.139 C 0.876 9.4 0.454 9.4 0.195 9.139 C -0.063 8.878 -0.066 8.456 0.195 8.197 L 5.526 2.861 Z"></path></symbol>
	<symbol id="icon-bars"><path d="M 0 0.857 C 0 0.383 0.383 0 0.857 0 L 11.143 0 C 11.617 0 12 0.383 12 0.857 C 12 1.331 11.617 1.714 11.143 1.714 L 0.857 1.714 C 0.383 1.714 0 1.331 0 0.857 Z M 0 5.143 C 0 4.669 0.383 4.286 0.857 4.286 L 11.143 4.286 C 11.617 4.286 12 4.669 12 5.143 C 12 5.617 11.617 6 11.143 6 L 0.857 6 C 0.383 6 0 5.617 0 5.143 Z M 12 9.428 C 12 9.903 11.617 10.286 11.143 10.286 L 0.857 10.286 C 0.383 10.286 0 9.903 0 9.428 C 0 8.955 0.383 8.571 0.857 8.571 L 11.143 8.571 C 11.617 8.571 12 8.955 12 9.428 Z"></path></symbol>
	</svg>""")
	#<symbol id=""><path d=""></path></symbol>
	out.append("""<span class="charttooltip" id="charttooltip"></span>""")
	out.append("""<span class="charthline" id="charthlineup"></span>""")
	out.append("""<span class="charthline" id="charthlinedown"></span>""")
	out.append("""<div id="tooltip" class="tooltip"></div> <!-- Tooltip container -->""")

	#MENUBAR
	logo_src="assets/logo.svg"
	out.append("""<div id="header">""")
	out.append("""<table class="header-table">""")
	out.append("""<tr>""")
	out.append("""<td class="logo"><a href="https://moosefs.com/">""")
	out.append("""<img class="lg" src="%s" alt="logo" />""" % logo_src)
	out.append("""<img class="sm" src="assets/logomini.svg" alt="logo" />""")
	out.append("""<img class="xs md" src="%s" alt="logo" />""" % logo_src)
	out.append("""</a></td>""")
	out.append("""<td class="lg sm menu">""")

	# menu for wide and medium screens
	out.append("""<table class="menu">""")
	out.append("""<tr>""")
	last="U"
	for menu_item in org.menu_tree:
		id = menu_item[0]
		name = org.sections_defs[id][0]
		if menu_item==org.menu_tree[-1]:
			last = "L%s" % last
		if id in sectionset:
			if len(sectionset)<=1:
				out.append("""<td class="%sS">%s<svg class="thumbtack active"><use xlink:href="#icon-thumbtack"/></svg></td>""" % (last,name)) 
			else:
				out.append("""<td class="%sS"><a href="%s">%s</a><a href="%s"><svg class="thumbtack active"><use xlink:href="#icon-thumbtack"/></svg></a></td>""" % (last,fields.createhtmllink({"sections":id}),name,fields.createhtmllink({"sections":"-".join(sectionset-set([id]))})))
			last="S"
		else:
			out.append("""<td class="%sU"><a href="%s">%s</a><a href="%s"><svg class="thumbtack"><use xlink:href="#icon-thumbtack"/></svg></a></td>""" % (last,fields.createhtmllink({"sections":id}),name,fields.createhtmllink({"sections":"-".join(sectionset|set([id]))})))
			last="U"
	out.append("""</tr>""")
	out.append("""</table>""")
	out.append("""</td>""")  #class="menu"

	# hamburger menu for small screens
	out.append("""<td class="xs md menu menu-hamburger">""")
	out.append("""<svg id="btn-menu-hamburger" onclick="toggleHamburger()"><use transform="scale(3)" xlink:href="#icon-bars"/></svg>""")
	out.append("""</td>""")  #class="menu-hamburger"

	out.append("""<td class="filler">""")
	out.append("""</td>""")
	out.append("""</tr>""")
	out.append("""</table>""") #class="header-table"
	out.append("""</div>""") #id="header"

	# hamburger menu content in a separate div
	out.append("""<div id="hamburger-menu-conent" class="">""")
	out.append("""<ul class="hamburger-menu">""")
	for menu_item in org.menu_tree:
		id = menu_item[0]
		name = org.sections_defs[id][0]
		if id in sectionset:
			if len(sectionset)<=1:
				out.append("""<li class="S">%s<svg class="thumbtack active"><use xlink:href="#icon-thumbtack"/></svg></li>""" % (name)) 
			else:
				out.append("""<li class="S"><a href="%s">%s</a><a href="%s"><svg class="thumbtack active"><use xlink:href="#icon-thumbtack"/></svg></a></li>""" % (fields.createhtmllink({"sections":id}),name,fields.createhtmllink({"sections":"-".join(sectionset-set([id]))})))
		else:
			out.append("""<li class="U"><a href="%s">%s</a><a href="%s"><svg class="thumbtack"><use xlink:href="#icon-thumbtack"/></svg></a></li>""" % (fields.createhtmllink({"sections":id}),name,fields.createhtmllink({"sections":"-".join(sectionset|set([id]))})))
	out.append("""</ul>""")
	out.append("""</div>""") 

	return out
