"use strict";(globalThis.webpackChunknextcloud_ui_legacy=globalThis.webpackChunknextcloud_ui_legacy||[]).push([[4723],{35412(t,e,n){n.d(e,{A:()=>a});var o=n(71354),i=n.n(o),l=n(76314),s=n.n(l)()(i());s.push([t.id,"\n._dialogConfirmFileHidden__checkbox_CoKAM {\n\tmargin-top: 1rem;\n}\n","",{version:3,sources:["webpack://./apps/files/src/views/DialogConfirmFileHidden.vue"],names:[],mappings:";AAwEA;CACA,gBAAA;AACA",sourcesContent:["\x3c!--\n - SPDX-FileCopyrightText: 2026 Nextcloud GmbH and Nextcloud contributors\n - SPDX-License-Identifier: AGPL-3.0-or-later\n--\x3e\n\n<script setup lang=\"ts\">\nimport { t } from '@nextcloud/l10n'\nimport { computed, ref } from 'vue'\nimport NcButton from '@nextcloud/vue/components/NcButton'\nimport NcCheckboxRadioSwitch from '@nextcloud/vue/components/NcCheckboxRadioSwitch'\nimport NcDialog from '@nextcloud/vue/components/NcDialog'\nimport { useUserConfigStore } from '../store/userconfig.ts'\n\nconst props = defineProps<{\n\tfilename: string\n}>()\n\nconst emit = defineEmits<{\n\t(e: 'close', v: boolean): void\n}>()\n\nconst userConfigStore = useUserConfigStore()\nconst dontShowAgain = computed({\n\tget: () => !userConfigStore.userConfig.show_dialog_file_extension,\n\tset: (value: boolean) => userConfigStore.update('show_dialog_file_extension', !value),\n})\n\n/** Open state of the dialog */\nconst open = ref(true)\n\n/**\n * Close the dialog and emit the response\n *\n * @param value User selected response\n */\nfunction closeDialog(value: boolean) {\n\temit('close', value)\n\topen.value = false\n}\n<\/script>\n\n<template>\n\t<NcDialog\n\t\tno-close\n\t\t:open=\"open\"\n\t\t:name=\"t('files', 'Rename file to hidden')\"\n\t\tsize=\"small\">\n\t\t<div>\n\t\t\t<p>\n\t\t\t\t{{ t('files', 'Prefixing a filename with a dot may render the file hidden.') }}\n\t\t\t\t{{ t('files', 'Are you sure you want to rename the file to \"{filename}\"?', { filename: props.filename }) }}\n\t\t\t</p>\n\n\t\t\t<NcCheckboxRadioSwitch\n\t\t\t\tv-model=\"dontShowAgain\"\n\t\t\t\t:class=\"$style.dialogConfirmFileHidden__checkbox\"\n\t\t\t\ttype=\"switch\">\n\t\t\t\t{{ t('files', 'Do not show this dialog again.') }}\n\t\t\t</NcCheckboxRadioSwitch>\n\t\t</div>\n\t\t<template #actions>\n\t\t\t<NcButton variant=\"secondary\" @click=\"closeDialog(false)\">\n\t\t\t\t{{ t('files', 'Cancel') }}\n\t\t\t</NcButton>\n\t\t\t<NcButton variant=\"primary\" @click=\"closeDialog(true)\">\n\t\t\t\t{{ t('files', 'Rename') }}\n\t\t\t</NcButton>\n\t\t</template>\n\t</NcDialog>\n</template>\n\n<style module>\n.dialogConfirmFileHidden__checkbox {\n\tmargin-top: 1rem;\n}\n</style>\n"],sourceRoot:""}]),s.locals={dialogConfirmFileHidden__checkbox:"_dialogConfirmFileHidden__checkbox_CoKAM"};const a=s},54723(t,e,n){n.r(e),n.d(e,{default:()=>k});var o=n(85471),i=n(53334),l=n(74095),s=n(32073),a=n(94219),c=n(69379);const r=(0,o.pM)({__name:"DialogConfirmFileHidden",props:{filename:null},emits:["close"],setup(t,{emit:e}){const n=t,r=(0,c.O)(),d=(0,o.EW)({get:()=>!r.userConfig.show_dialog_file_extension,set:t=>r.update("show_dialog_file_extension",!t)}),u=(0,o.KR)(!0);return{__sfc:!0,props:n,emit:e,userConfigStore:r,dontShowAgain:d,open:u,closeDialog:function(t){e("close",t),u.value=!1},t:i.t,NcButton:l.A,NcCheckboxRadioSwitch:s.A,NcDialog:a.A}}});var d=n(85072),u=n.n(d),f=n(97825),m=n.n(f),p=n(77659),g=n.n(p),h=n(55056),_=n.n(h),v=n(10540),C=n.n(v),x=n(41113),A=n.n(x),w=n(35412),b={};b.styleTagTransform=A(),b.setAttributes=_(),b.insert=g().bind(null,"head"),b.domAPI=m(),b.insertStyleElement=C(),u()(w.A,b);const y=w.A&&w.A.locals?w.A.locals:void 0,k=(0,n(14486).A)(r,function(){var t=this,e=t._self._c,n=t._self._setupProxy;return e(n.NcDialog,{attrs:{"no-close":"",open:n.open,name:n.t("files","Rename file to hidden"),size:"small"},scopedSlots:t._u([{key:"actions",fn:function(){return[e(n.NcButton,{attrs:{variant:"secondary"},on:{click:function(t){return n.closeDialog(!1)}}},[t._v("\n\t\t\t"+t._s(n.t("files","Cancel"))+"\n\t\t")]),t._v(" "),e(n.NcButton,{attrs:{variant:"primary"},on:{click:function(t){return n.closeDialog(!0)}}},[t._v("\n\t\t\t"+t._s(n.t("files","Rename"))+"\n\t\t")])]},proxy:!0}])},[e("div",[e("p",[t._v("\n\t\t\t"+t._s(n.t("files","Prefixing a filename with a dot may render the file hidden."))+"\n\t\t\t"+t._s(n.t("files",'Are you sure you want to rename the file to "{filename}"?',{filename:n.props.filename}))+"\n\t\t")]),t._v(" "),e(n.NcCheckboxRadioSwitch,{class:t.$style.dialogConfirmFileHidden__checkbox,attrs:{type:"switch"},model:{value:n.dontShowAgain,callback:function(t){n.dontShowAgain=t},expression:"dontShowAgain"}},[t._v("\n\t\t\t"+t._s(n.t("files","Do not show this dialog again."))+"\n\t\t")])],1)])},[],!1,function(t){this.$style=y.locals||y},null,null).exports}}]);
//# sourceMappingURL=4723-4723.js.map?v=934c36402dc782526ac6