/* Copyright 2018, NVIDIA CORPORATION. All rights reserved. */

/* tr1/special_function_util.h has one #if that should always be false for
 * PGI compilers:
 *   #if _GLIBCXX_USE_C99_MATH && !_GLIBCXX_USE_C99_FP_MACROS_DYNAMIC
 * Rather than make a copy of the file and change that line, manipulate one of
 * the macros in that #if to have the desired effect.  This works because that
 * macro is used in only one place and there are no nested #includes. */

#if _GLIBCXX_USE_C99_MATH
  #define _PGI_USE_C99_MATH_WAS_TRUE 1
  #undef _GLIBCXX_USE_C99_MATH
#endif

#include_next <tr1/special_function_util.h>

#if _PGI_USE_C99_MATH_WAS_TRUE
  #define _GLIBCXX_USE_C99_MATH 1
  #undef _PGI_USE_C99_MATH_WAS_TRUE
#endif
