/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.extra;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.regex.Pattern;

public final class MacAddressFormatAttribute
extends AbstractFormatAttribute {
    private static final FormatAttribute instance = new MacAddressFormatAttribute();
    private static final Pattern MACADDR = Pattern.compile("[A-Za-z0-9]{2}(?::[A-Za-z0-9]{2}){5}");

    public static FormatAttribute getInstance() {
        return instance;
    }

    private MacAddressFormatAttribute() {
        super("mac", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        if (!MACADDR.matcher(input).matches()) {
            report.error(this.newMsg(data, bundle, "err.format.macAddr.invalid").putArgument("value", input));
        }
    }
}

