/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import java.util.Objects;

public final class Change<T> {
    private final T oldValue;
    private final T newValue;
    private final Type type;

    public static <T> Change<T> changed(T oldValue, T newValue) {
        return new Change<T>(oldValue, newValue, Type.CHANGED);
    }

    public static <T> Change<T> added(T newValue) {
        return new Change<Object>(null, newValue, Type.ADDED);
    }

    public static <T> Change<T> removed(T oldValue) {
        return new Change<Object>(oldValue, null, Type.REMOVED);
    }

    public Change(T oldValue, T newValue, Type type) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.type = type;
    }

    public T getOldValue() {
        return this.oldValue;
    }

    public T getNewValue() {
        return this.newValue;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Change change = (Change)o;
        return Objects.equals(this.oldValue, change.oldValue) && Objects.equals(this.newValue, change.newValue) && this.type == change.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.oldValue, this.newValue, this.type});
    }

    public String toString() {
        return "Change(oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ", type=" + (Object)((Object)this.getType()) + ")";
    }

    public static enum Type {
        ADDED,
        CHANGED,
        REMOVED;

    }
}

