/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.ROWID;

abstract class CharCommonAccessor
extends Accessor {
    private static final String CLASS_NAME = CharCommonAccessor.class.getName();
    int max_len = 0;
    protected static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss z", "EEE MMM dd HH:mm:ss z yyyy", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "HH:mm:ss z", "HH:mm:ss"};
    private static final DateTimeFormatter ORACLE_DATE_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 9, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, false).optionalEnd().optionalEnd().optionalStart().appendLiteral(' ').appendZoneId().optionalEnd().toFormatter();
    private static final DateTimeFormatter ORACLE_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, false).optionalEnd().optionalStart().appendLiteral(' ').appendZoneId().optionalEnd().toFormatter();
    private static final DateTimeFormatter[] DATE_TIME_FORMATTERS = new DateTimeFormatter[]{ORACLE_DATE_TIME, DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.RFC_1123_DATE_TIME, DateTimeFormatter.ISO_DATE, ORACLE_TIME, DateTimeFormatter.ISO_TIME, JavaToJavaConverter.OFFSET_DATE_TIME_FORMAT, JavaToJavaConverter.DATE_TIME_FORMAT};

    CharCommonAccessor(OracleStatement _statement, int _representationMaxLength, short form, boolean isStoredInBindData) {
        super(form == 2 ? Representation.NVARCHAR : Representation.VARCHAR, _statement, _representationMaxLength, isStoredInBindData);
    }

    void init(OracleStatement stmt, int internal_type, int database_type, int max_len, short form, int external_type, boolean isOutBind, int newer) throws SQLException {
        if (isOutBind) {
            if (internal_type != 23) {
                internal_type = 1;
            }
            if (stmt.maxFieldSize > 0 && (max_len == -1 || max_len < stmt.maxFieldSize)) {
                max_len = stmt.maxFieldSize;
            }
        }
        this.init(stmt, internal_type, database_type, form, isOutBind);
        if (isOutBind && stmt.connection.defaultnchar) {
            this.formOfUse = (short)2;
        }
        this.initForDataAccess(external_type, max_len, null);
    }

    void init(OracleStatement stmt, int internal_type, int database_type, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int maxCodePointLen) throws SQLException {
        this.init(stmt, internal_type, database_type, form, false);
        this.initForDescribe(internal_type, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null, maxCodePointLen);
        int max_field_size = stmt.maxFieldSize;
        if (max_field_size != 0 && max_field_size <= max_len) {
            max_len = max_field_size;
        }
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        this.max_len = max_len;
        if (external_type != 0) {
            this.externalType = external_type;
        }
        this.charLength = this.isNullByDescribe ? 0 : (max_len >= 0 && (max_len < this.representationMaxLength || this.statement.isFetchStreams) ? max_len + 1 : this.representationMaxLength + 1);
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initForDataAccess", "charLength={0}. ", (String)null, (Throwable)null, (Object)this.charLength);
    }

    @Override
    int getInt(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return 0;
        }
        return CharCommonAccessor.stringToInt(this.getString(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    boolean getBoolean(int currentRow) throws SQLException {
        return CharCommonAccessor.stringToBoolean(this.getString(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    short getShort(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return 0;
        }
        return CharCommonAccessor.stringToShort(this.getString(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    byte getByte(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return 0;
        }
        return CharCommonAccessor.stringToByte(this.getString(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    long getLong(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return 0L;
        }
        return CharCommonAccessor.stringToLong(this.getString(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    float getFloat(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return 0.0f;
        }
        return CharCommonAccessor.stringToFloat(this.getString(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    double getDouble(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return 0.0;
        }
        return CharCommonAccessor.stringToDouble(this.getString(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    BigDecimal getBigDecimal(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return CharCommonAccessor.stringToBigDecimal(this.getString(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    BigDecimal getBigDecimal(int currentRow, int scale) throws SQLException {
        BigDecimal bd = this.getBigDecimal(currentRow);
        if (bd != null) {
            bd.setScale(scale, 6);
        }
        return bd;
    }

    @Override
    BigInteger getBigInteger(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return this.getBigDecimal(currentRow).toBigInteger();
    }

    @Override
    String getString(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        String result = this.rowData.getString(this.getOffset(currentRow), this.getLength(currentRow), this.statement.connection.conversion.getCharacterSet(this.formOfUse));
        if (result != null && this.max_len > 0 && this.max_len < result.length()) {
            return result.substring(0, this.max_len);
        }
        return result;
    }

    @Override
    Date getDate(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return CharCommonAccessor.stringToDate(this.getString(currentRow), this.statement.getDefaultCalendar(), this.getConnectionDuringExceptionHandling());
    }

    @Override
    Time getTime(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return CharCommonAccessor.stringToTime(this.getString(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    Timestamp getTimestamp(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return CharCommonAccessor.stringToTimestamp(this.getString(currentRow), this.statement.getDefaultCalendar(), this.getConnectionDuringExceptionHandling());
    }

    @Override
    java.util.Date getJavaUtilDate(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        java.util.Date date = null;
        for (String f : DATE_FORMATS) {
            SimpleDateFormat fmt = new SimpleDateFormat(f);
            try {
                date = fmt.parse(this.getString(currentRow).trim());
            }
            catch (ParseException ex) {
                continue;
            }
            if (date != null) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(date);
                if (cal.isSet(0) && cal.get(0) == 0 && cal.get(1) != 1) {
                    cal.set(1, cal.get(1) - 1);
                    date = cal.getTime();
                }
            }
            return date;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132).fillInStackTrace();
    }

    @Override
    Calendar getCalendar(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        Calendar cal = (Calendar)this.statement.getDefaultCalendar().clone();
        cal.setTime(this.getJavaUtilDate(currentRow));
        return cal;
    }

    @Override
    InputStream getAsciiStream(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        DBConversion conversion = this.statement.connection.conversion;
        int[] lengthInChars = new int[1];
        char[] chars = this.rowData.getChars(this.getOffset(currentRow), this.getLength(currentRow), conversion.getCharacterSet(this.formOfUse), lengthInChars);
        return CharCommonAccessor.charsToAsciiStream(chars, 0, lengthInChars[0], conversion, this.statement.connection);
    }

    @Override
    InputStream getUnicodeStream(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        DBConversion conversion = this.statement.connection.conversion;
        int[] lengthInChars = new int[1];
        char[] chars = this.rowData.getChars(this.getOffset(currentRow), this.getLength(currentRow), conversion.getCharacterSet(this.formOfUse), lengthInChars);
        return conversion.CharsToStream(chars, 0, lengthInChars[0] << 1, 11, this.statement.connection);
    }

    @Override
    Reader getCharacterStream(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return CharCommonAccessor.stringToReader(this.getString(currentRow));
    }

    @Override
    InputStream getBinaryStream(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return new ByteArrayInputStream(this.getBytes(currentRow));
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        return this.getString(currentRow);
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map) throws SQLException {
        return this.getString(currentRow);
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getCHAR(currentRow);
    }

    @Override
    CHAR getCHAR(int currentRow) throws SQLException {
        byte[] bytes = this.getBytes(currentRow);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        CharacterSet cs = this.statement.connection.conversion.getCharacterSet(this.formOfUse);
        return new CHAR(bytes, cs);
    }

    @Override
    URL getURL(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        try {
            return new URL(this.getString(currentRow));
        }
        catch (MalformedURLException exc) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 136).fillInStackTrace();
        }
    }

    @Override
    ROWID getROWID(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        byte[] b = this.getBytesInternal(currentRow);
        ROWID rowid = null;
        if (b != null) {
            rowid = new ROWID(b);
        }
        return rowid;
    }

    byte[] getBytesFromHexChars(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        byte[] result = this.rowData.getBytesFromHex(this.getOffset(currentRow), this.getLength(currentRow), this.statement.connection.conversion.getCharacterSet(this.formOfUse));
        if (result.length > this.charLength - 1) {
            byte[] tmp = new byte[this.charLength - 1];
            System.arraycopy(result, 0, tmp, 0, tmp.length);
            result = tmp;
        }
        return result;
    }

    @Override
    LocalDate getLocalDate(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return CharCommonAccessor.parseLocalDate(this.getString(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    LocalDateTime getLocalDateTime(int currentRow) throws SQLException {
        Object dateTime = null;
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return CharCommonAccessor.parseLocalDateTime(this.getString(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    LocalTime getLocalTime(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return CharCommonAccessor.parseLocalTime(this.getString(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    OffsetDateTime getOffsetDateTime(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return CharCommonAccessor.parseOffsetDateTime(this.getString(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    OffsetTime getOffsetTime(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return CharCommonAccessor.parseOffsetTime(this.getString(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    ZonedDateTime getZonedDateTime(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return CharCommonAccessor.parseZonedDateTime(this.getString(currentRow), this.getConnectionDuringExceptionHandling());
    }

    static byte stringToByte(String sval, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        try {
            return Byte.parseByte(sval);
        }
        catch (NumberFormatException originalFormatException) {
            try {
                return Double.valueOf(sval).byteValue();
            }
            catch (NumberFormatException e1) {
                throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 59).fillInStackTrace();
            }
        }
    }

    static short stringToShort(String sval, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        try {
            return Short.parseShort(sval);
        }
        catch (NumberFormatException originalFormatException) {
            try {
                return Double.valueOf(sval).shortValue();
            }
            catch (NumberFormatException e1) {
                throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 59).fillInStackTrace();
            }
        }
    }

    static int stringToInt(String sval, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        try {
            return Integer.parseInt(sval);
        }
        catch (NumberFormatException originalFormatException) {
            try {
                return Double.valueOf(sval).intValue();
            }
            catch (NumberFormatException e1) {
                throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 59).fillInStackTrace();
            }
        }
    }

    static long stringToLong(String sval, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        try {
            return Long.parseLong(sval);
        }
        catch (NumberFormatException originalFormatException) {
            try {
                return Double.valueOf(sval).longValue();
            }
            catch (NumberFormatException e1) {
                throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 59).fillInStackTrace();
            }
        }
    }

    static float stringToFloat(String sval, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        try {
            return Float.parseFloat(sval);
        }
        catch (NumberFormatException originalFormatException) {
            try {
                return Double.valueOf(sval).floatValue();
            }
            catch (NumberFormatException e1) {
                throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 59).fillInStackTrace();
            }
        }
    }

    static double stringToDouble(String sval, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        try {
            return Double.parseDouble(sval);
        }
        catch (NumberFormatException formatException) {
            throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 59).fillInStackTrace();
        }
    }

    static BigDecimal stringToBigDecimal(String stringValue, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        try {
            return new BigDecimal(stringValue.trim());
        }
        catch (NumberFormatException formatException) {
            throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 59).fillInStackTrace();
        }
    }

    static boolean stringToBoolean(String stringValue, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        if (stringValue == null) {
            return false;
        }
        if ((stringValue = stringValue.trim()).equals("0") || stringValue.compareToIgnoreCase("f") == 0 || stringValue.compareToIgnoreCase("false") == 0 || stringValue.compareToIgnoreCase("n") == 0 || stringValue.compareToIgnoreCase("no") == 0 || stringValue.compareToIgnoreCase("off") == 0) {
            return false;
        }
        if (stringValue.equals("1") || stringValue.compareToIgnoreCase("t") == 0 || stringValue.compareToIgnoreCase("true") == 0 || stringValue.compareToIgnoreCase("y") == 0 || stringValue.compareToIgnoreCase("yes") == 0 || stringValue.compareToIgnoreCase("on") == 0) {
            return true;
        }
        throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 59).fillInStackTrace();
    }

    static Date stringToDate(String stringValue, Calendar calendar, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        try {
            return CharCommonAccessor.parseJavaSqlDate(stringValue.trim(), calendar);
        }
        catch (IllegalArgumentException ex) {
            throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 132, null, (Throwable)ex).fillInStackTrace();
        }
    }

    private static Date parseJavaSqlDate(String strDatabaseDate, Calendar cal) throws SQLException {
        int firstDash = strDatabaseDate.indexOf(45);
        if (0 == firstDash) {
            String strPositiveDate = strDatabaseDate.substring(1);
            Date positiveDate = Date.valueOf(strPositiveDate);
            cal.setTime(positiveDate);
            cal.set(1, (cal.get(1) - 1) * -1);
            return new Date(cal.getTimeInMillis());
        }
        return Date.valueOf(strDatabaseDate);
    }

    static Time stringToTime(String stringValue, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        try {
            return Time.valueOf(stringValue.trim());
        }
        catch (IllegalArgumentException ex) {
            throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 132, null, (Throwable)ex).fillInStackTrace();
        }
    }

    static Timestamp stringToTimestamp(String stringValue, Calendar calendar, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        try {
            return CharCommonAccessor.getJavaSqlTimestamp(stringValue.trim(), calendar);
        }
        catch (IllegalArgumentException ex) {
            throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 132, null, (Throwable)ex).fillInStackTrace();
        }
    }

    private static Timestamp getJavaSqlTimestamp(String strDatabaseTimestamp, Calendar cal) throws SQLException {
        int firstDash = strDatabaseTimestamp.indexOf(45);
        if (0 == firstDash) {
            String strPositiveTimestamp = strDatabaseTimestamp.substring(1);
            Timestamp parsedTimestamp = Timestamp.valueOf(strPositiveTimestamp);
            cal.setTime(parsedTimestamp);
            cal.set(1, (cal.get(1) - 1) * -1);
            return new Timestamp(cal.getTimeInMillis());
        }
        return Timestamp.valueOf(strDatabaseTimestamp);
    }

    static InputStream charsToAsciiStream(char[] chars, int charsOffset, int charsLength, DBConversion dbConversion, Monitor monitor) throws SQLException {
        return dbConversion.CharsToStream(chars, charsOffset, charsLength, 10, monitor);
    }

    static Reader stringToReader(String stringValue) {
        return new StringReader(stringValue);
    }

    static LocalDate parseLocalDate(String dateText, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        dateText = dateText.trim();
        try {
            return LocalDate.parse(dateText);
        }
        catch (DateTimeException dateTimeException) {
            for (DateTimeFormatter f : DATE_TIME_FORMATTERS) {
                try {
                    LocalDate date = LocalDate.parse(dateText, f);
                    if (date.getYear() < 0) {
                        date = date.minusYears(-1L);
                    }
                    return date;
                }
                catch (DateTimeException dateTimeException2) {
                }
            }
            throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 132).fillInStackTrace();
        }
    }

    static LocalTime parseLocalTime(String timeText, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        timeText = timeText.trim();
        try {
            return LocalTime.parse(timeText);
        }
        catch (DateTimeException dateTimeException) {
            for (DateTimeFormatter f : DATE_TIME_FORMATTERS) {
                try {
                    return LocalTime.parse(timeText, f);
                }
                catch (DateTimeException dateTimeException2) {
                }
            }
            throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 132).fillInStackTrace();
        }
    }

    static LocalDateTime parseLocalDateTime(String dateTimeText, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        dateTimeText = dateTimeText.trim();
        try {
            return LocalDateTime.parse(dateTimeText);
        }
        catch (DateTimeException dateTimeException) {
            for (DateTimeFormatter f : DATE_TIME_FORMATTERS) {
                try {
                    LocalDateTime dateTime = LocalDateTime.parse(dateTimeText, f);
                    if (dateTime.getYear() < 0) {
                        dateTime = dateTime.minusYears(-1L);
                    }
                    return dateTime;
                }
                catch (DateTimeException dateTimeException2) {
                }
            }
            throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 132).fillInStackTrace();
        }
    }

    static OffsetDateTime parseOffsetDateTime(String offsetDateTimeText, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        offsetDateTimeText = offsetDateTimeText.trim();
        try {
            return OffsetDateTime.parse(offsetDateTimeText);
        }
        catch (DateTimeException dateTimeException) {
            for (DateTimeFormatter f : DATE_TIME_FORMATTERS) {
                try {
                    OffsetDateTime offsetDateTime = OffsetDateTime.parse(offsetDateTimeText, f);
                    if (offsetDateTime.getYear() < 0) {
                        offsetDateTime = offsetDateTime.minusYears(-1L);
                    }
                    return offsetDateTime;
                }
                catch (DateTimeException dateTimeException2) {
                }
            }
            throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 132).fillInStackTrace();
        }
    }

    static OffsetTime parseOffsetTime(String offsetTimeText, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        offsetTimeText = offsetTimeText.trim();
        try {
            return OffsetTime.parse(offsetTimeText);
        }
        catch (DateTimeException dateTimeException) {
            for (DateTimeFormatter f : DATE_TIME_FORMATTERS) {
                try {
                    return OffsetTime.parse(offsetTimeText, f);
                }
                catch (DateTimeException dateTimeException2) {
                }
            }
            throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 132).fillInStackTrace();
        }
    }

    static ZonedDateTime parseZonedDateTime(String zonedDateTimeText, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        zonedDateTimeText = zonedDateTimeText.trim();
        try {
            return ZonedDateTime.parse(zonedDateTimeText);
        }
        catch (DateTimeException dateTimeException) {
            for (DateTimeFormatter f : DATE_TIME_FORMATTERS) {
                try {
                    ZonedDateTime zonedDateTime = ZonedDateTime.parse(zonedDateTimeText, f);
                    if (zonedDateTime.getYear() < 0) {
                        zonedDateTime = zonedDateTime.minusYears(-1L);
                    }
                    return zonedDateTime;
                }
                catch (DateTimeException dateTimeException2) {
                }
            }
            throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 132).fillInStackTrace();
        }
    }
}

