/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.net.ns.NetException;

public class TcpsConfigure {
    private static final String CLASS_NAME = TcpsConfigure.class.getName();
    private static final HashSet<String> UNSUPPORTED_PROTOCOLS_SET = new HashSet();
    private static final Map<String, String[]> CONFIG_VALUE_MAP;

    private TcpsConfigure() {
    }

    public static void configure(SSLEngine sslEngine, Properties socketOptions, Diagnosable diagnosable) throws NetException {
        Object[] tlsVersions = TcpsConfigure.getTLSVersions(socketOptions, sslEngine, diagnosable);
        Object[] cipherSuites = TcpsConfigure.getCipherSuites(socketOptions, diagnosable);
        if (tlsVersions != null) {
            diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "configure", "Configuring SSL Versions = {0}", (String)null, null, (Object)Arrays.toString(tlsVersions));
            try {
                sslEngine.setEnabledProtocols((String[])tlsVersions);
            }
            catch (IllegalArgumentException e) {
                throw (NetException)new NetException(17951).initCause(e);
            }
        }
        if (cipherSuites != null) {
            diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "configure", "Configuring SSL CipherSuites = {0}", (String)null, null, (Object)Arrays.toString(cipherSuites));
            try {
                sslEngine.setEnabledCipherSuites((String[])cipherSuites);
            }
            catch (IllegalArgumentException e) {
                throw (NetException)new NetException(17953).initCause(e);
            }
        }
    }

    private static String[] getCipherSuites(Properties socketOptions, Diagnosable diagnosable) throws NetException {
        String cipherSuites = (String)socketOptions.getOrDefault((Object)7, OracleConnection.CONNECTION_PROPERTY_THIN_SSL_CIPHER_SUITES_DEFAULT);
        if (cipherSuites == null) {
            diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getCipherSuites", "No SSL CipherSuites configured", null, null);
            return null;
        }
        if ((cipherSuites = cipherSuites.trim()).startsWith("(") && cipherSuites.endsWith(")")) {
            cipherSuites = cipherSuites.substring(1, cipherSuites.length() - 1);
        }
        return cipherSuites.split("\\s*,\\s*");
    }

    private static String[] getTLSVersions(Properties socketOptions, SSLEngine engine, Diagnosable diagnosable) throws NetException {
        String versionStr = (String)socketOptions.getOrDefault((Object)6, OracleConnection.CONNECTION_PROPERTY_THIN_SSL_VERSION_DEFAULT);
        if (versionStr == null) {
            diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getTLSVersions", "No TLS versions configured. Using the default supported versions.", null, null);
            ArrayList<String> supportedVersionList = new ArrayList<String>();
            String[] allProtocols = engine.getSupportedProtocols();
            if (allProtocols == null) {
                return null;
            }
            for (String proto : allProtocols) {
                if (UNSUPPORTED_PROTOCOLS_SET.contains(proto)) continue;
                supportedVersionList.add(proto);
            }
            return supportedVersionList.toArray(new String[0]);
        }
        versionStr = versionStr.trim();
        diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getTLSVersions", "TLS Version = {0}", (String)null, null, (Object)versionStr);
        if (versionStr.startsWith("{") && versionStr.endsWith("}")) {
            diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getTLSVersions", "TLS Version config value in new format.", null, null);
            return versionStr.substring(1, versionStr.length() - 1).split("\\s*,\\s*");
        }
        if (versionStr.startsWith("(") && versionStr.endsWith(")")) {
            diagnosable.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getTLSVersions", "TLS Version config value in primitive format.", null, null);
            versionStr = versionStr.substring(1, versionStr.length() - 1);
        }
        if (!CONFIG_VALUE_MAP.containsKey(versionStr)) {
            throw new NetException(17950);
        }
        String[] supportedVersions = CONFIG_VALUE_MAP.get(versionStr);
        return supportedVersions.length == 0 ? null : supportedVersions;
    }

    static {
        UNSUPPORTED_PROTOCOLS_SET.add("SSLv3");
        UNSUPPORTED_PROTOCOLS_SET.add("SSLv2Hello");
        CONFIG_VALUE_MAP = new HashMap<String, String[]>();
        CONFIG_VALUE_MAP.put("1.2", new String[]{"TLSv1.2"});
        CONFIG_VALUE_MAP.put("1.3", new String[]{"TLSv1.3"});
        CONFIG_VALUE_MAP.put("1.2 or 1.3", new String[]{"TLSv1.2", "TLSv1.3"});
        CONFIG_VALUE_MAP.put("1.3 or 1.2", new String[]{"TLSv1.3", "TLSv1.2"});
        CONFIG_VALUE_MAP.put("0", new String[0]);
        CONFIG_VALUE_MAP.put("undetermined", new String[0]);
    }
}

