/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp;

import java.io.DataInputStream;
import java.io.IOException;
import org.jsmpp.InvalidCommandLengthException;
import org.jsmpp.PDUReader;
import org.jsmpp.bean.Command;
import org.jsmpp.util.OctetUtil;

public class DefaultPDUReader
implements PDUReader {
    @Override
    public Command readPDUHeader(DataInputStream in) throws InvalidCommandLengthException, IOException {
        Command header = new Command();
        header.setCommandLength(in.readInt());
        if (header.getCommandLength() < 16) {
            byte[] dump = new byte[header.getCommandLength()];
            if (header.getCommandLength() >= 4) {
                in.read(dump, 4, header.getCommandLength() - 4);
            }
            throw new InvalidCommandLengthException("Command length " + header.getCommandLength() + " is too short");
        }
        header.setCommandId(in.readInt());
        header.setCommandStatus(in.readInt());
        header.setSequenceNumber(in.readInt());
        return header;
    }

    @Override
    public byte[] readPDU(DataInputStream in, Command pduHeader) throws IOException {
        return this.readPDU(in, pduHeader.getCommandLength(), pduHeader.getCommandId(), pduHeader.getCommandStatus(), pduHeader.getSequenceNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readPDU(DataInputStream in, int commandLength, int commandId, int commandStatus, int sequenceNumber) throws IOException {
        byte[] b = new byte[commandLength];
        System.arraycopy(OctetUtil.intToBytes(commandLength), 0, b, 0, 4);
        System.arraycopy(OctetUtil.intToBytes(commandId), 0, b, 4, 4);
        System.arraycopy(OctetUtil.intToBytes(commandStatus), 0, b, 8, 4);
        System.arraycopy(OctetUtil.intToBytes(sequenceNumber), 0, b, 12, 4);
        if (commandLength > 16) {
            DataInputStream dataInputStream = in;
            synchronized (dataInputStream) {
                in.readFully(b, 16, commandLength - 16);
            }
        }
        return b;
    }
}

