/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryPolicy;
import com.microsoft.sqlserver.jdbc.KeyVaultCustomCredentialPolicy;
import com.microsoft.sqlserver.jdbc.KeyVaultTokenCredential;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

final class KeyVaultHttpPipelineBuilder {
    private final List<HttpPipelinePolicy> policies;
    private KeyVaultTokenCredential credential;
    private HttpLogOptions httpLogOptions;
    private final RetryPolicy retryPolicy = new RetryPolicy();

    KeyVaultHttpPipelineBuilder() {
        this.httpLogOptions = new HttpLogOptions();
        this.policies = new ArrayList<HttpPipelinePolicy>();
    }

    HttpPipeline buildPipeline() throws SQLServerException {
        ArrayList<Object> policies = new ArrayList<Object>();
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(this.retryPolicy);
        policies.add(new KeyVaultCustomCredentialPolicy(this.credential));
        policies.addAll(this.policies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).build();
    }

    KeyVaultHttpPipelineBuilder credential(KeyVaultTokenCredential credential) throws SQLServerException {
        if (null == credential) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_NullValue"));
            Object[] msgArgs1 = new Object[]{"Credential"};
            throw new SQLServerException(form.format(msgArgs1), null);
        }
        this.credential = credential;
        return this;
    }
}

