/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleShardingKey;
import oracle.ucp.jdbc.BorrowContextUpdater;
import oracle.ucp.jdbc.BorrowContextUpdaterGetter;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.UCPConnectionBuilder;
import oracle.ucp.jdbc.UCPXAConnectionBuilderImpl;
import oracle.ucp.logging.annotations.Blind;
import oracle.ucp.util.OpaqueString;

public abstract class UCPConnectionBuilderImpl
implements UCPConnectionBuilder,
BorrowContextUpdaterGetter {
    protected volatile Executor executor = ForkJoinPool.commonPool();
    private final BorrowContextUpdater borrowContextUpdater;

    @Override
    public BorrowContextUpdater getBorrowContextUpdater() {
        return this.borrowContextUpdater;
    }

    UCPConnectionBuilderImpl() {
        this.borrowContextUpdater = new BorrowContextUpdater();
    }

    UCPConnectionBuilderImpl(UCPXAConnectionBuilderImpl builder) {
        this.borrowContextUpdater = Objects.isNull(builder) ? new BorrowContextUpdater() : new BorrowContextUpdater(builder.getBorrowContextUpdater());
    }

    UCPConnectionBuilderImpl(UCPConnectionBuilderImpl builder) {
        this.borrowContextUpdater = Objects.isNull(builder) ? new BorrowContextUpdater() : new BorrowContextUpdater(builder.getBorrowContextUpdater());
    }

    @Override
    public UCPConnectionBuilder user(String user) {
        this.borrowContextUpdater.user(user);
        return this;
    }

    @Override
    public UCPConnectionBuilder password(@Blind String password) {
        this.borrowContextUpdater.password(OpaqueString.newOpaqueString(password));
        return this;
    }

    UCPConnectionBuilder internalPassword(OpaqueString password) {
        this.borrowContextUpdater.password(password);
        return this;
    }

    @Override
    public UCPConnectionBuilder labels(Properties labels) {
        this.borrowContextUpdater.labels(labels);
        return this;
    }

    @Override
    public UCPConnectionBuilder serviceName(String serviceName) {
        this.borrowContextUpdater.serviceName(null == serviceName ? null : serviceName.toLowerCase());
        return this;
    }

    @Override
    public UCPConnectionBuilder proxyProperties(int proxyType, Properties proxyProperties) {
        this.borrowContextUpdater.proxyProperties(proxyType, proxyProperties);
        return this;
    }

    @Override
    public UCPConnectionBuilder shardingKey(OracleShardingKey shardingKey) {
        this.borrowContextUpdater.shardingKey(shardingKey);
        return this;
    }

    @Override
    public UCPConnectionBuilder superShardingKey(OracleShardingKey superShardingKey) {
        this.borrowContextUpdater.superShardingKey(superShardingKey);
        return this;
    }

    @Override
    public UCPConnectionBuilder pdbRoles(Properties pdbRoles) {
        this.borrowContextUpdater.pdbRoles(pdbRoles);
        return this;
    }

    UCPConnectionBuilder sslContext(SSLContext sslContext) {
        this.borrowContextUpdater.sslContext(sslContext);
        return this;
    }

    UCPConnectionBuilder hostnameResolver(PoolDataSource.HostnameResolver hostnameResolver) {
        this.borrowContextUpdater.hostnameResolver(hostnameResolver);
        return this;
    }

    UCPConnectionBuilder readOnlyInstanceAllowed(boolean readOnlyInstanceAllowed) {
        this.borrowContextUpdater.readOnlyInstanceAllowed(readOnlyInstanceAllowed);
        return this;
    }

    @Override
    public abstract Connection build() throws SQLException;

    @Override
    public UCPConnectionBuilder executor(Executor executor) {
        if (Objects.isNull(executor)) {
            throw new IllegalArgumentException("executor should not be null");
        }
        this.executor = executor;
        return this;
    }

    @Override
    @Deprecated
    public UCPConnectionBuilder connectionWaitTimeout(int connectionWaitTimeout) {
        if (connectionWaitTimeout < 0) {
            throw new IllegalArgumentException("connection wait timeout should be >= 0");
        }
        this.borrowContextUpdater.connectionWaitDuration(Duration.ofSeconds(connectionWaitTimeout));
        return this;
    }

    @Deprecated
    Integer getConnectionWaitTimeout() {
        return Math.toIntExact(this.borrowContextUpdater.getConnectionWaitDuration().getSeconds());
    }

    @Override
    public UCPConnectionBuilder connectionWaitDuration(Duration connectionWaitDuration) {
        Objects.requireNonNull(connectionWaitDuration);
        if (connectionWaitDuration.isNegative()) {
            throw new IllegalArgumentException("connection wait duration should be 0 or positive");
        }
        this.borrowContextUpdater.connectionWaitDuration(connectionWaitDuration);
        return this;
    }
}

