/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.mapping.put;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.RequestValidators;
import org.opensearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ack.ClusterStateUpdateResponse;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MetadataMappingService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.index.Index;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.mapper.MappingTransformerRegistry;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportPutMappingAction
extends TransportClusterManagerNodeAction<PutMappingRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPutMappingAction.class);
    private final MetadataMappingService metadataMappingService;
    private final RequestValidators<PutMappingRequest> requestValidators;
    private final MappingTransformerRegistry mappingTransformerRegistry;

    @Inject
    public TransportPutMappingAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataMappingService metadataMappingService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, RequestValidators<PutMappingRequest> requestValidators, MappingTransformerRegistry mappingTransformerRegistry) {
        super("indices:admin/mapping/put", transportService, clusterService, threadPool, actionFilters, PutMappingRequest::new, indexNameExpressionResolver);
        this.metadataMappingService = metadataMappingService;
        this.requestValidators = Objects.requireNonNull(requestValidators);
        this.mappingTransformerRegistry = mappingTransformerRegistry;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(PutMappingRequest request, ClusterState state) {
        String[] indices = request.getConcreteIndex() == null ? this.indexNameExpressionResolver.concreteIndexNames(state, request) : new String[]{request.getConcreteIndex().getName()};
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indices);
    }

    @Override
    protected void clusterManagerOperation(PutMappingRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        try {
            Index[] concreteIndices = TransportPutMappingAction.resolveIndices(state, request, this.indexNameExpressionResolver);
            Optional<Exception> maybeValidationException = this.requestValidators.validateRequest(request, state, concreteIndices);
            if (maybeValidationException.isPresent()) {
                listener.onFailure(maybeValidationException.get());
                return;
            }
            ActionListener mappingTransformListener = ActionListener.wrap(transformedMapping -> {
                request.source((String)transformedMapping, MediaTypeRegistry.JSON);
                TransportPutMappingAction.performMappingUpdate(concreteIndices, request, listener, this.metadataMappingService);
            }, arg_0 -> listener.onFailure(arg_0));
            this.mappingTransformerRegistry.applyTransformers(request.source(), null, (ActionListener<String>)mappingTransformListener);
        }
        catch (IndexNotFoundException ex) {
            logger.debug(() -> new ParameterizedMessage("failed to put mappings on indices [{}]", Arrays.asList(request.indices())), (Throwable)((Object)ex));
            throw ex;
        }
    }

    static Index[] resolveIndices(ClusterState state, PutMappingRequest request, IndexNameExpressionResolver iner) {
        if (request.getConcreteIndex() == null) {
            if (request.writeIndexOnly()) {
                ArrayList<Index> indices = new ArrayList<Index>();
                for (String indexExpression : request.indices()) {
                    indices.add(iner.concreteWriteIndex(state, request.indicesOptions(), indexExpression, request.indicesOptions().allowNoIndices(), request.includeDataStreams()));
                }
                return indices.toArray(Index.EMPTY_ARRAY);
            }
            return iner.concreteIndices(state, request);
        }
        return new Index[]{request.getConcreteIndex()};
    }

    static void performMappingUpdate(final Index[] concreteIndices, PutMappingRequest request, final ActionListener<AcknowledgedResponse> listener, MetadataMappingService metadataMappingService) {
        PutMappingClusterStateUpdateRequest updateRequest = (PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)new PutMappingClusterStateUpdateRequest(request.source()).indices(concreteIndices)).ackTimeout(request.timeout())).clusterManagerNodeTimeout(request.clusterManagerNodeTimeout());
        metadataMappingService.putMapping(updateRequest, new ActionListener<ClusterStateUpdateResponse>(){

            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse((Object)new AcknowledgedResponse(response.isAcknowledged()));
            }

            public void onFailure(Exception t) {
                logger.debug(() -> new ParameterizedMessage("failed to put mappings on indices [{}]", Arrays.asList(concreteIndices)), (Throwable)t);
                listener.onFailure(t);
            }
        });
    }
}

