/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.common.annotation.PublicApi;

@PublicApi(since="1.0.0")
public interface LocalNodeClusterManagerListener
extends ClusterStateListener {
    public void onClusterManager();

    public void offClusterManager();

    @Override
    default public void clusterChanged(ClusterChangedEvent event) {
        boolean wasClusterManager = event.previousState().nodes().isLocalNodeElectedClusterManager();
        boolean isClusterManager = event.localNodeClusterManager();
        if (!wasClusterManager && isClusterManager) {
            this.onClusterManager();
        } else if (wasClusterManager && !isClusterManager) {
            this.offClusterManager();
        }
    }
}

