/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.bucket.range.InternalRange;
import org.opensearch.search.aggregations.bucket.range.RangeAggregator;
import org.opensearch.search.aggregations.bucket.range.RangeAggregatorSupplier;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.internal.SearchContext;

public class AbstractRangeAggregatorFactory<R extends RangeAggregator.Range>
extends ValuesSourceAggregatorFactory {
    private final InternalRange.Factory<?, ?> rangeFactory;
    private final R[] ranges;
    private final boolean keyed;
    private final ValuesSourceRegistry.RegistryKey<RangeAggregatorSupplier> registryKey;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder, ValuesSourceRegistry.RegistryKey<RangeAggregatorSupplier> registryKey) {
        builder.register(registryKey, List.of(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), RangeAggregator::new, true);
    }

    public AbstractRangeAggregatorFactory(String name, ValuesSourceRegistry.RegistryKey<RangeAggregatorSupplier> registryKey, ValuesSourceConfig config, R[] ranges, boolean keyed, InternalRange.Factory<?, ?> rangeFactory, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.ranges = ranges;
        this.keyed = keyed;
        this.rangeFactory = rangeFactory;
        this.registryKey = registryKey;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new RangeAggregator.Unmapped(this.name, this.factories, this.ranges, this.keyed, this.config.format(), searchContext, parent, this.rangeFactory, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.queryShardContext.getValuesSourceRegistry().getAggregator(this.registryKey, this.config).build(this.name, this.factories, (ValuesSource.Numeric)this.config.getValuesSource(), this.config.format(), this.rangeFactory, (RangeAggregator.Range[])this.ranges, this.keyed, searchContext, parent, cardinality, metadata, this.config);
    }

    @Override
    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

